% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametricbootstrap.R
\name{parametricbootstrap}
\alias{parametricbootstrap}
\title{Parametric bootstrap for Julia mixed effects models}
\usage{
parametricbootstrap(x, nsim, seed, ..., ftol_rel = 1e-08)
}
\arguments{
\item{x}{A Julia MixedModel of class \code{jlme}}

\item{nsim}{Number of simulations}

\item{seed}{Seed for the random number generator (Random.MersenneTwister)}

\item{...}{Not implemented}

\item{ftol_rel}{A convergence criterion. Defaults to a reduced-precision
target of 1e-8.}
}
\value{
MixedModels.parametricboostrap() output as object of class \code{jlmeboot}
}
\description{
Parametric bootstrap for Julia mixed effects models
}
\examples{
\donttest{
jlme_setup(restart = TRUE)

jmod <- jlmer(Reaction ~ Days + (Days | Subject), lme4::sleepstudy)
tidy(jmod)

samp <- parametricbootstrap(jmod, nsim = 100L, seed = 42L)
samp

tidy(samp)

stop_julia()
}
}
