% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoSegment.R
\name{annoSegment}
\alias{annoSegment}
\title{annoSegment}
\arguments{
\item{object}{Your ggplot list. Default(NULL).}

\item{relSideDist}{The relative distance ratio to the y axis range. Default(0.1).}

\item{aesGroup}{Whether use your group column to add rect annotation. Default("FALSE").}

\item{aesGroName}{The mapping column name. Default(NULL).}

\item{annoPos}{The position for the annotation to be added. Default("top").}

\item{xPosition}{The x axis coordinate for the segment. Default(NULL).}

\item{yPosition}{The y axis coordinate for the segment. Default(NULL).}

\item{pCol}{The segment colors. Default(NULL).}

\item{segWidth}{The relative segment width. Default(1).}

\item{lty}{The segment line type. Default(NULL).}

\item{lwd}{The segment line width. Default(NULL).}

\item{alpha}{The segment color alpha. Default(NULL).}

\item{lineend}{The segment line end. Default("square").}

\item{annoManual}{Whether annotate by yourself by supplying with x and y coordinates. Default(FALSE).}

\item{mArrow}{Whether add segment arrow. Default(FALSE).}

\item{addBranch}{Whether add segment branch. Default(FALSE).}

\item{bArrow}{Whether add branch arrow. Default(FALSE).}

\item{branDirection}{The branch direction. Default(1).}

\item{branRelSegLen}{The branch relative length to the segment. Default(0.3).}

\item{addText}{Whether add text label on segment. Default(FALSE).}

\item{textCol}{The text colors. Default(NULL).}

\item{textSize}{The text size. Default(NULL).}

\item{fontfamily}{The text fontfamily. Default(NULL).}

\item{fontface}{The text fontface. Default(NULL).}

\item{textLabel}{The text textLabel. Default(NULL).}

\item{textRot}{The text angle. Default(NULL).}

\item{textHVjust}{The text distance from the segment. Default(0.2).}

\item{hjust}{The text hjust. Default(NULL).}

\item{vjust}{The text vjust. Default(NULL).}

\item{myFacetGrou}{Your facet group name to be added with annotation when object is a faceted object. Default(NULL).}

\item{aes_x}{= NULL You should supply the plot X mapping name when annotate a facetd plot. Default(NULL).}

\item{aes_y}{= NULL You should supply the plot Y mapping name when annotate a facetd plot. Default(NULL).}
}
\value{
Return a ggplot object.
}
\description{
This function is used to add segment annotations in plot.
}
\examples{
# ===============================
# test function

# load data
data(p)
data(pdot)

# default plot
annoSegment(object = p,
           annoPos = 'top',
           xPosition = c(1:10))

# adjust rectWidth
annoSegment(object = p,
           annoPos = 'top',
           xPosition = c(1:10),
           segWidth = 0.8)

# add branch
annoSegment(object = pdot,
           annoPos = 'top',
           annoManual = TRUE,
           xPosition = list(c(1,3,4,7,9,11,12,15,17,19,20),
                            c(2,3,6,8,10,11,14,16,18,19,21)),
           yPosition = 9,
           segWidth = 0.8,
           pCol = rep('black',11),
           addBranch = TRUE,
           branDirection = -1,
           lwd = 3)
}
\author{
Junjun Lao
}
