\name{plot.jeek}
\alias{plot.jeek}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plotting functions for displaying the list of multiple graphs generated by the jeek algorithm
}
\description{
This function plots the networks or the neighborhood networks for a certain node. Please run demo(jeekDemo) to learn the basic functions provided by this package. For further details, please read the original paper: Beilun Wang, Arshdeep Sekhon, Yanjun Qi (2018).
}
\usage{
  \method{plot}{jeek}(x, type="graph", subID=NULL, index=NULL, ...)
}
\arguments{
  \item{x}{
    jeek object
  }
  \item{type}{
    Plotting type. This argument defines which type of network(s) to plot. There are four options:
    "graph": plot the networks. The different colors represent the different graphs.


    "neighbor": plot the neighborhood networks for a given node. The different colors represent the different graphs.
  }
  \item{subID}{
    If \code{type="sub"}, \code{subID} indicates to plot the network for the task whose index == subID.
  }
  \item{index}{
    If \code{type="neighbor"}, \code{index} indicates the row number of the node to be investigated. This function plots its neighborhood networks in each graph of the multiple graphs generated by jeek algorithm.
  }
  \item{...}{
    Additional arguments to pass to plot function
  }
}
\details{
  Plotting function for jeek objects. It can be used to plot results obtained from running the jeek algorithm.
}
\references{
Beilun Wang, Arshdeep Sekhon, Yanjun Qi. A Fast and Scalable Joint Estimator for Integrating Additional Knowledge in Learning Multiple Related Sparse Gaussian Graphical Models. ICML 2018
}
\author{
  Beilun Wang and Yanjun Qi
}
\seealso{
  \code{\link{jeek}}
}
\examples{
data(cancer)
X = list(as.matrix(cancer[[1]][which(cancer[[2]] == "not"),]),
as.matrix(cancer[[1]][which(cancer[[2]] == "pcr"),]))
results = jeek(X, 0.05, covType = "cov", parallel = FALSE)
plot.jeek(results)
plot.jeek(results, type="neighbor", index=10)
}
\keyword{ jeek }
