% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaod_article.R
\name{jaod_article}
\alias{jaod_article}
\title{Get an article by ID}
\usage{
jaod_article(id, ...)
}
\arguments{
\item{id}{(character) a DOAJ article ID, a UUID. Note, this
is not a DOI, but you can use \code{\link[=jaod_article_search]{jaod_article_search()}} to search by ISSN to
get DOAJ article ids}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}},
see \code{?curl::curl_options} for help on curl options}
}
\value{
a named list, with slots admin, last_updated, id, created_date,
and bibjson
}
\description{
Get an article by ID
}
\examples{
\dontrun{
out <- jaod_article(id = "0005e11ec616453f854070069385e057")
out$admin
out$last_updated
out$id
out$created_date
out$bibjson

ids <- c("73f781ad57094b98a0b46d8903fdc2c2",
  "0005e11ec616453f854070069385e057")
out <- lapply(ids, jaod_article)
out[[1]]
}
}
