% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{vgrep}
\alias{vgrep}
\title{grep, returning values}
\usage{
vgrep(..., value = TRUE, ignore.case = FALSE)
}
\arguments{
\item{..., value, ignore.case}{parameters sent to \code{base::grep()}}
}
\value{
vector of matching values
}
\description{
grep, returning values
}
\details{
This function is a simple wrapper around \code{base::grep()} which
returns matching values. It is
particularly helpful when grabbing values from a vector, but where the
case (uppercase or lowercase) is known.
}
\examples{
V <- paste0(LETTERS[1:5], LETTERS[4:8]);
vgrep("D", V);
vgrep("d", V);
vigrep("d", V);

}
\seealso{
Other jam grep functions: 
\code{\link{grepls}()},
\code{\link{igrep}()},
\code{\link{igrepHas}()},
\code{\link{igrepl}()},
\code{\link{provigrep}()},
\code{\link{unigrep}()},
\code{\link{unvigrep}()},
\code{\link{vigrep}()}
}
\concept{jam grep functions}
