% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{check_Rhat}
\alias{check_Rhat}
\title{Quick summary of Rhat values by parameter name}
\usage{
check_Rhat(x, thresh = 1.1)
}
\arguments{
\item{x}{Output object from \code{jagsUI::jags()}}

\item{thresh}{Threshold value (defaults to 1.1)}
}
\value{
Numeric (named) giving the proportion of Rhat values below the given threshold.
}
\description{
Returns the mean number of \code{Rhat} values for each parameter (by each parameter)
that are less than a specified threshold criterion.

\code{Rhat} (Gelman-Rubin Convergence Diagnostic, or Potential Scale Reduction Factor)
is calculated within 'JAGS', and is
commonly used as a measure of convergence for a given parameter node.  Values close
to 1 are seen as evidence of adequate convergence.
}
\examples{
check_Rhat(SS_out)
}
\references{
Gelman, A., & Rubin, D. B. (1992). Inference from Iterative Simulation
Using Multiple Sequences. \emph{Statistical Science, 7}(4), 457–472. http://www.jstor.org/stable/2246093
}
\seealso{
\link{check_neff}, \link{traceworstRhat}, \link{plotRhats}, \link{qq_postpred}, \link{ts_postpred}
}
\author{
Matt Tyers
}
