% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfacorpcor.R
\name{dev.R}
\alias{dev.R}
\title{Compute Deviance for Logistic Factors}
\usage{
dev.R(dat, LFr1, LFr0 = NULL, p = FALSE)
}
\arguments{
\item{dat}{a matrix with \code{m} rows and \code{n} columns.}

\item{LFr1}{alternative logistic factors (an output from lfa or lfa.corpcor)}

\item{LFr0}{null logistic factors (an output from lfa or lfa.corpcor)}

\item{p}{estimate p-values (by default, 'FALSE')}
}
\value{
When {p=FALSE} (by default), \code{dev.R} returns a vector of \code{m} deviances.

When {p=TRUE}, a list consisting of
\item{dev}{the \code{m} deviances}
\item{p.value}{the \code{m} p-values based on a chisq distribution}
}
\description{
This function computes deviance between the full model and the null (intercept-only) model.
It uses built-in R functions, namely \code{glm}; slow but no C++ dependencies.
Make sure that \code{LFr1} and \code{LFr0} do not have intercept terms.
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
