% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Polynomials.R
\name{JackPol}
\alias{JackPol}
\title{Jack polynomial}
\usage{
JackPol(n, lambda, alpha, algorithm = "DK", basis = "canonical")
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{alpha}{parameter of the Jack polynomial, always a positive number
for \code{algorithm = "DK"}, a positive number or a positive \code{bigq}
rational number for \code{algorithm = "naive"}}

\item{algorithm}{the algorithm used, either \code{"DK"} or \code{"naive"}}

\item{basis}{the polynomial basis for \code{algorithm = "naive"},
either \code{"canonical"} or \code{"MSF"} (monomial symmetric functions);
for \code{algorithm = "DK"} the canonical basis is always used and
this parameter is ignored}
}
\value{
A polynomial (\code{mvp} object; see \link[mvp]{mvp-package}).
}
\description{
Returns the Jack polynomial.
}
\examples{
JackPol(3, lambda = c(3,1), alpha = gmp::as.bigq(2,3),
                  algorithm = "naive")
JackPol(3, lambda = c(3,1), alpha = 2/3, algorithm = "DK")
JackPol(3, lambda = c(3,1), alpha= gmp::as.bigq(2,3),
        algorithm = "naive", basis = "MSF")
}
