% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3d_plot.R
\name{plot_3d_beta}
\alias{plot_3d_beta}
\title{Plot ivdoctr Restrictions}
\usage{
plot_3d_beta(
  y_name,
  T_name,
  z_name,
  data,
  controls = NULL,
  r_TstarU_restriction = c(-1, 1),
  k_restriction = c(0, 1),
  n_grid = 30,
  n_colors = 500,
  fence = NULL,
  gray_k = NULL,
  gray_rTstarU = NULL,
  theta = 0,
  phi = 15
)
}
\arguments{
\item{y_name}{Character string with the column name of the dependent variable}

\item{T_name}{Character string with the column name of the endogenous regressor(s)}

\item{z_name}{Character string with the column name of the instrument(s)}

\item{data}{Data frame}

\item{controls}{Vector of character strings specifying the exogenous variables}

\item{r_TstarU_restriction}{2-element vector of bounds for r_TstarU}

\item{k_restriction}{2-element vector of bounds for kappa}

\item{n_grid}{Number of points to put in grid}

\item{n_colors}{Number of colors to use}

\item{fence}{Vector of left, bottom, right, and top corners of rectangle}

\item{gray_k}{2-element vector of kappa restrictions to recolor graph as gray}

\item{gray_rTstarU}{2-element vector of rTstarU restrictions to recolor graph as gray}

\item{theta}{Graphing parameters for orienting plot}

\item{phi}{Graphing parameters for orienting plot}
}
\value{
Interactive 3d plot which can be oriented and saved using rgl.snapshot()
}
\description{
Plot ivdoctr Restrictions
}
\examples{
library(ivdoctr)
endog <- matrix(c(0, 0.9), nrow = 1)
meas <- matrix(c(0.6, 1), nrow = 1)

plot_3d_beta(y_name = "logpgp95", T_name = "avexpr",
            z_name = "logem4", data = colonial,
            r_TstarU_restriction = endog,
            k_restriction = meas)

}
