% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_cmcc_bioclim.R
\name{future_cmcc_bioclim}
\alias{future_cmcc_bioclim}
\title{Download future Bioclimatic indicators (BIOs) named CMCC-BioClimInd.}
\usage{
future_cmcc_bioclim(
  bry = NULL,
  path = NULL,
  esm = "CMCC-CESM",
  rcp = 85,
  interval = "2040-2079",
  nm_mark = "clip",
  return_stack = TRUE
)
}
\arguments{
\item{bry}{(\code{\link{sf}} or \code{sp}) The boundary to mask the
downloaded original data. If \code{NULL}, it would get global map.
If not \code{NULL}, it can take \code{\link{sf}}, \code{\link{sfc}},
\code{SpatialPolygonsDataFrame}, \code{SpatialPolygons}, etc.
The default is \code{NULL}.}

\item{path}{(\code{character}) The path to save the downloaded imagery.
If \code{NULL}, it would use the current working directory.
The default is \code{NULL}.}

\item{esm}{(\code{character}) The option for Earth System Models (ESMs).
Should be one of "CMCC-CESM", 'GFDL-ESM2M', 'HadGEM2-ES',
'IPSL-CM5A-LR', 'MIROC-ESM-CHEM', 'NorESM1-M'.
The default is CMCC-CESM.}

\item{rcp}{(\code{numeric}) The option of Representative Concentration
Pathways (RCPs).
Should be 45 or 85. Only 85 is available for CMCC-CESM. The default is 85.}

\item{interval}{(\code{character}) The option for time interval.
Should be one of "2040-2079", "2060-2099". The default is "2040-2079".}

\item{nm_mark}{(\code{character}) the name mark of clipped images.
The default is "clip". It would be ignored if \code{bry} is \code{NULL}.}

\item{return_stack}{(\code{logical}) if \code{TRUE}, stack the imagery
together and return.
If the area is large and resolution is high, it is better not to stack them.
The default is \code{TRUE}.}
}
\value{
if \code{return_stack} is \code{TRUE}, the images would be
returned as a \code{stars}. Otherwise, nothing to return, but the user
would receive a message of where the images are.
}
\description{
Parse future CMCC-BioClimInd bioclimatic indicators obtained by
different Earth System Models (ESMs) optionally with a setting of boundary
and a few other options.
}
\details{
\url{https://doi.pangaea.de/10.1594/PANGAEA.904278?format=html#download}
}
\note{
The function is experimental at the moment, because the download server
of this dataset is not as stable as Worldclim yet. If it fails due to slow
internet, try to set a larger timeout option,
e.g., using \code{options(timeout = 1e3)}.
}
\examples{
\dontrun{
library(itsdm)
future_cmcc_bioclim(path = tempdir(),
  esm = 'GFDL-ESM2M', rcp = 45,
  interval = "2040-2079", return_stack = FALSE)
}

}
\references{
Noce, Sergio, Luca
Caporaso, and Monia Santini."A new global dataset of bioclimatic indicators.
"\emph{Scientific data} 7.1 (2020): 1-12.\doi{10.1038/s41597-020-00726-5}
}
