% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{move_n_point}
\alias{move_n_point}
\title{Move a vector n elements forward or backward.}
\usage{
move_n_point(x, n = 1, na_value = NA)
}
\arguments{
\item{x}{A vector.}

\item{n}{Number indicating how many steps the vector should shift forward 
(N > 0) or backward (n < 0).}

\item{na_value}{The value to replace the empty cells with (e.g., the first 
or last points). Defaults to NA.}
}
\value{
A vector with the same length of \code{x}, all moved \code{n} steps.
}
\description{
Move a vector n elements forward or backward.
}
\examples{
data(simdat)
(test <- simdat[1:20,])
test$Y.prev <- move_n_point(test$Y)
test$change <- test$Y - test$Y.prev
test$Y.post5 <- move_n_point(test$Y, n=-5)

emptyPlot(nrow(test), range(test$Y))
lines(test$Y)
lines(test$Y.prev, col='red')
lines(test$Y.post5, col='blue')

}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions: \code{\link{convertNonAlphanumeric}},
  \code{\link{diff_terms}}, \code{\link{findAbsMin}},
  \code{\link{find_difference}},
  \code{\link{find_n_neighbors}}, \code{\link{getDec}},
  \code{\link{getRange}}, \code{\link{group_sort}},
  \code{\link{list2str}}, \code{\link{missing_est}},
  \code{\link{print_summary}}, \code{\link{se}},
  \code{\link{summary_data}}, \code{\link{timeBins}}
}

