% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictions.R
\name{get_difference}
\alias{get_difference}
\title{Get model predictions for differences between conditions.}
\usage{
get_difference(model, comp, cond = NULL, rm.ranef = NULL, se = TRUE,
  f = 1.96, print.summary = getOption("itsadug_print"))
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{comp}{A named list with the two levels to compare.}

\item{cond}{A named list of the values to use for the other predictor
terms. Variables omitted from this list will have the closest observed
value to the median for continuous variables, or the reference level for
factors.}

\item{rm.ranef}{Logical: whether or not to remove random effects.
Default is FALSE. Alternatively a string (or vector of strings) with the
name of the random effect(s) to remove.
(See notes.)}

\item{se}{Logical: whether or not to return the confidence interval or
standard error around the estimates.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting
in 95\% confidence intervals. For 99\% confidence intervals use a value of
2.58.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor.
Default set to the print info messages option
(see \code{\link{infoMessages}}).}
}
\value{
Returns a data frame with the estimates of the difference and
optionally the confidence intervals around that estimate.
}
\description{
Get model predictions for differences between conditions.
}
\section{Notes}{

Other, not specified effects and random effects are generally canceled
out, when calculating the difference. When the predictors that
specify the conditions to compare are involved in other interactions
or included as random slopes, it may be useful to specify the values
of other predictors with \code{cond} or remove the random effects with
\code{rm.ranef}.
}
\examples{
data(simdat)

# first fit a simple model:
m1 <- bam(Y ~ Group+te(Time, Trial, by=Group), data=simdat)

# get difference estimates:
diff <- get_difference(m1, comp=list(Group=c('Adults', 'Children')),
    cond=list(Time=seq(0,500,length=100)))
head(diff)
}
\author{
Jacolien van Rij, Martijn Wieling
}
\seealso{
Other functions for model predictions: \code{\link{get_coefs}};
  \code{\link{get_modelterm}};
  \code{\link{get_predictions}}; \code{\link{get_random}};
  \code{\link{inspect_random}}; \code{\link{plotsurface}}
}

