% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_radiograph.r
\name{itrax_radiograph}
\alias{itrax_radiograph}
\title{Read an Itrax Radiograph File}
\usage{
itrax_radiograph(
  file = "radiograph.tif",
  meta = "document.txt",
  plot = FALSE,
  trim = TRUE
)
}
\arguments{
\item{file}{defines the name of the datafile to parse}

\item{meta}{defines the relating metadata}

\item{plot}{would you like to create a plot as a side-effect?}

\item{trim}{defines positions of the trim if required, input is a vector with min and max positions}
}
\value{
a matrix of RGB values, and the relevant data from the metadata file relating to the image.
Also computes the aspect ratio of the image.
}
\description{
Reads an Itrax radiograph file and trims it according to the metadata provided.
}
\examples{
itrax_radiograph(file = system.file("extdata",
                         "CD166_19_S1_radiograph_adj.tif",
                         package = "itraxR",
                         mustWork = TRUE),
                 meta = system.file("extdata",
                         "CD166_19_S1_rad_document.txt",
                         package = "itraxR",
                         mustWork = TRUE),
                 plot = TRUE)

}
