% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators_indicators_systems.R
\name{get_indicators_systems_code_instances}
\alias{get_indicators_systems_code_instances}
\title{Get indicators system code instances}
\usage{
get_indicators_systems_code_instances(indicatorSystemCode, q = NULL,
  order = NULL, limit = 25, offset = 0, fields = NULL,
  representation = NULL, granularity = NULL)
}
\arguments{
\item{indicatorSystemCode}{(string) with an indicator system code}

\item{q}{(string) Query of metadata on which the searches can be built are:
\code{id} and \code{geographicalValue}.}

\item{order}{(string) Order. Possible values are: \code{update} and
\code{id} and order criteria are \code{ASC} and \code{DESC}.}

\item{limit}{(int) Results limit. By default \code{limit = 25}.}

\item{offset}{(int) Displacement. Result from which it is returned.  By default \code{offset = 0}.}

\item{fields}{(string) Use of the answer by adding new fields.
Possible values are: \code{+metadata}, \code{+data} and \code{+observationsMetadata}.}

\item{representation}{(string) Allows filtering the observations by their value.
Its use only makes sense when \code{+data} and/or \code{+observationsMetadata} has been included.}

\item{granularity}{(string) Allows to filter the observations through the
granularities of the same. Its use only makes sense when \code{+data} and/or
\code{+observationsMetadata} has been included.}
}
\description{
This function returns instances of indicators associated
 with a specific indicator system. An instance of an indicator is nothing
 more than a spatio-temporal query of an indicator when it is incorporated
 into a specific indicator system.
}
\examples{
get_indicators_systems_code_instances("C00075H")
get_indicators_systems_code_instances("C00075H", q = 'id EQ "INDICADORES_MUNICIPALES"')
}
