% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{set_specie}
\alias{set_specie}
\title{Constructor of Instances of the Specie Class}
\usage{
set_specie(data, meiosis = NULL)
}
\arguments{
\item{data}{A data frame with the map of the Genome to be simulates.}

\item{meiosis}{A pointer to a C++ function of the meiosis process.}
}
\value{
Objects of R6 class with methods to mimic in silico Genomes.
}
\description{
Constructor of instances of the Specie class given the map of
    the genome and optionally a pointer to a C++ function which will drive
    the meiosis process.
}
\examples{
data(ToyMap)
spc_standard <- set_specie(ToyMap)

## generate standard _de novo_ variability
spc_standard$gamete(n = 100)

\dontrun{
## write your function is C++ and then wrap it as a pointer
Meiosis <- "
// [[Rcpp::depends(isqg)]]

# include <isqg.h> // loading headers of the package
# include <vector>
# include <algorithm>

// NOTE:
// loci are independent to each other
Map meiosis(Chromosome * group) {

  Map map(group->get_map()) ;

  for (auto it = 0; it < map.size(); it++)
    if (static_cast<bool>(R::rbinom(1., .5))) map.at(it) = 2. + 1. ;

  map.erase(std::remove(map.begin(), map.end(), 2. + 1.), map.end());

  return map ;

}

// wrap the function as external pointer
// [[Rcpp::export]]
MPtr myMeiosis() { return MPtr(new FPtrM(& meiosis), true) ; }
"

## compile the code
Rcpp::sourceCpp(code = Meiosis, rebuild = TRUE)

## define a specie w/ custom meiosis
spp_custom <- set_specie(ToyMap, meiosis = myMeiosis())

## check meiosis process
spp_custom$gamete(n = 100)
}

}
