% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_size_family}
\alias{set_size_family}
\title{Set the distribution family for observed sizes}
\usage{
set_size_family(nm, family, by_compartment, quiet = FALSE, quiet_reset = FALSE)
}
\arguments{
\item{nm}{A \code{networkModel} object (output from
\code{\link{new_networkModel}}).}

\item{family}{Allowed values are "normal_cv" and "normal_sd".}

\item{by_compartment}{Boolean, if TRUE then zeta is compartment-specific.}

\item{quiet}{Boolean, if \code{FALSE} print a message indicating which
distribution family is used for proportions.}

\item{quiet_reset}{Boolean, write a message when model parameters (and
covariates and priors) are reset?}
}
\value{
A \code{networkModel} object.
}
\description{
Set the distribution family for observed sizes
}
\examples{
library(magrittr)

m <- new_networkModel() \%>\%
  set_topo(links = "NH4, NO3 -> epi -> pseph, tricor")
m <- m \%>\% set_size_family("normal_sd")
m
attr(m, "size_family")

m <- m \%>\% set_size_family(by_compartment = TRUE)
attr(m, "size_zeta_per_compartment")

}
