// Generated by rstantools.  Do not edit by hand.

/*
    myPkg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    myPkg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with myPkg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_networkModel_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_networkModel");
    reader.add_event(963, 961, "end", "model_networkModel");
    return reader;
}
template <typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T7__>::type, Eigen::Dynamic, Eigen::Dynamic>
buildTransferMatrix(const int& nComps,
                        const int& nSteady,
                        const std::vector<int>& steadyIndices,
                        const int& nUpsilons,
                        const std::vector<std::vector<int> >& mappingU,
                        const int& nLambdas,
                        const std::vector<std::vector<int> >& mappingL,
                        const std::vector<T7__>& params, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T7__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 71;
        validate_non_negative_index("transfer", "nComps", nComps);
        validate_non_negative_index("transfer", "nComps", nComps);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transfer(nComps, nComps);
        stan::math::initialize(transfer, DUMMY_VAR__);
        stan::math::fill(transfer, DUMMY_VAR__);
        stan::math::assign(transfer,rep_matrix(0, nComps, nComps));
        current_statement_begin__ = 72;
        validate_non_negative_index("lossRates", "nComps", nComps);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lossRates(nComps);
        stan::math::initialize(lossRates, DUMMY_VAR__);
        stan::math::fill(lossRates, DUMMY_VAR__);
        stan::math::assign(lossRates,rep_vector(0, nComps));
        current_statement_begin__ = 73;
        for (int k = 1; k <= nUpsilons; ++k) {
            current_statement_begin__ = 74;
            stan::model::assign(transfer, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 2, "mappingU", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 1, "mappingU", 2)), stan::model::nil_index_list())), 
                        get_base1(params, get_base1(get_base1(mappingU, k, "mappingU", 1), 3, "mappingU", 2), "params", 1), 
                        "assigning variable transfer");
            current_statement_begin__ = 75;
            stan::model::assign(lossRates, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 1, "mappingU", 2)), stan::model::nil_index_list()), 
                        (stan::model::rvalue(lossRates, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 1, "mappingU", 2)), stan::model::nil_index_list()), "lossRates") + get_base1(params, get_base1(get_base1(mappingU, k, "mappingU", 1), 3, "mappingU", 2), "params", 1)), 
                        "assigning variable lossRates");
        }
        current_statement_begin__ = 77;
        for (int k = 1; k <= nLambdas; ++k) {
            current_statement_begin__ = 78;
            stan::model::assign(lossRates, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingL, k, "mappingL", 1), 1, "mappingL", 2)), stan::model::nil_index_list()), 
                        (stan::model::rvalue(lossRates, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingL, k, "mappingL", 1), 1, "mappingL", 2)), stan::model::nil_index_list()), "lossRates") + get_base1(params, get_base1(get_base1(mappingL, k, "mappingL", 1), 2, "mappingL", 2), "params", 1)), 
                        "assigning variable lossRates");
        }
        current_statement_begin__ = 80;
        for (int k = 1; k <= nComps; ++k) {
            current_statement_begin__ = 81;
            stan::model::assign(transfer, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                        (stan::model::rvalue(transfer, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "transfer") - get_base1(lossRates, k, "lossRates", 1)), 
                        "assigning variable transfer");
        }
        current_statement_begin__ = 84;
        if (as_bool(logical_gt(nSteady, 0))) {
            current_statement_begin__ = 85;
            for (int k = 1; k <= nSteady; ++k) {
                current_statement_begin__ = 86;
                stan::model::assign(transfer, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(steadyIndices, k, "steadyIndices", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(steadyIndices, k, "steadyIndices", 1)), stan::model::nil_index_list())), 
                            0, 
                            "assigning variable transfer");
            }
        }
        current_statement_begin__ = 89;
        return stan::math::promote_scalar<fun_return_scalar_t__>(transfer);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct buildTransferMatrix_functor__ {
    template <typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T7__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& nComps,
                        const int& nSteady,
                        const std::vector<int>& steadyIndices,
                        const int& nUpsilons,
                        const std::vector<std::vector<int> >& mappingU,
                        const int& nLambdas,
                        const std::vector<std::vector<int> >& mappingL,
                        const std::vector<T7__>& params, std::ostream* pstream__) const {
        return buildTransferMatrix(nComps, nSteady, steadyIndices, nUpsilons, mappingU, nLambdas, mappingL, params, pstream__);
    }
};
template <typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
buildTransferMatrixDecay(const int& nComps,
                             const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& transferRef,
                             const T2__& lambda_decay, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 114;
        validate_non_negative_index("transfer", "nComps", nComps);
        validate_non_negative_index("transfer", "nComps", nComps);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transfer(nComps, nComps);
        stan::math::initialize(transfer, DUMMY_VAR__);
        stan::math::fill(transfer, DUMMY_VAR__);
        stan::math::assign(transfer,transferRef);
        current_statement_begin__ = 115;
        for (int k = 1; k <= nComps; ++k) {
            current_statement_begin__ = 116;
            stan::model::assign(transfer, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                        (stan::model::rvalue(transfer, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "transfer") - lambda_decay), 
                        "assigning variable transfer");
        }
        current_statement_begin__ = 118;
        return stan::math::promote_scalar<fun_return_scalar_t__>(transfer);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct buildTransferMatrixDecay_functor__ {
    template <typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& nComps,
                             const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& transferRef,
                             const T2__& lambda_decay, std::ostream* pstream__) const {
        return buildTransferMatrixDecay(nComps, transferRef, lambda_decay, pstream__);
    }
};
template <typename T5__, typename T6__>
Eigen::Matrix<typename boost::math::tools::promote_args<T5__, T6__>::type, Eigen::Dynamic, Eigen::Dynamic>
buildTransitionMatrix(const int& nComps,
                          const int& nUpsilons,
                          const std::vector<std::vector<int> >& mappingU,
                          const int& nLambdas,
                          const std::vector<std::vector<int> >& mappingL,
                          const T5__& dt,
                          const std::vector<T6__>& params, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T5__, T6__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 172;
        validate_non_negative_index("transition", "nComps", nComps);
        validate_non_negative_index("transition", "nComps", nComps);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transition(nComps, nComps);
        stan::math::initialize(transition, DUMMY_VAR__);
        stan::math::fill(transition, DUMMY_VAR__);
        stan::math::assign(transition,rep_matrix(0, nComps, nComps));
        current_statement_begin__ = 173;
        validate_non_negative_index("lossRates", "nComps", nComps);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lossRates(nComps);
        stan::math::initialize(lossRates, DUMMY_VAR__);
        stan::math::fill(lossRates, DUMMY_VAR__);
        stan::math::assign(lossRates,rep_vector(0, nComps));
        current_statement_begin__ = 174;
        for (int k = 1; k <= nUpsilons; ++k) {
            current_statement_begin__ = 175;
            stan::model::assign(transition, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 2, "mappingU", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 1, "mappingU", 2)), stan::model::nil_index_list())), 
                        get_base1(params, get_base1(get_base1(mappingU, k, "mappingU", 1), 3, "mappingU", 2), "params", 1), 
                        "assigning variable transition");
            current_statement_begin__ = 176;
            stan::model::assign(lossRates, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 1, "mappingU", 2)), stan::model::nil_index_list()), 
                        (stan::model::rvalue(lossRates, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingU, k, "mappingU", 1), 1, "mappingU", 2)), stan::model::nil_index_list()), "lossRates") + get_base1(params, get_base1(get_base1(mappingU, k, "mappingU", 1), 3, "mappingU", 2), "params", 1)), 
                        "assigning variable lossRates");
        }
        current_statement_begin__ = 178;
        for (int k = 1; k <= nLambdas; ++k) {
            current_statement_begin__ = 179;
            stan::model::assign(lossRates, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingL, k, "mappingL", 1), 1, "mappingL", 2)), stan::model::nil_index_list()), 
                        (stan::model::rvalue(lossRates, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(mappingL, k, "mappingL", 1), 1, "mappingL", 2)), stan::model::nil_index_list()), "lossRates") + get_base1(params, get_base1(get_base1(mappingL, k, "mappingL", 1), 2, "mappingL", 2), "params", 1)), 
                        "assigning variable lossRates");
        }
        current_statement_begin__ = 181;
        stan::math::assign(transition, multiply(transition, dt));
        current_statement_begin__ = 182;
        stan::math::assign(lossRates, multiply(lossRates, dt));
        current_statement_begin__ = 183;
        for (int k = 1; k <= nComps; ++k) {
            current_statement_begin__ = 184;
            stan::model::assign(transition, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                        (stan::model::rvalue(transition, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "transition") + (1 - get_base1(lossRates, k, "lossRates", 1))), 
                        "assigning variable transition");
        }
        current_statement_begin__ = 186;
        return stan::math::promote_scalar<fun_return_scalar_t__>(transition);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct buildTransitionMatrix_functor__ {
    template <typename T5__, typename T6__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T5__, T6__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& nComps,
                          const int& nUpsilons,
                          const std::vector<std::vector<int> >& mappingU,
                          const int& nLambdas,
                          const std::vector<std::vector<int> >& mappingL,
                          const T5__& dt,
                          const std::vector<T6__>& params, std::ostream* pstream__) const {
        return buildTransitionMatrix(nComps, nUpsilons, mappingU, nLambdas, mappingL, dt, params, pstream__);
    }
};
template <typename T1__, typename T2__, typename T3__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T3__>::type, Eigen::Dynamic, Eigen::Dynamic>
buildTransitionMatrixDecay(const int& nComps,
                               const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& transitionRef,
                               const T2__& lambda_decay,
                               const T3__& dt, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 216;
        validate_non_negative_index("transition", "nComps", nComps);
        validate_non_negative_index("transition", "nComps", nComps);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transition(nComps, nComps);
        stan::math::initialize(transition, DUMMY_VAR__);
        stan::math::fill(transition, DUMMY_VAR__);
        stan::math::assign(transition,transitionRef);
        current_statement_begin__ = 217;
        for (int k = 1; k <= nComps; ++k) {
            current_statement_begin__ = 218;
            stan::model::assign(transition, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                        (stan::model::rvalue(transition, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "transition") - (lambda_decay * dt)), 
                        "assigning variable transition");
        }
        current_statement_begin__ = 220;
        return stan::math::promote_scalar<fun_return_scalar_t__>(transition);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct buildTransitionMatrixDecay_functor__ {
    template <typename T1__, typename T2__, typename T3__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T3__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& nComps,
                               const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& transitionRef,
                               const T2__& lambda_decay,
                               const T3__& dt, std::ostream* pstream__) const {
        return buildTransitionMatrixDecay(nComps, transitionRef, lambda_decay, dt, pstream__);
    }
};
template <typename T3__, typename T4__, typename T8__>
std::vector<typename boost::math::tools::promote_args<T3__, T4__, T8__>::type>
buildSizePredictions(const int& nObs,
                         const int& currentGroup,
                         const int& maxNobs,
                         const std::vector<Eigen::Matrix<T3__, Eigen::Dynamic, 1> >& unmarked,
                         const std::vector<Eigen::Matrix<T4__, Eigen::Dynamic, 1> >& marked,
                         const std::vector<std::vector<int> >& indices,
                         const int& splitPresent,
                         const std::vector<int>& splitComps,
                         const std::vector<std::vector<T8__> >& initRefr, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T3__, T4__, T8__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 268;
        validate_non_negative_index("pred", "maxNobs", maxNobs);
        std::vector<local_scalar_t__  > pred(maxNobs, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(pred, DUMMY_VAR__);
        stan::math::fill(pred, DUMMY_VAR__);
        stan::math::assign(pred,rep_array(0.0, maxNobs));
        current_statement_begin__ = 269;
        local_scalar_t__ unmarkedQ(DUMMY_VAR__);
        (void) unmarkedQ;  // dummy to suppress unused var warning
        stan::math::initialize(unmarkedQ, DUMMY_VAR__);
        stan::math::fill(unmarkedQ, DUMMY_VAR__);
        current_statement_begin__ = 270;
        local_scalar_t__ markedQ(DUMMY_VAR__);
        (void) markedQ;  // dummy to suppress unused var warning
        stan::math::initialize(markedQ, DUMMY_VAR__);
        stan::math::fill(markedQ, DUMMY_VAR__);
        current_statement_begin__ = 271;
        if (as_bool(logical_gt(splitPresent, 0))) {
            current_statement_begin__ = 273;
            for (int k = 1; k <= nObs; ++k) {
                current_statement_begin__ = 274;
                stan::math::assign(unmarkedQ, get_base1(get_base1(unmarked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "unmarked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "unmarked", 2));
                current_statement_begin__ = 275;
                stan::math::assign(markedQ, get_base1(get_base1(marked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "marked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "marked", 2));
                current_statement_begin__ = 276;
                if (as_bool(logical_gt(get_base1(splitComps, get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "splitComps", 1), 0))) {
                    current_statement_begin__ = 277;
                    stan::math::assign(unmarkedQ, (unmarkedQ + get_base1(get_base1(initRefr, get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "initRefr", 1), 1, "initRefr", 2)));
                    current_statement_begin__ = 278;
                    stan::math::assign(markedQ, (markedQ + get_base1(get_base1(initRefr, get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "initRefr", 1), 2, "initRefr", 2)));
                }
                current_statement_begin__ = 280;
                stan::model::assign(pred, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            (unmarkedQ + markedQ), 
                            "assigning variable pred");
            }
            current_statement_begin__ = 282;
            return stan::math::promote_scalar<fun_return_scalar_t__>(pred);
        } else {
            current_statement_begin__ = 285;
            for (int k = 1; k <= nObs; ++k) {
                current_statement_begin__ = 286;
                stan::math::assign(unmarkedQ, get_base1(get_base1(unmarked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "unmarked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "unmarked", 2));
                current_statement_begin__ = 287;
                stan::math::assign(markedQ, get_base1(get_base1(marked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "marked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "marked", 2));
                current_statement_begin__ = 288;
                stan::model::assign(pred, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            (unmarkedQ + markedQ), 
                            "assigning variable pred");
            }
            current_statement_begin__ = 290;
            return stan::math::promote_scalar<fun_return_scalar_t__>(pred);
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct buildSizePredictions_functor__ {
    template <typename T3__, typename T4__, typename T8__>
        std::vector<typename boost::math::tools::promote_args<T3__, T4__, T8__>::type>
    operator()(const int& nObs,
                         const int& currentGroup,
                         const int& maxNobs,
                         const std::vector<Eigen::Matrix<T3__, Eigen::Dynamic, 1> >& unmarked,
                         const std::vector<Eigen::Matrix<T4__, Eigen::Dynamic, 1> >& marked,
                         const std::vector<std::vector<int> >& indices,
                         const int& splitPresent,
                         const std::vector<int>& splitComps,
                         const std::vector<std::vector<T8__> >& initRefr, std::ostream* pstream__) const {
        return buildSizePredictions(nObs, currentGroup, maxNobs, unmarked, marked, indices, splitPresent, splitComps, initRefr, pstream__);
    }
};
template <typename T3__, typename T4__, typename T8__>
std::vector<typename boost::math::tools::promote_args<T3__, T4__, T8__>::type>
buildPropPredictions(const int& nObs,
                         const int& currentGroup,
                         const int& maxNobs,
                         const std::vector<Eigen::Matrix<T3__, Eigen::Dynamic, 1> >& unmarked,
                         const std::vector<Eigen::Matrix<T4__, Eigen::Dynamic, 1> >& marked,
                         const std::vector<std::vector<int> >& indices,
                         const int& splitPresent,
                         const std::vector<int>& splitComps,
                         const std::vector<std::vector<T8__> >& initRefr, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T3__, T4__, T8__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 337;
        validate_non_negative_index("pred", "maxNobs", maxNobs);
        std::vector<local_scalar_t__  > pred(maxNobs, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(pred, DUMMY_VAR__);
        stan::math::fill(pred, DUMMY_VAR__);
        stan::math::assign(pred,rep_array(0.0, maxNobs));
        current_statement_begin__ = 338;
        local_scalar_t__ unmarkedQ(DUMMY_VAR__);
        (void) unmarkedQ;  // dummy to suppress unused var warning
        stan::math::initialize(unmarkedQ, DUMMY_VAR__);
        stan::math::fill(unmarkedQ, DUMMY_VAR__);
        current_statement_begin__ = 339;
        local_scalar_t__ markedQ(DUMMY_VAR__);
        (void) markedQ;  // dummy to suppress unused var warning
        stan::math::initialize(markedQ, DUMMY_VAR__);
        stan::math::fill(markedQ, DUMMY_VAR__);
        current_statement_begin__ = 340;
        if (as_bool(logical_gt(splitPresent, 0))) {
            current_statement_begin__ = 342;
            for (int k = 1; k <= nObs; ++k) {
                current_statement_begin__ = 343;
                stan::math::assign(unmarkedQ, get_base1(get_base1(unmarked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "unmarked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "unmarked", 2));
                current_statement_begin__ = 344;
                stan::math::assign(markedQ, get_base1(get_base1(marked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "marked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "marked", 2));
                current_statement_begin__ = 345;
                if (as_bool(logical_gt(get_base1(splitComps, get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "splitComps", 1), 0))) {
                    current_statement_begin__ = 346;
                    stan::math::assign(unmarkedQ, (unmarkedQ + get_base1(get_base1(initRefr, get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "initRefr", 1), 1, "initRefr", 2)));
                    current_statement_begin__ = 347;
                    stan::math::assign(markedQ, (markedQ + get_base1(get_base1(initRefr, get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "initRefr", 1), 2, "initRefr", 2)));
                }
                current_statement_begin__ = 349;
                stan::model::assign(pred, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            (markedQ / (unmarkedQ + markedQ)), 
                            "assigning variable pred");
            }
            current_statement_begin__ = 351;
            return stan::math::promote_scalar<fun_return_scalar_t__>(pred);
        } else {
            current_statement_begin__ = 354;
            for (int k = 1; k <= nObs; ++k) {
                current_statement_begin__ = 355;
                stan::math::assign(unmarkedQ, get_base1(get_base1(unmarked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "unmarked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "unmarked", 2));
                current_statement_begin__ = 356;
                stan::math::assign(markedQ, get_base1(get_base1(marked, get_base1(get_base1(indices, k, "indices", 1), 2, "indices", 2), "marked", 1), get_base1(get_base1(indices, k, "indices", 1), 1, "indices", 2), "marked", 2));
                current_statement_begin__ = 357;
                stan::model::assign(pred, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            (markedQ / (unmarkedQ + markedQ)), 
                            "assigning variable pred");
            }
            current_statement_begin__ = 359;
            return stan::math::promote_scalar<fun_return_scalar_t__>(pred);
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct buildPropPredictions_functor__ {
    template <typename T3__, typename T4__, typename T8__>
        std::vector<typename boost::math::tools::promote_args<T3__, T4__, T8__>::type>
    operator()(const int& nObs,
                         const int& currentGroup,
                         const int& maxNobs,
                         const std::vector<Eigen::Matrix<T3__, Eigen::Dynamic, 1> >& unmarked,
                         const std::vector<Eigen::Matrix<T4__, Eigen::Dynamic, 1> >& marked,
                         const std::vector<std::vector<int> >& indices,
                         const int& splitPresent,
                         const std::vector<int>& splitComps,
                         const std::vector<std::vector<T8__> >& initRefr, std::ostream* pstream__) const {
        return buildPropPredictions(nObs, currentGroup, maxNobs, unmarked, marked, indices, splitPresent, splitComps, initRefr, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_networkModel
  : public stan::model::model_base_crtp<model_networkModel> {
private:
        int ode_method;
        int nComps;
        int nGroups;
        int nParams;
        int nNonConstantPriors;
        int nPriorUniform_code1;
        int nPriorHcauchy_code2;
        int nPriorBeta_code3;
        int nPriorTrNormal_code4;
        int nPriorExponential_code5;
        int nPriorGamma_code6;
        std::vector<double> constantParams;
        std::vector<double> lowerParams;
        std::vector<double> upperParams;
        std::vector<double> hcauchyScaleParams;
        std::vector<double> rawBetaAlpha;
        std::vector<double> rawBetaBeta;
        std::vector<double> betaScaleParams;
        std::vector<double> trNormMeanParams;
        std::vector<double> trNormSdParams;
        std::vector<double> exponentialRateParams;
        std::vector<double> gammaAlphaParams;
        std::vector<double> gammaBetaParams;
        std::vector<int> mappingParamPriorType;
        std::vector<int> mappingParamPriorID;
        int propFamily;
        int sizeFamily;
        std::vector<std::vector<std::vector<double> > > initialQuantities;
        int maxNsteady;
        std::vector<int> nSteady;
        std::vector<std::vector<int> > steadyIndices;
        int splitPresent;
        std::vector<std::vector<int> > splitComps;
        std::vector<std::vector<int> > piMapping;
        double lambda_decay;
        int maxNupsilons;
        std::vector<int> nUpsilons;
        std::vector<std::vector<std::vector<int> > > upsilonMapping;
        int maxNlambdas;
        std::vector<int> nLambdas;
        std::vector<std::vector<std::vector<int> > > lambdaMapping;
        int maxNpulseEvents;
        std::vector<int> nPulseEvents;
        std::vector<std::vector<std::vector<int> > > pulseEventsIndices;
        std::vector<std::vector<std::vector<double> > > pulseEventsQuantities;
        int maxNsizesObs;
        int maxNpropsObs;
        std::vector<int> nSizesObs;
        std::vector<int> nPropsObs;
        std::vector<std::vector<std::vector<int> > > sizesObsIndices;
        std::vector<std::vector<std::vector<int> > > propsObsIndices;
        std::vector<std::vector<double> > sizesObs;
        std::vector<std::vector<double> > propsObs;
        int maxNtimeIntervals;
        std::vector<int> nTimeIntervals;
        std::vector<std::vector<double> > intervalsLengths;
        int maxNobsTimes;
        std::vector<int> nObsTimes;
        std::vector<std::vector<double> > elapsedTimeSinceEvent;
        std::vector<std::vector<int> > obsIntervalsIndices;
        int maxNtimesteps;
        std::vector<int> nTimesteps;
        int maxNuniqueDts;
        std::vector<int> nUniqueDts;
        std::vector<std::vector<double> > unique_dts;
        std::vector<std::vector<int> > timesteps;
        int nTotal;
        int n_quantity_records;
public:
    model_networkModel(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_networkModel(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_networkModel_namespace::model_networkModel";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 372;
            context__.validate_dims("data initialization", "ode_method", "int", context__.to_vec());
            ode_method = int(0);
            vals_i__ = context__.vals_i("ode_method");
            pos__ = 0;
            ode_method = vals_i__[pos__++];
            check_greater_or_equal(function__, "ode_method", ode_method, 1);
            check_less_or_equal(function__, "ode_method", ode_method, 2);
            current_statement_begin__ = 375;
            context__.validate_dims("data initialization", "nComps", "int", context__.to_vec());
            nComps = int(0);
            vals_i__ = context__.vals_i("nComps");
            pos__ = 0;
            nComps = vals_i__[pos__++];
            check_greater_or_equal(function__, "nComps", nComps, 1);
            current_statement_begin__ = 376;
            context__.validate_dims("data initialization", "nGroups", "int", context__.to_vec());
            nGroups = int(0);
            vals_i__ = context__.vals_i("nGroups");
            pos__ = 0;
            nGroups = vals_i__[pos__++];
            check_greater_or_equal(function__, "nGroups", nGroups, 0);
            current_statement_begin__ = 377;
            context__.validate_dims("data initialization", "nParams", "int", context__.to_vec());
            nParams = int(0);
            vals_i__ = context__.vals_i("nParams");
            pos__ = 0;
            nParams = vals_i__[pos__++];
            check_greater_or_equal(function__, "nParams", nParams, 0);
            current_statement_begin__ = 379;
            context__.validate_dims("data initialization", "nNonConstantPriors", "int", context__.to_vec());
            nNonConstantPriors = int(0);
            vals_i__ = context__.vals_i("nNonConstantPriors");
            pos__ = 0;
            nNonConstantPriors = vals_i__[pos__++];
            check_greater_or_equal(function__, "nNonConstantPriors", nNonConstantPriors, 1);
            current_statement_begin__ = 380;
            context__.validate_dims("data initialization", "nPriorUniform_code1", "int", context__.to_vec());
            nPriorUniform_code1 = int(0);
            vals_i__ = context__.vals_i("nPriorUniform_code1");
            pos__ = 0;
            nPriorUniform_code1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "nPriorUniform_code1", nPriorUniform_code1, 0);
            current_statement_begin__ = 381;
            context__.validate_dims("data initialization", "nPriorHcauchy_code2", "int", context__.to_vec());
            nPriorHcauchy_code2 = int(0);
            vals_i__ = context__.vals_i("nPriorHcauchy_code2");
            pos__ = 0;
            nPriorHcauchy_code2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "nPriorHcauchy_code2", nPriorHcauchy_code2, 0);
            current_statement_begin__ = 382;
            context__.validate_dims("data initialization", "nPriorBeta_code3", "int", context__.to_vec());
            nPriorBeta_code3 = int(0);
            vals_i__ = context__.vals_i("nPriorBeta_code3");
            pos__ = 0;
            nPriorBeta_code3 = vals_i__[pos__++];
            check_greater_or_equal(function__, "nPriorBeta_code3", nPriorBeta_code3, 0);
            current_statement_begin__ = 383;
            context__.validate_dims("data initialization", "nPriorTrNormal_code4", "int", context__.to_vec());
            nPriorTrNormal_code4 = int(0);
            vals_i__ = context__.vals_i("nPriorTrNormal_code4");
            pos__ = 0;
            nPriorTrNormal_code4 = vals_i__[pos__++];
            check_greater_or_equal(function__, "nPriorTrNormal_code4", nPriorTrNormal_code4, 0);
            current_statement_begin__ = 384;
            context__.validate_dims("data initialization", "nPriorExponential_code5", "int", context__.to_vec());
            nPriorExponential_code5 = int(0);
            vals_i__ = context__.vals_i("nPriorExponential_code5");
            pos__ = 0;
            nPriorExponential_code5 = vals_i__[pos__++];
            check_greater_or_equal(function__, "nPriorExponential_code5", nPriorExponential_code5, 0);
            current_statement_begin__ = 385;
            context__.validate_dims("data initialization", "nPriorGamma_code6", "int", context__.to_vec());
            nPriorGamma_code6 = int(0);
            vals_i__ = context__.vals_i("nPriorGamma_code6");
            pos__ = 0;
            nPriorGamma_code6 = vals_i__[pos__++];
            check_greater_or_equal(function__, "nPriorGamma_code6", nPriorGamma_code6, 0);
            current_statement_begin__ = 390;
            validate_non_negative_index("constantParams", "nParams", nParams);
            context__.validate_dims("data initialization", "constantParams", "double", context__.to_vec(nParams));
            constantParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("constantParams");
            pos__ = 0;
            size_t constantParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < constantParams_k_0_max__; ++k_0__) {
                constantParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 393;
            validate_non_negative_index("lowerParams", "nParams", nParams);
            context__.validate_dims("data initialization", "lowerParams", "double", context__.to_vec(nParams));
            lowerParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("lowerParams");
            pos__ = 0;
            size_t lowerParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < lowerParams_k_0_max__; ++k_0__) {
                lowerParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 394;
            validate_non_negative_index("upperParams", "nParams", nParams);
            context__.validate_dims("data initialization", "upperParams", "double", context__.to_vec(nParams));
            upperParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("upperParams");
            pos__ = 0;
            size_t upperParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < upperParams_k_0_max__; ++k_0__) {
                upperParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 397;
            validate_non_negative_index("hcauchyScaleParams", "nParams", nParams);
            context__.validate_dims("data initialization", "hcauchyScaleParams", "double", context__.to_vec(nParams));
            hcauchyScaleParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("hcauchyScaleParams");
            pos__ = 0;
            size_t hcauchyScaleParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < hcauchyScaleParams_k_0_max__; ++k_0__) {
                hcauchyScaleParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 400;
            validate_non_negative_index("rawBetaAlpha", "nParams", nParams);
            context__.validate_dims("data initialization", "rawBetaAlpha", "double", context__.to_vec(nParams));
            rawBetaAlpha = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("rawBetaAlpha");
            pos__ = 0;
            size_t rawBetaAlpha_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < rawBetaAlpha_k_0_max__; ++k_0__) {
                rawBetaAlpha[k_0__] = vals_r__[pos__++];
            }
            size_t rawBetaAlpha_i_0_max__ = nParams;
            for (size_t i_0__ = 0; i_0__ < rawBetaAlpha_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rawBetaAlpha[i_0__]", rawBetaAlpha[i_0__], 0);
            }
            current_statement_begin__ = 401;
            validate_non_negative_index("rawBetaBeta", "nParams", nParams);
            context__.validate_dims("data initialization", "rawBetaBeta", "double", context__.to_vec(nParams));
            rawBetaBeta = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("rawBetaBeta");
            pos__ = 0;
            size_t rawBetaBeta_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < rawBetaBeta_k_0_max__; ++k_0__) {
                rawBetaBeta[k_0__] = vals_r__[pos__++];
            }
            size_t rawBetaBeta_i_0_max__ = nParams;
            for (size_t i_0__ = 0; i_0__ < rawBetaBeta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rawBetaBeta[i_0__]", rawBetaBeta[i_0__], 0);
            }
            current_statement_begin__ = 402;
            validate_non_negative_index("betaScaleParams", "nParams", nParams);
            context__.validate_dims("data initialization", "betaScaleParams", "double", context__.to_vec(nParams));
            betaScaleParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("betaScaleParams");
            pos__ = 0;
            size_t betaScaleParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < betaScaleParams_k_0_max__; ++k_0__) {
                betaScaleParams[k_0__] = vals_r__[pos__++];
            }
            size_t betaScaleParams_i_0_max__ = nParams;
            for (size_t i_0__ = 0; i_0__ < betaScaleParams_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "betaScaleParams[i_0__]", betaScaleParams[i_0__], 0);
            }
            current_statement_begin__ = 405;
            validate_non_negative_index("trNormMeanParams", "nParams", nParams);
            context__.validate_dims("data initialization", "trNormMeanParams", "double", context__.to_vec(nParams));
            trNormMeanParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("trNormMeanParams");
            pos__ = 0;
            size_t trNormMeanParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < trNormMeanParams_k_0_max__; ++k_0__) {
                trNormMeanParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 406;
            validate_non_negative_index("trNormSdParams", "nParams", nParams);
            context__.validate_dims("data initialization", "trNormSdParams", "double", context__.to_vec(nParams));
            trNormSdParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("trNormSdParams");
            pos__ = 0;
            size_t trNormSdParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < trNormSdParams_k_0_max__; ++k_0__) {
                trNormSdParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 409;
            validate_non_negative_index("exponentialRateParams", "nParams", nParams);
            context__.validate_dims("data initialization", "exponentialRateParams", "double", context__.to_vec(nParams));
            exponentialRateParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("exponentialRateParams");
            pos__ = 0;
            size_t exponentialRateParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < exponentialRateParams_k_0_max__; ++k_0__) {
                exponentialRateParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 412;
            validate_non_negative_index("gammaAlphaParams", "nParams", nParams);
            context__.validate_dims("data initialization", "gammaAlphaParams", "double", context__.to_vec(nParams));
            gammaAlphaParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("gammaAlphaParams");
            pos__ = 0;
            size_t gammaAlphaParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < gammaAlphaParams_k_0_max__; ++k_0__) {
                gammaAlphaParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 413;
            validate_non_negative_index("gammaBetaParams", "nParams", nParams);
            context__.validate_dims("data initialization", "gammaBetaParams", "double", context__.to_vec(nParams));
            gammaBetaParams = std::vector<double>(nParams, double(0));
            vals_r__ = context__.vals_r("gammaBetaParams");
            pos__ = 0;
            size_t gammaBetaParams_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < gammaBetaParams_k_0_max__; ++k_0__) {
                gammaBetaParams[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 416;
            validate_non_negative_index("mappingParamPriorType", "nParams", nParams);
            context__.validate_dims("data initialization", "mappingParamPriorType", "int", context__.to_vec(nParams));
            mappingParamPriorType = std::vector<int>(nParams, int(0));
            vals_i__ = context__.vals_i("mappingParamPriorType");
            pos__ = 0;
            size_t mappingParamPriorType_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < mappingParamPriorType_k_0_max__; ++k_0__) {
                mappingParamPriorType[k_0__] = vals_i__[pos__++];
            }
            size_t mappingParamPriorType_i_0_max__ = nParams;
            for (size_t i_0__ = 0; i_0__ < mappingParamPriorType_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mappingParamPriorType[i_0__]", mappingParamPriorType[i_0__], 0);
            }
            current_statement_begin__ = 417;
            validate_non_negative_index("mappingParamPriorID", "nParams", nParams);
            context__.validate_dims("data initialization", "mappingParamPriorID", "int", context__.to_vec(nParams));
            mappingParamPriorID = std::vector<int>(nParams, int(0));
            vals_i__ = context__.vals_i("mappingParamPriorID");
            pos__ = 0;
            size_t mappingParamPriorID_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < mappingParamPriorID_k_0_max__; ++k_0__) {
                mappingParamPriorID[k_0__] = vals_i__[pos__++];
            }
            size_t mappingParamPriorID_i_0_max__ = nParams;
            for (size_t i_0__ = 0; i_0__ < mappingParamPriorID_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mappingParamPriorID[i_0__]", mappingParamPriorID[i_0__], 0);
            }
            current_statement_begin__ = 420;
            context__.validate_dims("data initialization", "propFamily", "int", context__.to_vec());
            propFamily = int(0);
            vals_i__ = context__.vals_i("propFamily");
            pos__ = 0;
            propFamily = vals_i__[pos__++];
            check_greater_or_equal(function__, "propFamily", propFamily, 1);
            check_less_or_equal(function__, "propFamily", propFamily, 4);
            current_statement_begin__ = 428;
            context__.validate_dims("data initialization", "sizeFamily", "int", context__.to_vec());
            sizeFamily = int(0);
            vals_i__ = context__.vals_i("sizeFamily");
            pos__ = 0;
            sizeFamily = vals_i__[pos__++];
            check_greater_or_equal(function__, "sizeFamily", sizeFamily, 1);
            check_less_or_equal(function__, "sizeFamily", sizeFamily, 2);
            current_statement_begin__ = 434;
            validate_non_negative_index("initialQuantities", "nComps", nComps);
            validate_non_negative_index("initialQuantities", "2", 2);
            validate_non_negative_index("initialQuantities", "nGroups", nGroups);
            context__.validate_dims("data initialization", "initialQuantities", "double", context__.to_vec(nComps,2,nGroups));
            initialQuantities = std::vector<std::vector<std::vector<double> > >(nComps, std::vector<std::vector<double> >(2, std::vector<double>(nGroups, double(0))));
            vals_r__ = context__.vals_r("initialQuantities");
            pos__ = 0;
            size_t initialQuantities_k_0_max__ = nComps;
            size_t initialQuantities_k_1_max__ = 2;
            size_t initialQuantities_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < initialQuantities_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < initialQuantities_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < initialQuantities_k_0_max__; ++k_0__) {
                        initialQuantities[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                    }
                }
            }
            size_t initialQuantities_i_0_max__ = nComps;
            size_t initialQuantities_i_1_max__ = 2;
            size_t initialQuantities_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < initialQuantities_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < initialQuantities_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < initialQuantities_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "initialQuantities[i_0__][i_1__][i_2__]", initialQuantities[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 437;
            context__.validate_dims("data initialization", "maxNsteady", "int", context__.to_vec());
            maxNsteady = int(0);
            vals_i__ = context__.vals_i("maxNsteady");
            pos__ = 0;
            maxNsteady = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNsteady", maxNsteady, 0);
            current_statement_begin__ = 438;
            validate_non_negative_index("nSteady", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nSteady", "int", context__.to_vec((nGroups + 1)));
            nSteady = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nSteady");
            pos__ = 0;
            size_t nSteady_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nSteady_k_0_max__; ++k_0__) {
                nSteady[k_0__] = vals_i__[pos__++];
            }
            size_t nSteady_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nSteady_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nSteady[i_0__]", nSteady[i_0__], 0);
            }
            current_statement_begin__ = 439;
            validate_non_negative_index("steadyIndices", "maxNsteady", maxNsteady);
            validate_non_negative_index("steadyIndices", "nGroups", nGroups);
            context__.validate_dims("data initialization", "steadyIndices", "int", context__.to_vec(maxNsteady,nGroups));
            steadyIndices = std::vector<std::vector<int> >(maxNsteady, std::vector<int>(nGroups, int(0)));
            vals_i__ = context__.vals_i("steadyIndices");
            pos__ = 0;
            size_t steadyIndices_k_0_max__ = maxNsteady;
            size_t steadyIndices_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < steadyIndices_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < steadyIndices_k_0_max__; ++k_0__) {
                    steadyIndices[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t steadyIndices_i_0_max__ = maxNsteady;
            size_t steadyIndices_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < steadyIndices_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < steadyIndices_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "steadyIndices[i_0__][i_1__]", steadyIndices[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 442;
            context__.validate_dims("data initialization", "splitPresent", "int", context__.to_vec());
            splitPresent = int(0);
            vals_i__ = context__.vals_i("splitPresent");
            pos__ = 0;
            splitPresent = vals_i__[pos__++];
            check_greater_or_equal(function__, "splitPresent", splitPresent, 0);
            check_less_or_equal(function__, "splitPresent", splitPresent, 1);
            current_statement_begin__ = 443;
            validate_non_negative_index("splitComps", "nComps", nComps);
            validate_non_negative_index("splitComps", "nGroups", nGroups);
            context__.validate_dims("data initialization", "splitComps", "int", context__.to_vec(nComps,nGroups));
            splitComps = std::vector<std::vector<int> >(nComps, std::vector<int>(nGroups, int(0)));
            vals_i__ = context__.vals_i("splitComps");
            pos__ = 0;
            size_t splitComps_k_0_max__ = nComps;
            size_t splitComps_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < splitComps_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < splitComps_k_0_max__; ++k_0__) {
                    splitComps[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t splitComps_i_0_max__ = nComps;
            size_t splitComps_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < splitComps_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < splitComps_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "splitComps[i_0__][i_1__]", splitComps[i_0__][i_1__], 0);
                    check_less_or_equal(function__, "splitComps[i_0__][i_1__]", splitComps[i_0__][i_1__], 1);
                }
            }
            current_statement_begin__ = 446;
            validate_non_negative_index("piMapping", "nComps", nComps);
            validate_non_negative_index("piMapping", "nGroups", nGroups);
            context__.validate_dims("data initialization", "piMapping", "int", context__.to_vec(nComps,nGroups));
            piMapping = std::vector<std::vector<int> >(nComps, std::vector<int>(nGroups, int(0)));
            vals_i__ = context__.vals_i("piMapping");
            pos__ = 0;
            size_t piMapping_k_0_max__ = nComps;
            size_t piMapping_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < piMapping_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < piMapping_k_0_max__; ++k_0__) {
                    piMapping[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t piMapping_i_0_max__ = nComps;
            size_t piMapping_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < piMapping_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < piMapping_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "piMapping[i_0__][i_1__]", piMapping[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 449;
            context__.validate_dims("data initialization", "lambda_decay", "double", context__.to_vec());
            lambda_decay = double(0);
            vals_r__ = context__.vals_r("lambda_decay");
            pos__ = 0;
            lambda_decay = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_decay", lambda_decay, 0);
            current_statement_begin__ = 452;
            context__.validate_dims("data initialization", "maxNupsilons", "int", context__.to_vec());
            maxNupsilons = int(0);
            vals_i__ = context__.vals_i("maxNupsilons");
            pos__ = 0;
            maxNupsilons = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNupsilons", maxNupsilons, 0);
            current_statement_begin__ = 453;
            validate_non_negative_index("nUpsilons", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nUpsilons", "int", context__.to_vec((nGroups + 1)));
            nUpsilons = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nUpsilons");
            pos__ = 0;
            size_t nUpsilons_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nUpsilons_k_0_max__; ++k_0__) {
                nUpsilons[k_0__] = vals_i__[pos__++];
            }
            size_t nUpsilons_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nUpsilons_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nUpsilons[i_0__]", nUpsilons[i_0__], 0);
            }
            current_statement_begin__ = 454;
            validate_non_negative_index("upsilonMapping", "maxNupsilons", maxNupsilons);
            validate_non_negative_index("upsilonMapping", "3", 3);
            validate_non_negative_index("upsilonMapping", "nGroups", nGroups);
            context__.validate_dims("data initialization", "upsilonMapping", "int", context__.to_vec(maxNupsilons,3,nGroups));
            upsilonMapping = std::vector<std::vector<std::vector<int> > >(maxNupsilons, std::vector<std::vector<int> >(3, std::vector<int>(nGroups, int(0))));
            vals_i__ = context__.vals_i("upsilonMapping");
            pos__ = 0;
            size_t upsilonMapping_k_0_max__ = maxNupsilons;
            size_t upsilonMapping_k_1_max__ = 3;
            size_t upsilonMapping_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < upsilonMapping_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < upsilonMapping_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < upsilonMapping_k_0_max__; ++k_0__) {
                        upsilonMapping[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t upsilonMapping_i_0_max__ = maxNupsilons;
            size_t upsilonMapping_i_1_max__ = 3;
            size_t upsilonMapping_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < upsilonMapping_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < upsilonMapping_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < upsilonMapping_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "upsilonMapping[i_0__][i_1__][i_2__]", upsilonMapping[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 457;
            context__.validate_dims("data initialization", "maxNlambdas", "int", context__.to_vec());
            maxNlambdas = int(0);
            vals_i__ = context__.vals_i("maxNlambdas");
            pos__ = 0;
            maxNlambdas = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNlambdas", maxNlambdas, 0);
            current_statement_begin__ = 458;
            validate_non_negative_index("nLambdas", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nLambdas", "int", context__.to_vec((nGroups + 1)));
            nLambdas = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nLambdas");
            pos__ = 0;
            size_t nLambdas_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nLambdas_k_0_max__; ++k_0__) {
                nLambdas[k_0__] = vals_i__[pos__++];
            }
            size_t nLambdas_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nLambdas_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nLambdas[i_0__]", nLambdas[i_0__], 0);
            }
            current_statement_begin__ = 459;
            validate_non_negative_index("lambdaMapping", "maxNlambdas", maxNlambdas);
            validate_non_negative_index("lambdaMapping", "2", 2);
            validate_non_negative_index("lambdaMapping", "nGroups", nGroups);
            context__.validate_dims("data initialization", "lambdaMapping", "int", context__.to_vec(maxNlambdas,2,nGroups));
            lambdaMapping = std::vector<std::vector<std::vector<int> > >(maxNlambdas, std::vector<std::vector<int> >(2, std::vector<int>(nGroups, int(0))));
            vals_i__ = context__.vals_i("lambdaMapping");
            pos__ = 0;
            size_t lambdaMapping_k_0_max__ = maxNlambdas;
            size_t lambdaMapping_k_1_max__ = 2;
            size_t lambdaMapping_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < lambdaMapping_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < lambdaMapping_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < lambdaMapping_k_0_max__; ++k_0__) {
                        lambdaMapping[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t lambdaMapping_i_0_max__ = maxNlambdas;
            size_t lambdaMapping_i_1_max__ = 2;
            size_t lambdaMapping_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < lambdaMapping_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < lambdaMapping_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < lambdaMapping_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "lambdaMapping[i_0__][i_1__][i_2__]", lambdaMapping[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 466;
            context__.validate_dims("data initialization", "maxNpulseEvents", "int", context__.to_vec());
            maxNpulseEvents = int(0);
            vals_i__ = context__.vals_i("maxNpulseEvents");
            pos__ = 0;
            maxNpulseEvents = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNpulseEvents", maxNpulseEvents, 0);
            current_statement_begin__ = 467;
            validate_non_negative_index("nPulseEvents", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nPulseEvents", "int", context__.to_vec((nGroups + 1)));
            nPulseEvents = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nPulseEvents");
            pos__ = 0;
            size_t nPulseEvents_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nPulseEvents_k_0_max__; ++k_0__) {
                nPulseEvents[k_0__] = vals_i__[pos__++];
            }
            size_t nPulseEvents_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nPulseEvents_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nPulseEvents[i_0__]", nPulseEvents[i_0__], 0);
            }
            current_statement_begin__ = 468;
            validate_non_negative_index("pulseEventsIndices", "maxNpulseEvents", maxNpulseEvents);
            validate_non_negative_index("pulseEventsIndices", "2", 2);
            validate_non_negative_index("pulseEventsIndices", "nGroups", nGroups);
            context__.validate_dims("data initialization", "pulseEventsIndices", "int", context__.to_vec(maxNpulseEvents,2,nGroups));
            pulseEventsIndices = std::vector<std::vector<std::vector<int> > >(maxNpulseEvents, std::vector<std::vector<int> >(2, std::vector<int>(nGroups, int(0))));
            vals_i__ = context__.vals_i("pulseEventsIndices");
            pos__ = 0;
            size_t pulseEventsIndices_k_0_max__ = maxNpulseEvents;
            size_t pulseEventsIndices_k_1_max__ = 2;
            size_t pulseEventsIndices_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < pulseEventsIndices_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < pulseEventsIndices_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < pulseEventsIndices_k_0_max__; ++k_0__) {
                        pulseEventsIndices[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t pulseEventsIndices_i_0_max__ = maxNpulseEvents;
            size_t pulseEventsIndices_i_1_max__ = 2;
            size_t pulseEventsIndices_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < pulseEventsIndices_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < pulseEventsIndices_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < pulseEventsIndices_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "pulseEventsIndices[i_0__][i_1__][i_2__]", pulseEventsIndices[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 469;
            validate_non_negative_index("pulseEventsQuantities", "maxNpulseEvents", maxNpulseEvents);
            validate_non_negative_index("pulseEventsQuantities", "2", 2);
            validate_non_negative_index("pulseEventsQuantities", "nGroups", nGroups);
            context__.validate_dims("data initialization", "pulseEventsQuantities", "double", context__.to_vec(maxNpulseEvents,2,nGroups));
            pulseEventsQuantities = std::vector<std::vector<std::vector<double> > >(maxNpulseEvents, std::vector<std::vector<double> >(2, std::vector<double>(nGroups, double(0))));
            vals_r__ = context__.vals_r("pulseEventsQuantities");
            pos__ = 0;
            size_t pulseEventsQuantities_k_0_max__ = maxNpulseEvents;
            size_t pulseEventsQuantities_k_1_max__ = 2;
            size_t pulseEventsQuantities_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < pulseEventsQuantities_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < pulseEventsQuantities_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < pulseEventsQuantities_k_0_max__; ++k_0__) {
                        pulseEventsQuantities[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                    }
                }
            }
            current_statement_begin__ = 472;
            context__.validate_dims("data initialization", "maxNsizesObs", "int", context__.to_vec());
            maxNsizesObs = int(0);
            vals_i__ = context__.vals_i("maxNsizesObs");
            pos__ = 0;
            maxNsizesObs = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNsizesObs", maxNsizesObs, 0);
            current_statement_begin__ = 473;
            context__.validate_dims("data initialization", "maxNpropsObs", "int", context__.to_vec());
            maxNpropsObs = int(0);
            vals_i__ = context__.vals_i("maxNpropsObs");
            pos__ = 0;
            maxNpropsObs = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNpropsObs", maxNpropsObs, 0);
            current_statement_begin__ = 474;
            validate_non_negative_index("nSizesObs", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nSizesObs", "int", context__.to_vec((nGroups + 1)));
            nSizesObs = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nSizesObs");
            pos__ = 0;
            size_t nSizesObs_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nSizesObs_k_0_max__; ++k_0__) {
                nSizesObs[k_0__] = vals_i__[pos__++];
            }
            size_t nSizesObs_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nSizesObs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nSizesObs[i_0__]", nSizesObs[i_0__], 0);
            }
            current_statement_begin__ = 475;
            validate_non_negative_index("nPropsObs", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nPropsObs", "int", context__.to_vec((nGroups + 1)));
            nPropsObs = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nPropsObs");
            pos__ = 0;
            size_t nPropsObs_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nPropsObs_k_0_max__; ++k_0__) {
                nPropsObs[k_0__] = vals_i__[pos__++];
            }
            size_t nPropsObs_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nPropsObs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nPropsObs[i_0__]", nPropsObs[i_0__], 0);
            }
            current_statement_begin__ = 476;
            validate_non_negative_index("sizesObsIndices", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesObsIndices", "3", 3);
            validate_non_negative_index("sizesObsIndices", "nGroups", nGroups);
            context__.validate_dims("data initialization", "sizesObsIndices", "int", context__.to_vec(maxNsizesObs,3,nGroups));
            sizesObsIndices = std::vector<std::vector<std::vector<int> > >(maxNsizesObs, std::vector<std::vector<int> >(3, std::vector<int>(nGroups, int(0))));
            vals_i__ = context__.vals_i("sizesObsIndices");
            pos__ = 0;
            size_t sizesObsIndices_k_0_max__ = maxNsizesObs;
            size_t sizesObsIndices_k_1_max__ = 3;
            size_t sizesObsIndices_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < sizesObsIndices_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < sizesObsIndices_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < sizesObsIndices_k_0_max__; ++k_0__) {
                        sizesObsIndices[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t sizesObsIndices_i_0_max__ = maxNsizesObs;
            size_t sizesObsIndices_i_1_max__ = 3;
            size_t sizesObsIndices_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesObsIndices_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesObsIndices_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < sizesObsIndices_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "sizesObsIndices[i_0__][i_1__][i_2__]", sizesObsIndices[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 477;
            validate_non_negative_index("propsObsIndices", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsObsIndices", "3", 3);
            validate_non_negative_index("propsObsIndices", "nGroups", nGroups);
            context__.validate_dims("data initialization", "propsObsIndices", "int", context__.to_vec(maxNpropsObs,3,nGroups));
            propsObsIndices = std::vector<std::vector<std::vector<int> > >(maxNpropsObs, std::vector<std::vector<int> >(3, std::vector<int>(nGroups, int(0))));
            vals_i__ = context__.vals_i("propsObsIndices");
            pos__ = 0;
            size_t propsObsIndices_k_0_max__ = maxNpropsObs;
            size_t propsObsIndices_k_1_max__ = 3;
            size_t propsObsIndices_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < propsObsIndices_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < propsObsIndices_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < propsObsIndices_k_0_max__; ++k_0__) {
                        propsObsIndices[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t propsObsIndices_i_0_max__ = maxNpropsObs;
            size_t propsObsIndices_i_1_max__ = 3;
            size_t propsObsIndices_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsObsIndices_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsObsIndices_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < propsObsIndices_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "propsObsIndices[i_0__][i_1__][i_2__]", propsObsIndices[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 478;
            validate_non_negative_index("sizesObs", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesObs", "nGroups", nGroups);
            context__.validate_dims("data initialization", "sizesObs", "double", context__.to_vec(maxNsizesObs,nGroups));
            sizesObs = std::vector<std::vector<double> >(maxNsizesObs, std::vector<double>(nGroups, double(0)));
            vals_r__ = context__.vals_r("sizesObs");
            pos__ = 0;
            size_t sizesObs_k_0_max__ = maxNsizesObs;
            size_t sizesObs_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesObs_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesObs_k_0_max__; ++k_0__) {
                    sizesObs[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t sizesObs_i_0_max__ = maxNsizesObs;
            size_t sizesObs_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesObs_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesObs_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesObs[i_0__][i_1__]", sizesObs[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 479;
            validate_non_negative_index("propsObs", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsObs", "nGroups", nGroups);
            context__.validate_dims("data initialization", "propsObs", "double", context__.to_vec(maxNpropsObs,nGroups));
            propsObs = std::vector<std::vector<double> >(maxNpropsObs, std::vector<double>(nGroups, double(0)));
            vals_r__ = context__.vals_r("propsObs");
            pos__ = 0;
            size_t propsObs_k_0_max__ = maxNpropsObs;
            size_t propsObs_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsObs_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsObs_k_0_max__; ++k_0__) {
                    propsObs[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t propsObs_i_0_max__ = maxNpropsObs;
            size_t propsObs_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsObs_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsObs_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsObs[i_0__][i_1__]", propsObs[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 484;
            context__.validate_dims("data initialization", "maxNtimeIntervals", "int", context__.to_vec());
            maxNtimeIntervals = int(0);
            vals_i__ = context__.vals_i("maxNtimeIntervals");
            pos__ = 0;
            maxNtimeIntervals = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNtimeIntervals", maxNtimeIntervals, 0);
            current_statement_begin__ = 485;
            validate_non_negative_index("nTimeIntervals", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nTimeIntervals", "int", context__.to_vec((nGroups + 1)));
            nTimeIntervals = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nTimeIntervals");
            pos__ = 0;
            size_t nTimeIntervals_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nTimeIntervals_k_0_max__; ++k_0__) {
                nTimeIntervals[k_0__] = vals_i__[pos__++];
            }
            size_t nTimeIntervals_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nTimeIntervals_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nTimeIntervals[i_0__]", nTimeIntervals[i_0__], 0);
            }
            current_statement_begin__ = 486;
            validate_non_negative_index("intervalsLengths", "maxNtimeIntervals", maxNtimeIntervals);
            validate_non_negative_index("intervalsLengths", "nGroups", nGroups);
            context__.validate_dims("data initialization", "intervalsLengths", "double", context__.to_vec(maxNtimeIntervals,nGroups));
            intervalsLengths = std::vector<std::vector<double> >(maxNtimeIntervals, std::vector<double>(nGroups, double(0)));
            vals_r__ = context__.vals_r("intervalsLengths");
            pos__ = 0;
            size_t intervalsLengths_k_0_max__ = maxNtimeIntervals;
            size_t intervalsLengths_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < intervalsLengths_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < intervalsLengths_k_0_max__; ++k_0__) {
                    intervalsLengths[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t intervalsLengths_i_0_max__ = maxNtimeIntervals;
            size_t intervalsLengths_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < intervalsLengths_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < intervalsLengths_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "intervalsLengths[i_0__][i_1__]", intervalsLengths[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 490;
            context__.validate_dims("data initialization", "maxNobsTimes", "int", context__.to_vec());
            maxNobsTimes = int(0);
            vals_i__ = context__.vals_i("maxNobsTimes");
            pos__ = 0;
            maxNobsTimes = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNobsTimes", maxNobsTimes, 0);
            current_statement_begin__ = 491;
            validate_non_negative_index("nObsTimes", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nObsTimes", "int", context__.to_vec((nGroups + 1)));
            nObsTimes = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nObsTimes");
            pos__ = 0;
            size_t nObsTimes_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nObsTimes_k_0_max__; ++k_0__) {
                nObsTimes[k_0__] = vals_i__[pos__++];
            }
            size_t nObsTimes_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nObsTimes_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nObsTimes[i_0__]", nObsTimes[i_0__], 0);
            }
            current_statement_begin__ = 492;
            validate_non_negative_index("elapsedTimeSinceEvent", "nGroups", nGroups);
            validate_non_negative_index("elapsedTimeSinceEvent", "maxNobsTimes", maxNobsTimes);
            context__.validate_dims("data initialization", "elapsedTimeSinceEvent", "double", context__.to_vec(nGroups,maxNobsTimes));
            elapsedTimeSinceEvent = std::vector<std::vector<double> >(nGroups, std::vector<double>(maxNobsTimes, double(0)));
            vals_r__ = context__.vals_r("elapsedTimeSinceEvent");
            pos__ = 0;
            size_t elapsedTimeSinceEvent_k_0_max__ = nGroups;
            size_t elapsedTimeSinceEvent_k_1_max__ = maxNobsTimes;
            for (size_t k_1__ = 0; k_1__ < elapsedTimeSinceEvent_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < elapsedTimeSinceEvent_k_0_max__; ++k_0__) {
                    elapsedTimeSinceEvent[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t elapsedTimeSinceEvent_i_0_max__ = nGroups;
            size_t elapsedTimeSinceEvent_i_1_max__ = maxNobsTimes;
            for (size_t i_0__ = 0; i_0__ < elapsedTimeSinceEvent_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < elapsedTimeSinceEvent_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "elapsedTimeSinceEvent[i_0__][i_1__]", elapsedTimeSinceEvent[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 493;
            validate_non_negative_index("obsIntervalsIndices", "nGroups", nGroups);
            validate_non_negative_index("obsIntervalsIndices", "maxNobsTimes", maxNobsTimes);
            context__.validate_dims("data initialization", "obsIntervalsIndices", "int", context__.to_vec(nGroups,maxNobsTimes));
            obsIntervalsIndices = std::vector<std::vector<int> >(nGroups, std::vector<int>(maxNobsTimes, int(0)));
            vals_i__ = context__.vals_i("obsIntervalsIndices");
            pos__ = 0;
            size_t obsIntervalsIndices_k_0_max__ = nGroups;
            size_t obsIntervalsIndices_k_1_max__ = maxNobsTimes;
            for (size_t k_1__ = 0; k_1__ < obsIntervalsIndices_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < obsIntervalsIndices_k_0_max__; ++k_0__) {
                    obsIntervalsIndices[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t obsIntervalsIndices_i_0_max__ = nGroups;
            size_t obsIntervalsIndices_i_1_max__ = maxNobsTimes;
            for (size_t i_0__ = 0; i_0__ < obsIntervalsIndices_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < obsIntervalsIndices_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "obsIntervalsIndices[i_0__][i_1__]", obsIntervalsIndices[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 498;
            context__.validate_dims("data initialization", "maxNtimesteps", "int", context__.to_vec());
            maxNtimesteps = int(0);
            vals_i__ = context__.vals_i("maxNtimesteps");
            pos__ = 0;
            maxNtimesteps = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNtimesteps", maxNtimesteps, 2);
            current_statement_begin__ = 499;
            validate_non_negative_index("nTimesteps", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nTimesteps", "int", context__.to_vec((nGroups + 1)));
            nTimesteps = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nTimesteps");
            pos__ = 0;
            size_t nTimesteps_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nTimesteps_k_0_max__; ++k_0__) {
                nTimesteps[k_0__] = vals_i__[pos__++];
            }
            size_t nTimesteps_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nTimesteps_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nTimesteps[i_0__]", nTimesteps[i_0__], 0);
            }
            current_statement_begin__ = 500;
            context__.validate_dims("data initialization", "maxNuniqueDts", "int", context__.to_vec());
            maxNuniqueDts = int(0);
            vals_i__ = context__.vals_i("maxNuniqueDts");
            pos__ = 0;
            maxNuniqueDts = vals_i__[pos__++];
            check_greater_or_equal(function__, "maxNuniqueDts", maxNuniqueDts, 1);
            current_statement_begin__ = 501;
            validate_non_negative_index("nUniqueDts", "(nGroups + 1)", (nGroups + 1));
            context__.validate_dims("data initialization", "nUniqueDts", "int", context__.to_vec((nGroups + 1)));
            nUniqueDts = std::vector<int>((nGroups + 1), int(0));
            vals_i__ = context__.vals_i("nUniqueDts");
            pos__ = 0;
            size_t nUniqueDts_k_0_max__ = (nGroups + 1);
            for (size_t k_0__ = 0; k_0__ < nUniqueDts_k_0_max__; ++k_0__) {
                nUniqueDts[k_0__] = vals_i__[pos__++];
            }
            size_t nUniqueDts_i_0_max__ = (nGroups + 1);
            for (size_t i_0__ = 0; i_0__ < nUniqueDts_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nUniqueDts[i_0__]", nUniqueDts[i_0__], 0);
            }
            current_statement_begin__ = 502;
            validate_non_negative_index("unique_dts", "maxNuniqueDts", maxNuniqueDts);
            validate_non_negative_index("unique_dts", "nGroups", nGroups);
            context__.validate_dims("data initialization", "unique_dts", "double", context__.to_vec(maxNuniqueDts,nGroups));
            unique_dts = std::vector<std::vector<double> >(maxNuniqueDts, std::vector<double>(nGroups, double(0)));
            vals_r__ = context__.vals_r("unique_dts");
            pos__ = 0;
            size_t unique_dts_k_0_max__ = maxNuniqueDts;
            size_t unique_dts_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < unique_dts_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < unique_dts_k_0_max__; ++k_0__) {
                    unique_dts[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t unique_dts_i_0_max__ = maxNuniqueDts;
            size_t unique_dts_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < unique_dts_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < unique_dts_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "unique_dts[i_0__][i_1__]", unique_dts[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 503;
            validate_non_negative_index("timesteps", "maxNtimesteps", maxNtimesteps);
            validate_non_negative_index("timesteps", "nGroups", nGroups);
            context__.validate_dims("data initialization", "timesteps", "int", context__.to_vec(maxNtimesteps,nGroups));
            timesteps = std::vector<std::vector<int> >(maxNtimesteps, std::vector<int>(nGroups, int(0)));
            vals_i__ = context__.vals_i("timesteps");
            pos__ = 0;
            size_t timesteps_k_0_max__ = maxNtimesteps;
            size_t timesteps_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < timesteps_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < timesteps_k_0_max__; ++k_0__) {
                    timesteps[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t timesteps_i_0_max__ = maxNtimesteps;
            size_t timesteps_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < timesteps_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < timesteps_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "timesteps[i_0__][i_1__]", timesteps[i_0__][i_1__], 0);
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 512;
            nTotal = int(0);
            stan::math::fill(nTotal, std::numeric_limits<int>::min());
            current_statement_begin__ = 513;
            n_quantity_records = int(0);
            stan::math::fill(n_quantity_records, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 514;
            stan::math::assign(nTotal, 0);
            current_statement_begin__ = 517;
            for (int g = 1; g <= nGroups; ++g) {
                current_statement_begin__ = 518;
                stan::math::assign(nTotal, (nTotal + (get_base1(nSizesObs, g, "nSizesObs", 1) + get_base1(nPropsObs, g, "nPropsObs", 1))));
            }
            current_statement_begin__ = 522;
            if (as_bool(logical_eq(ode_method, 1))) {
                current_statement_begin__ = 524;
                stan::math::assign(n_quantity_records, (maxNobsTimes + 1));
            }
            current_statement_begin__ = 526;
            if (as_bool(logical_eq(ode_method, 2))) {
                current_statement_begin__ = 528;
                stan::math::assign(n_quantity_records, (maxNtimesteps + 1));
            }
            // validate transformed data
            current_statement_begin__ = 512;
            check_greater_or_equal(function__, "nTotal", nTotal, 0);
            current_statement_begin__ = 513;
            check_greater_or_equal(function__, "n_quantity_records", n_quantity_records, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 536;
            validate_non_negative_index("rawUniformParams", "nPriorUniform_code1", nPriorUniform_code1);
            num_params_r__ += nPriorUniform_code1;
            current_statement_begin__ = 537;
            validate_non_negative_index("rawHcauchyParams", "nPriorHcauchy_code2", nPriorHcauchy_code2);
            num_params_r__ += nPriorHcauchy_code2;
            current_statement_begin__ = 538;
            validate_non_negative_index("rawBetaParams", "nPriorBeta_code3", nPriorBeta_code3);
            num_params_r__ += nPriorBeta_code3;
            current_statement_begin__ = 539;
            validate_non_negative_index("rawTrNormParams", "nPriorTrNormal_code4", nPriorTrNormal_code4);
            num_params_r__ += nPriorTrNormal_code4;
            current_statement_begin__ = 540;
            validate_non_negative_index("rawExponentialParams", "nPriorExponential_code5", nPriorExponential_code5);
            num_params_r__ += nPriorExponential_code5;
            current_statement_begin__ = 541;
            validate_non_negative_index("rawGammaParams", "nPriorGamma_code6", nPriorGamma_code6);
            num_params_r__ += nPriorGamma_code6;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_networkModel() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 536;
        if (!(context__.contains_r("rawUniformParams")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawUniformParams missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawUniformParams");
        pos__ = 0U;
        validate_non_negative_index("rawUniformParams", "nPriorUniform_code1", nPriorUniform_code1);
        context__.validate_dims("parameter initialization", "rawUniformParams", "vector_d", context__.to_vec(nPriorUniform_code1));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawUniformParams(nPriorUniform_code1);
        size_t rawUniformParams_j_1_max__ = nPriorUniform_code1;
        for (size_t j_1__ = 0; j_1__ < rawUniformParams_j_1_max__; ++j_1__) {
            rawUniformParams(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, rawUniformParams);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawUniformParams: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 537;
        if (!(context__.contains_r("rawHcauchyParams")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawHcauchyParams missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawHcauchyParams");
        pos__ = 0U;
        validate_non_negative_index("rawHcauchyParams", "nPriorHcauchy_code2", nPriorHcauchy_code2);
        context__.validate_dims("parameter initialization", "rawHcauchyParams", "vector_d", context__.to_vec(nPriorHcauchy_code2));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawHcauchyParams(nPriorHcauchy_code2);
        size_t rawHcauchyParams_j_1_max__ = nPriorHcauchy_code2;
        for (size_t j_1__ = 0; j_1__ < rawHcauchyParams_j_1_max__; ++j_1__) {
            rawHcauchyParams(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, rawHcauchyParams);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawHcauchyParams: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 538;
        if (!(context__.contains_r("rawBetaParams")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawBetaParams missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawBetaParams");
        pos__ = 0U;
        validate_non_negative_index("rawBetaParams", "nPriorBeta_code3", nPriorBeta_code3);
        context__.validate_dims("parameter initialization", "rawBetaParams", "vector_d", context__.to_vec(nPriorBeta_code3));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawBetaParams(nPriorBeta_code3);
        size_t rawBetaParams_j_1_max__ = nPriorBeta_code3;
        for (size_t j_1__ = 0; j_1__ < rawBetaParams_j_1_max__; ++j_1__) {
            rawBetaParams(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, rawBetaParams);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawBetaParams: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 539;
        if (!(context__.contains_r("rawTrNormParams")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawTrNormParams missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawTrNormParams");
        pos__ = 0U;
        validate_non_negative_index("rawTrNormParams", "nPriorTrNormal_code4", nPriorTrNormal_code4);
        context__.validate_dims("parameter initialization", "rawTrNormParams", "vector_d", context__.to_vec(nPriorTrNormal_code4));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawTrNormParams(nPriorTrNormal_code4);
        size_t rawTrNormParams_j_1_max__ = nPriorTrNormal_code4;
        for (size_t j_1__ = 0; j_1__ < rawTrNormParams_j_1_max__; ++j_1__) {
            rawTrNormParams(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, rawTrNormParams);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawTrNormParams: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 540;
        if (!(context__.contains_r("rawExponentialParams")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawExponentialParams missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawExponentialParams");
        pos__ = 0U;
        validate_non_negative_index("rawExponentialParams", "nPriorExponential_code5", nPriorExponential_code5);
        context__.validate_dims("parameter initialization", "rawExponentialParams", "vector_d", context__.to_vec(nPriorExponential_code5));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawExponentialParams(nPriorExponential_code5);
        size_t rawExponentialParams_j_1_max__ = nPriorExponential_code5;
        for (size_t j_1__ = 0; j_1__ < rawExponentialParams_j_1_max__; ++j_1__) {
            rawExponentialParams(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, rawExponentialParams);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawExponentialParams: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 541;
        if (!(context__.contains_r("rawGammaParams")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawGammaParams missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawGammaParams");
        pos__ = 0U;
        validate_non_negative_index("rawGammaParams", "nPriorGamma_code6", nPriorGamma_code6);
        context__.validate_dims("parameter initialization", "rawGammaParams", "vector_d", context__.to_vec(nPriorGamma_code6));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawGammaParams(nPriorGamma_code6);
        size_t rawGammaParams_j_1_max__ = nPriorGamma_code6;
        for (size_t j_1__ = 0; j_1__ < rawGammaParams_j_1_max__; ++j_1__) {
            rawGammaParams(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, rawGammaParams);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawGammaParams: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 536;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawUniformParams;
            (void) rawUniformParams;  // dummy to suppress unused var warning
            if (jacobian__)
                rawUniformParams = in__.vector_lub_constrain(0, 1, nPriorUniform_code1, lp__);
            else
                rawUniformParams = in__.vector_lub_constrain(0, 1, nPriorUniform_code1);
            current_statement_begin__ = 537;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawHcauchyParams;
            (void) rawHcauchyParams;  // dummy to suppress unused var warning
            if (jacobian__)
                rawHcauchyParams = in__.vector_lb_constrain(0, nPriorHcauchy_code2, lp__);
            else
                rawHcauchyParams = in__.vector_lb_constrain(0, nPriorHcauchy_code2);
            current_statement_begin__ = 538;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawBetaParams;
            (void) rawBetaParams;  // dummy to suppress unused var warning
            if (jacobian__)
                rawBetaParams = in__.vector_lub_constrain(0, 1, nPriorBeta_code3, lp__);
            else
                rawBetaParams = in__.vector_lub_constrain(0, 1, nPriorBeta_code3);
            current_statement_begin__ = 539;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawTrNormParams;
            (void) rawTrNormParams;  // dummy to suppress unused var warning
            if (jacobian__)
                rawTrNormParams = in__.vector_lb_constrain(0, nPriorTrNormal_code4, lp__);
            else
                rawTrNormParams = in__.vector_lb_constrain(0, nPriorTrNormal_code4);
            current_statement_begin__ = 540;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawExponentialParams;
            (void) rawExponentialParams;  // dummy to suppress unused var warning
            if (jacobian__)
                rawExponentialParams = in__.vector_lb_constrain(0, nPriorExponential_code5, lp__);
            else
                rawExponentialParams = in__.vector_lb_constrain(0, nPriorExponential_code5);
            current_statement_begin__ = 541;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawGammaParams;
            (void) rawGammaParams;  // dummy to suppress unused var warning
            if (jacobian__)
                rawGammaParams = in__.vector_lb_constrain(0, nPriorGamma_code6, lp__);
            else
                rawGammaParams = in__.vector_lb_constrain(0, nPriorGamma_code6);
            // transformed parameters
            current_statement_begin__ = 553;
            validate_non_negative_index("params", "nParams", nParams);
            std::vector<local_scalar_t__> params(nParams, local_scalar_t__(0));
            stan::math::initialize(params, DUMMY_VAR__);
            stan::math::fill(params, DUMMY_VAR__);
            current_statement_begin__ = 556;
            validate_non_negative_index("initRefr", "nComps", nComps);
            validate_non_negative_index("initRefr", "2", 2);
            validate_non_negative_index("initRefr", "nGroups", nGroups);
            std::vector<std::vector<std::vector<local_scalar_t__> > > initRefr(nComps, std::vector<std::vector<local_scalar_t__> >(2, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0))));
            stan::math::initialize(initRefr, DUMMY_VAR__);
            stan::math::fill(initRefr, DUMMY_VAR__);
            stan::math::assign(initRefr,rep_array(0.0, nComps, 2, nGroups));
            current_statement_begin__ = 559;
            validate_non_negative_index("unmarked", "nComps", nComps);
            validate_non_negative_index("unmarked", "nGroups", nGroups);
            validate_non_negative_index("unmarked", "n_quantity_records", n_quantity_records);
            std::vector<std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > > unmarked(nGroups, std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> >(n_quantity_records, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nComps)));
            stan::math::initialize(unmarked, DUMMY_VAR__);
            stan::math::fill(unmarked, DUMMY_VAR__);
            current_statement_begin__ = 561;
            validate_non_negative_index("marked", "nComps", nComps);
            validate_non_negative_index("marked", "nGroups", nGroups);
            validate_non_negative_index("marked", "n_quantity_records", n_quantity_records);
            std::vector<std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > > marked(nGroups, std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> >(n_quantity_records, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nComps)));
            stan::math::initialize(marked, DUMMY_VAR__);
            stan::math::fill(marked, DUMMY_VAR__);
            current_statement_begin__ = 564;
            validate_non_negative_index("sizesPred", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > sizesPred(maxNsizesObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(sizesPred, DUMMY_VAR__);
            stan::math::fill(sizesPred, DUMMY_VAR__);
            current_statement_begin__ = 565;
            validate_non_negative_index("propsPred", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > propsPred(maxNpropsObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(propsPred, DUMMY_VAR__);
            stan::math::fill(propsPred, DUMMY_VAR__);
            current_statement_begin__ = 568;
            validate_non_negative_index("sizesPred_zeta", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred_zeta", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > sizesPred_zeta(maxNsizesObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(sizesPred_zeta, DUMMY_VAR__);
            stan::math::fill(sizesPred_zeta, DUMMY_VAR__);
            stan::math::assign(sizesPred_zeta,rep_array(0.0, maxNsizesObs, nGroups));
            current_statement_begin__ = 569;
            validate_non_negative_index("sizesPred_alpha", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred_alpha", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > sizesPred_alpha(maxNsizesObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(sizesPred_alpha, DUMMY_VAR__);
            stan::math::fill(sizesPred_alpha, DUMMY_VAR__);
            stan::math::assign(sizesPred_alpha,rep_array(0.0, maxNsizesObs, nGroups));
            current_statement_begin__ = 570;
            validate_non_negative_index("sizesPred_beta", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred_beta", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > sizesPred_beta(maxNsizesObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(sizesPred_beta, DUMMY_VAR__);
            stan::math::fill(sizesPred_beta, DUMMY_VAR__);
            stan::math::assign(sizesPred_beta,rep_array(0.0, maxNsizesObs, nGroups));
            current_statement_begin__ = 571;
            validate_non_negative_index("propsPred_eta", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred_eta", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > propsPred_eta(maxNpropsObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(propsPred_eta, DUMMY_VAR__);
            stan::math::fill(propsPred_eta, DUMMY_VAR__);
            stan::math::assign(propsPred_eta,rep_array(0.0, maxNpropsObs, nGroups));
            current_statement_begin__ = 572;
            validate_non_negative_index("propsPred_alpha", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred_alpha", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > propsPred_alpha(maxNpropsObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(propsPred_alpha, DUMMY_VAR__);
            stan::math::fill(propsPred_alpha, DUMMY_VAR__);
            stan::math::assign(propsPred_alpha,rep_array(0.0, maxNpropsObs, nGroups));
            current_statement_begin__ = 573;
            validate_non_negative_index("propsPred_beta", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred_beta", "nGroups", nGroups);
            std::vector<std::vector<local_scalar_t__> > propsPred_beta(maxNpropsObs, std::vector<local_scalar_t__>(nGroups, local_scalar_t__(0)));
            stan::math::initialize(propsPred_beta, DUMMY_VAR__);
            stan::math::fill(propsPred_beta, DUMMY_VAR__);
            stan::math::assign(propsPred_beta,rep_array(0.0, maxNpropsObs, nGroups));
            current_statement_begin__ = 579;
            validate_non_negative_index("transitions", "nComps", nComps);
            validate_non_negative_index("transitions", "nComps", nComps);
            validate_non_negative_index("transitions", "maxNuniqueDts", maxNuniqueDts);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > transitions(maxNuniqueDts, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(nComps, nComps));
            stan::math::initialize(transitions, DUMMY_VAR__);
            stan::math::fill(transitions, DUMMY_VAR__);
            current_statement_begin__ = 580;
            validate_non_negative_index("transitionsDecay", "nComps", nComps);
            validate_non_negative_index("transitionsDecay", "nComps", nComps);
            validate_non_negative_index("transitionsDecay", "maxNuniqueDts", maxNuniqueDts);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > transitionsDecay(maxNuniqueDts, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(nComps, nComps));
            stan::math::initialize(transitionsDecay, DUMMY_VAR__);
            stan::math::fill(transitionsDecay, DUMMY_VAR__);
            current_statement_begin__ = 585;
            validate_non_negative_index("transfer", "nComps", nComps);
            validate_non_negative_index("transfer", "nComps", nComps);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transfer(nComps, nComps);
            stan::math::initialize(transfer, DUMMY_VAR__);
            stan::math::fill(transfer, DUMMY_VAR__);
            current_statement_begin__ = 586;
            validate_non_negative_index("transferDecay", "nComps", nComps);
            validate_non_negative_index("transferDecay", "nComps", nComps);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transferDecay(nComps, nComps);
            stan::math::initialize(transferDecay, DUMMY_VAR__);
            stan::math::fill(transferDecay, DUMMY_VAR__);
            current_statement_begin__ = 587;
            validate_non_negative_index("transition_tmp", "nComps", nComps);
            validate_non_negative_index("transition_tmp", "nComps", nComps);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transition_tmp(nComps, nComps);
            stan::math::initialize(transition_tmp, DUMMY_VAR__);
            stan::math::fill(transition_tmp, DUMMY_VAR__);
            current_statement_begin__ = 588;
            validate_non_negative_index("transitionDecay_tmp", "nComps", nComps);
            validate_non_negative_index("transitionDecay_tmp", "nComps", nComps);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transitionDecay_tmp(nComps, nComps);
            stan::math::initialize(transitionDecay_tmp, DUMMY_VAR__);
            stan::math::fill(transitionDecay_tmp, DUMMY_VAR__);
            current_statement_begin__ = 592;
            validate_non_negative_index("intervals_init_states_marked", "nComps", nComps);
            validate_non_negative_index("intervals_init_states_marked", "maxNtimeIntervals", maxNtimeIntervals);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > intervals_init_states_marked(maxNtimeIntervals, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nComps));
            stan::math::initialize(intervals_init_states_marked, DUMMY_VAR__);
            stan::math::fill(intervals_init_states_marked, DUMMY_VAR__);
            current_statement_begin__ = 593;
            validate_non_negative_index("intervals_init_states_unmarked", "nComps", nComps);
            validate_non_negative_index("intervals_init_states_unmarked", "maxNtimeIntervals", maxNtimeIntervals);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > intervals_init_states_unmarked(maxNtimeIntervals, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nComps));
            stan::math::initialize(intervals_init_states_unmarked, DUMMY_VAR__);
            stan::math::fill(intervals_init_states_unmarked, DUMMY_VAR__);
            // transformed parameters block statements
            {
            current_statement_begin__ = 599;
            int pulseIndex(0);
            (void) pulseIndex;  // dummy to suppress unused var warning
            stan::math::fill(pulseIndex, std::numeric_limits<int>::min());
            current_statement_begin__ = 602;
            for (int i = 1; i <= nParams; ++i) {
                current_statement_begin__ = 603;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 0))) {
                    current_statement_begin__ = 604;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(constantParams, i, "constantParams", 1), 
                                "assigning variable params");
                }
                current_statement_begin__ = 606;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 1))) {
                    current_statement_begin__ = 607;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lowerParams, i, "lowerParams", 1) + ((get_base1(upperParams, i, "upperParams", 1) - get_base1(lowerParams, i, "lowerParams", 1)) * get_base1(rawUniformParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawUniformParams", 1))), 
                                "assigning variable params");
                }
                current_statement_begin__ = 609;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 2))) {
                    current_statement_begin__ = 610;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(hcauchyScaleParams, i, "hcauchyScaleParams", 1) * get_base1(rawHcauchyParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawHcauchyParams", 1)), 
                                "assigning variable params");
                }
                current_statement_begin__ = 612;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 3))) {
                    current_statement_begin__ = 613;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(betaScaleParams, i, "betaScaleParams", 1) * get_base1(rawBetaParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawBetaParams", 1)), 
                                "assigning variable params");
                }
                current_statement_begin__ = 615;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 4))) {
                    current_statement_begin__ = 616;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(rawTrNormParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawTrNormParams", 1), 
                                "assigning variable params");
                }
                current_statement_begin__ = 618;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 5))) {
                    current_statement_begin__ = 619;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(rawExponentialParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawExponentialParams", 1), 
                                "assigning variable params");
                }
                current_statement_begin__ = 621;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 6))) {
                    current_statement_begin__ = 622;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(rawGammaParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawGammaParams", 1), 
                                "assigning variable params");
                }
            }
            current_statement_begin__ = 627;
            for (int g = 1; g <= nGroups; ++g) {
                current_statement_begin__ = 631;
                if (as_bool(logical_eq(ode_method, 1))) {
                    current_statement_begin__ = 638;
                    stan::math::assign(transfer, buildTransferMatrix(nComps, get_base1(nSteady, g, "nSteady", 1), stan::model::rvalue(steadyIndices, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "steadyIndices"), get_base1(nUpsilons, g, "nUpsilons", 1), stan::model::rvalue(upsilonMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "upsilonMapping"), get_base1(nLambdas, g, "nLambdas", 1), stan::model::rvalue(lambdaMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "lambdaMapping"), params, pstream__));
                    current_statement_begin__ = 641;
                    stan::math::assign(transferDecay, buildTransferMatrixDecay(nComps, transfer, lambda_decay, pstream__));
                }
                current_statement_begin__ = 643;
                if (as_bool(logical_eq(ode_method, 2))) {
                    current_statement_begin__ = 645;
                    for (int i = 1; i <= get_base1(nUniqueDts, g, "nUniqueDts", 1); ++i) {
                        current_statement_begin__ = 646;
                        stan::model::assign(transitions, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    buildTransitionMatrix(nComps, get_base1(nUpsilons, g, "nUpsilons", 1), stan::model::rvalue(upsilonMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "upsilonMapping"), get_base1(nLambdas, g, "nLambdas", 1), stan::model::rvalue(lambdaMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "lambdaMapping"), get_base1(get_base1(unique_dts, i, "unique_dts", 1), g, "unique_dts", 2), params, pstream__), 
                                    "assigning variable transitions");
                        current_statement_begin__ = 650;
                        stan::model::assign(transitionsDecay, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    buildTransitionMatrixDecay(nComps, get_base1(transitions, i, "transitions", 1), lambda_decay, get_base1(get_base1(unique_dts, i, "unique_dts", 1), g, "unique_dts", 2), pstream__), 
                                    "assigning variable transitionsDecay");
                    }
                }
                current_statement_begin__ = 658;
                stan::math::assign(pulseIndex, 1);
                current_statement_begin__ = 662;
                stan::model::assign(unmarked, 
                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            to_vector(stan::model::rvalue(initialQuantities, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initialQuantities")), 
                            "assigning variable unmarked");
                current_statement_begin__ = 663;
                stan::model::assign(marked, 
                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            to_vector(stan::model::rvalue(initialQuantities, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initialQuantities")), 
                            "assigning variable marked");
                current_statement_begin__ = 666;
                if (as_bool(logical_gt(splitPresent, 0))) {
                    current_statement_begin__ = 667;
                    for (int j = 1; j <= nComps; ++j) {
                        current_statement_begin__ = 668;
                        if (as_bool(logical_gt(get_base1(get_base1(splitComps, j, "splitComps", 1), g, "splitComps", 2), 0))) {
                            current_statement_begin__ = 670;
                            stan::model::assign(initRefr, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(unmarked, g, "unmarked", 1), 1, "unmarked", 2), j, "unmarked", 3) * (1 - get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1))), 
                                        "assigning variable initRefr");
                            current_statement_begin__ = 671;
                            stan::model::assign(initRefr, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(marked, g, "marked", 1), 1, "marked", 2), j, "marked", 3) * (1 - get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1))), 
                                        "assigning variable initRefr");
                            current_statement_begin__ = 673;
                            stan::model::assign(unmarked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(unmarked, g, "unmarked", 1), 1, "unmarked", 2), j, "unmarked", 3) * get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1)), 
                                        "assigning variable unmarked");
                            current_statement_begin__ = 674;
                            stan::model::assign(marked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(marked, g, "marked", 1), 1, "marked", 2), j, "marked", 3) * get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1)), 
                                        "assigning variable marked");
                        }
                    }
                }
                current_statement_begin__ = 680;
                if (as_bool(logical_gt(get_base1(nPulseEvents, g, "nPulseEvents", 1), 0))) {
                    current_statement_begin__ = 681;
                    if (as_bool(logical_lte(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                        current_statement_begin__ = 682;
                        while (as_bool(logical_eq(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 1, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3), 1))) {
                            current_statement_begin__ = 683;
                            stan::model::assign(unmarked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "unmarked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 1, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                        "assigning variable unmarked");
                            current_statement_begin__ = 684;
                            stan::model::assign(marked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "marked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 2, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                        "assigning variable marked");
                            current_statement_begin__ = 685;
                            stan::math::assign(pulseIndex, (pulseIndex + 1));
                            current_statement_begin__ = 686;
                            if (as_bool(logical_gt(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                current_statement_begin__ = 687;
                                break;
                            }
                        }
                    }
                }
                current_statement_begin__ = 694;
                if (as_bool(logical_eq(ode_method, 1))) {
                    current_statement_begin__ = 697;
                    stan::model::assign(intervals_init_states_unmarked, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(get_base1(unmarked, g, "unmarked", 1), 1, "unmarked", 2), 
                                "assigning variable intervals_init_states_unmarked");
                    current_statement_begin__ = 698;
                    stan::model::assign(intervals_init_states_marked, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(get_base1(marked, g, "marked", 1), 1, "marked", 2), 
                                "assigning variable intervals_init_states_marked");
                    current_statement_begin__ = 704;
                    if (as_bool(logical_gt(get_base1(nTimeIntervals, g, "nTimeIntervals", 1), 1))) {
                        current_statement_begin__ = 705;
                        for (int t = 2; t <= get_base1(nTimeIntervals, g, "nTimeIntervals", 1); ++t) {
                            current_statement_begin__ = 708;
                            stan::math::assign(transition_tmp, matrix_exp(multiply(get_base1(get_base1(intervalsLengths, (t - 1), "intervalsLengths", 1), g, "intervalsLengths", 2), transfer)));
                            current_statement_begin__ = 709;
                            if (as_bool(logical_eq(lambda_decay, 0))) {
                                current_statement_begin__ = 710;
                                stan::math::assign(transitionDecay_tmp, transition_tmp);
                            } else {
                                current_statement_begin__ = 712;
                                stan::math::assign(transitionDecay_tmp, matrix_exp(multiply(get_base1(get_base1(intervalsLengths, (t - 1), "intervalsLengths", 1), g, "intervalsLengths", 2), transferDecay)));
                            }
                            current_statement_begin__ = 714;
                            stan::model::assign(intervals_init_states_unmarked, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                        multiply(transition_tmp, get_base1(intervals_init_states_unmarked, (t - 1), "intervals_init_states_unmarked", 1)), 
                                        "assigning variable intervals_init_states_unmarked");
                            current_statement_begin__ = 715;
                            stan::model::assign(intervals_init_states_marked, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                        multiply(transitionDecay_tmp, get_base1(intervals_init_states_marked, (t - 1), "intervals_init_states_marked", 1)), 
                                        "assigning variable intervals_init_states_marked");
                            current_statement_begin__ = 718;
                            if (as_bool(logical_gt(get_base1(nPulseEvents, g, "nPulseEvents", 1), 0))) {
                                current_statement_begin__ = 719;
                                if (as_bool(logical_lte(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                    current_statement_begin__ = 720;
                                    while (as_bool(logical_eq(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 1, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3), t))) {
                                        current_statement_begin__ = 721;
                                        stan::model::assign(intervals_init_states_unmarked, 
                                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), 
                                                    (stan::model::rvalue(intervals_init_states_unmarked, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), "intervals_init_states_unmarked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 1, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                    "assigning variable intervals_init_states_unmarked");
                                        current_statement_begin__ = 722;
                                        stan::model::assign(intervals_init_states_marked, 
                                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), 
                                                    (stan::model::rvalue(intervals_init_states_marked, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), "intervals_init_states_marked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 2, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                    "assigning variable intervals_init_states_marked");
                                        current_statement_begin__ = 723;
                                        stan::math::assign(pulseIndex, (pulseIndex + 1));
                                        current_statement_begin__ = 724;
                                        if (as_bool(logical_gt(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                            current_statement_begin__ = 725;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    current_statement_begin__ = 734;
                    for (int k = 1; k <= get_base1(nObsTimes, g, "nObsTimes", 1); ++k) {
                        current_statement_begin__ = 735;
                        stan::math::assign(transition_tmp, matrix_exp(multiply(get_base1(get_base1(elapsedTimeSinceEvent, g, "elapsedTimeSinceEvent", 1), k, "elapsedTimeSinceEvent", 2), transfer)));
                        current_statement_begin__ = 736;
                        if (as_bool(logical_eq(lambda_decay, 0))) {
                            current_statement_begin__ = 737;
                            stan::math::assign(transitionDecay_tmp, transition_tmp);
                        } else {
                            current_statement_begin__ = 739;
                            stan::math::assign(transitionDecay_tmp, matrix_exp(multiply(get_base1(get_base1(elapsedTimeSinceEvent, g, "elapsedTimeSinceEvent", 1), k, "elapsedTimeSinceEvent", 2), transferDecay)));
                        }
                        current_statement_begin__ = 741;
                        stan::model::assign(unmarked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    multiply(transition_tmp, get_base1(intervals_init_states_unmarked, get_base1(get_base1(obsIntervalsIndices, g, "obsIntervalsIndices", 1), k, "obsIntervalsIndices", 2), "intervals_init_states_unmarked", 1)), 
                                    "assigning variable unmarked");
                        current_statement_begin__ = 742;
                        stan::model::assign(marked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    multiply(transitionDecay_tmp, get_base1(intervals_init_states_marked, get_base1(get_base1(obsIntervalsIndices, g, "obsIntervalsIndices", 1), k, "obsIntervalsIndices", 2), "intervals_init_states_marked", 1)), 
                                    "assigning variable marked");
                    }
                }
                current_statement_begin__ = 748;
                if (as_bool(logical_eq(ode_method, 2))) {
                    current_statement_begin__ = 751;
                    for (int t = 1; t <= get_base1(nTimesteps, g, "nTimesteps", 1); ++t) {
                        current_statement_begin__ = 754;
                        stan::model::assign(unmarked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    multiply(get_base1(transitions, get_base1(get_base1(timesteps, t, "timesteps", 1), g, "timesteps", 2), "transitions", 1), get_base1(get_base1(unmarked, g, "unmarked", 1), t, "unmarked", 2)), 
                                    "assigning variable unmarked");
                        current_statement_begin__ = 755;
                        stan::model::assign(marked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    multiply(get_base1(transitionsDecay, get_base1(get_base1(timesteps, t, "timesteps", 1), g, "timesteps", 2), "transitionsDecay", 1), get_base1(get_base1(marked, g, "marked", 1), t, "marked", 2)), 
                                    "assigning variable marked");
                        current_statement_begin__ = 758;
                        if (as_bool(logical_gt(get_base1(nSteady, g, "nSteady", 1), 0))) {
                            current_statement_begin__ = 759;
                            for (int k = 1; k <= get_base1(nSteady, g, "nSteady", 1); ++k) {
                                current_statement_begin__ = 760;
                                stan::model::assign(unmarked, 
                                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2)), stan::model::nil_index_list()))), 
                                            get_base1(get_base1(get_base1(unmarked, g, "unmarked", 1), t, "unmarked", 2), get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2), "unmarked", 3), 
                                            "assigning variable unmarked");
                                current_statement_begin__ = 761;
                                stan::model::assign(marked, 
                                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2)), stan::model::nil_index_list()))), 
                                            get_base1(get_base1(get_base1(marked, g, "marked", 1), t, "marked", 2), get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2), "marked", 3), 
                                            "assigning variable marked");
                            }
                        }
                        current_statement_begin__ = 766;
                        if (as_bool(logical_gt(get_base1(nPulseEvents, g, "nPulseEvents", 1), 0))) {
                            current_statement_begin__ = 767;
                            if (as_bool(logical_lte(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                current_statement_begin__ = 768;
                                while (as_bool(logical_eq(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 1, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3), (t + 1)))) {
                                    current_statement_begin__ = 769;
                                    stan::model::assign(unmarked, 
                                                stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                                (stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "unmarked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 1, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                "assigning variable unmarked");
                                    current_statement_begin__ = 770;
                                    stan::model::assign(marked, 
                                                stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                                (stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "marked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 2, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                "assigning variable marked");
                                    current_statement_begin__ = 771;
                                    stan::math::assign(pulseIndex, (pulseIndex + 1));
                                    current_statement_begin__ = 772;
                                    if (as_bool(logical_gt(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                        current_statement_begin__ = 773;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                current_statement_begin__ = 785;
                stan::model::assign(sizesPred, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                            buildSizePredictions(get_base1(nSizesObs, g, "nSizesObs", 1), g, maxNsizesObs, stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "unmarked"), stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "marked"), stan::model::rvalue(sizesObsIndices, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "sizesObsIndices"), splitPresent, stan::model::rvalue(splitComps, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "splitComps"), stan::model::rvalue(initRefr, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initRefr"), pstream__), 
                            "assigning variable sizesPred");
                current_statement_begin__ = 790;
                stan::model::assign(propsPred, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                            buildPropPredictions(get_base1(nPropsObs, g, "nPropsObs", 1), g, maxNpropsObs, stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "unmarked"), stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "marked"), stan::model::rvalue(propsObsIndices, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "propsObsIndices"), splitPresent, stan::model::rvalue(splitComps, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "splitComps"), stan::model::rvalue(initRefr, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initRefr"), pstream__), 
                            "assigning variable propsPred");
                current_statement_begin__ = 797;
                for (int k = 1; k <= get_base1(nSizesObs, g, "nSizesObs", 1); ++k) {
                    current_statement_begin__ = 798;
                    stan::model::assign(sizesPred_zeta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                get_base1(params, get_base1(get_base1(get_base1(sizesObsIndices, k, "sizesObsIndices", 1), 3, "sizesObsIndices", 2), g, "sizesObsIndices", 3), "params", 1), 
                                "assigning variable sizesPred_zeta");
                    current_statement_begin__ = 799;
                    if (as_bool(logical_eq(sizeFamily, 1))) {
                        current_statement_begin__ = 801;
                        stan::model::assign(sizesPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(sizesPred, k, "sizesPred", 1), g, "sizesPred", 2), 
                                    "assigning variable sizesPred_alpha");
                        current_statement_begin__ = 802;
                        stan::model::assign(sizesPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(sizesPred_zeta, k, "sizesPred_zeta", 1), g, "sizesPred_zeta", 2) * get_base1(get_base1(sizesPred, k, "sizesPred", 1), g, "sizesPred", 2)), 
                                    "assigning variable sizesPred_beta");
                    }
                    current_statement_begin__ = 804;
                    if (as_bool(logical_eq(sizeFamily, 2))) {
                        current_statement_begin__ = 806;
                        stan::model::assign(sizesPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(sizesPred, k, "sizesPred", 1), g, "sizesPred", 2), 
                                    "assigning variable sizesPred_alpha");
                        current_statement_begin__ = 807;
                        stan::model::assign(sizesPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(sizesPred_zeta, k, "sizesPred_zeta", 1), g, "sizesPred_zeta", 2), 
                                    "assigning variable sizesPred_beta");
                    }
                }
                current_statement_begin__ = 810;
                for (int k = 1; k <= get_base1(nPropsObs, g, "nPropsObs", 1); ++k) {
                    current_statement_begin__ = 811;
                    stan::model::assign(propsPred_eta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                get_base1(params, get_base1(get_base1(get_base1(propsObsIndices, k, "propsObsIndices", 1), 3, "propsObsIndices", 2), g, "propsObsIndices", 3), "params", 1), 
                                "assigning variable propsPred_eta");
                    current_statement_begin__ = 812;
                    if (as_bool(logical_eq(propFamily, 1))) {
                        current_statement_begin__ = 814;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    pow(get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2), -(2)), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 815;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred_alpha, k, "propsPred_alpha", 1), g, "propsPred_alpha", 2) / get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2)), 
                                    "assigning variable propsPred_beta");
                    }
                    current_statement_begin__ = 817;
                    if (as_bool(logical_eq(propFamily, 2))) {
                        current_statement_begin__ = 819;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 820;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2) * get_base1(get_base1(propsPred_alpha, k, "propsPred_alpha", 1), g, "propsPred_alpha", 2)), 
                                    "assigning variable propsPred_beta");
                    }
                    current_statement_begin__ = 822;
                    if (as_bool(logical_eq(propFamily, 3))) {
                        current_statement_begin__ = 824;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 825;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2), 
                                    "assigning variable propsPred_beta");
                    }
                    current_statement_begin__ = 827;
                    if (as_bool(logical_eq(propFamily, 4))) {
                        current_statement_begin__ = 829;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2) * get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2)), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 830;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2) * (1 - get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2))), 
                                    "assigning variable propsPred_beta");
                    }
                }
            }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 553;
            size_t params_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < params_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(params[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: params" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable params: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t params_i_0_max__ = nParams;
            for (size_t i_0__ = 0; i_0__ < params_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "params[i_0__]", params[i_0__], 0);
            }
            current_statement_begin__ = 556;
            size_t initRefr_k_0_max__ = nComps;
            size_t initRefr_k_1_max__ = 2;
            size_t initRefr_k_2_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < initRefr_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < initRefr_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < initRefr_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(initRefr[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: initRefr" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable initRefr: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t initRefr_i_0_max__ = nComps;
            size_t initRefr_i_1_max__ = 2;
            size_t initRefr_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < initRefr_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < initRefr_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < initRefr_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "initRefr[i_0__][i_1__][i_2__]", initRefr[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 559;
            size_t unmarked_k_0_max__ = nGroups;
            size_t unmarked_k_1_max__ = n_quantity_records;
            size_t unmarked_j_1_max__ = nComps;
            for (size_t k_0__ = 0; k_0__ < unmarked_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < unmarked_k_1_max__; ++k_1__) {
                    for (size_t j_1__ = 0; j_1__ < unmarked_j_1_max__; ++j_1__) {
                        if (stan::math::is_uninitialized(unmarked[k_0__][k_1__](j_1__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: unmarked" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "(" << j_1__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable unmarked: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 561;
            size_t marked_k_0_max__ = nGroups;
            size_t marked_k_1_max__ = n_quantity_records;
            size_t marked_j_1_max__ = nComps;
            for (size_t k_0__ = 0; k_0__ < marked_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < marked_k_1_max__; ++k_1__) {
                    for (size_t j_1__ = 0; j_1__ < marked_j_1_max__; ++j_1__) {
                        if (stan::math::is_uninitialized(marked[k_0__][k_1__](j_1__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: marked" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "(" << j_1__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable marked: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 564;
            size_t sizesPred_k_0_max__ = maxNsizesObs;
            size_t sizesPred_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < sizesPred_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < sizesPred_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(sizesPred[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sizesPred" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sizesPred: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t sizesPred_i_0_max__ = maxNsizesObs;
            size_t sizesPred_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred[i_0__][i_1__]", sizesPred[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 565;
            size_t propsPred_k_0_max__ = maxNpropsObs;
            size_t propsPred_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < propsPred_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < propsPred_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(propsPred[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: propsPred" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable propsPred: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t propsPred_i_0_max__ = maxNpropsObs;
            size_t propsPred_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred[i_0__][i_1__]", propsPred[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 568;
            size_t sizesPred_zeta_k_0_max__ = maxNsizesObs;
            size_t sizesPred_zeta_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < sizesPred_zeta_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < sizesPred_zeta_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(sizesPred_zeta[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sizesPred_zeta" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sizesPred_zeta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t sizesPred_zeta_i_0_max__ = maxNsizesObs;
            size_t sizesPred_zeta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_zeta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_zeta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred_zeta[i_0__][i_1__]", sizesPred_zeta[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 569;
            size_t sizesPred_alpha_k_0_max__ = maxNsizesObs;
            size_t sizesPred_alpha_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < sizesPred_alpha_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < sizesPred_alpha_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(sizesPred_alpha[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sizesPred_alpha" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sizesPred_alpha: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t sizesPred_alpha_i_0_max__ = maxNsizesObs;
            size_t sizesPred_alpha_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_alpha_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_alpha_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred_alpha[i_0__][i_1__]", sizesPred_alpha[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 570;
            size_t sizesPred_beta_k_0_max__ = maxNsizesObs;
            size_t sizesPred_beta_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < sizesPred_beta_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < sizesPred_beta_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(sizesPred_beta[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sizesPred_beta" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sizesPred_beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t sizesPred_beta_i_0_max__ = maxNsizesObs;
            size_t sizesPred_beta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_beta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_beta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred_beta[i_0__][i_1__]", sizesPred_beta[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 571;
            size_t propsPred_eta_k_0_max__ = maxNpropsObs;
            size_t propsPred_eta_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < propsPred_eta_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < propsPred_eta_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(propsPred_eta[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: propsPred_eta" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable propsPred_eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t propsPred_eta_i_0_max__ = maxNpropsObs;
            size_t propsPred_eta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_eta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_eta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred_eta[i_0__][i_1__]", propsPred_eta[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 572;
            size_t propsPred_alpha_k_0_max__ = maxNpropsObs;
            size_t propsPred_alpha_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < propsPred_alpha_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < propsPred_alpha_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(propsPred_alpha[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: propsPred_alpha" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable propsPred_alpha: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t propsPred_alpha_i_0_max__ = maxNpropsObs;
            size_t propsPred_alpha_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_alpha_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_alpha_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred_alpha[i_0__][i_1__]", propsPred_alpha[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 573;
            size_t propsPred_beta_k_0_max__ = maxNpropsObs;
            size_t propsPred_beta_k_1_max__ = nGroups;
            for (size_t k_0__ = 0; k_0__ < propsPred_beta_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < propsPred_beta_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(propsPred_beta[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: propsPred_beta" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable propsPred_beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t propsPred_beta_i_0_max__ = maxNpropsObs;
            size_t propsPred_beta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_beta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_beta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred_beta[i_0__][i_1__]", propsPred_beta[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 579;
            size_t transitions_k_0_max__ = maxNuniqueDts;
            size_t transitions_j_1_max__ = nComps;
            size_t transitions_j_2_max__ = nComps;
            for (size_t k_0__ = 0; k_0__ < transitions_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < transitions_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < transitions_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(transitions[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: transitions" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transitions: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 580;
            size_t transitionsDecay_k_0_max__ = maxNuniqueDts;
            size_t transitionsDecay_j_1_max__ = nComps;
            size_t transitionsDecay_j_2_max__ = nComps;
            for (size_t k_0__ = 0; k_0__ < transitionsDecay_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < transitionsDecay_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < transitionsDecay_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(transitionsDecay[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: transitionsDecay" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transitionsDecay: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 585;
            size_t transfer_j_1_max__ = nComps;
            size_t transfer_j_2_max__ = nComps;
            for (size_t j_1__ = 0; j_1__ < transfer_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < transfer_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(transfer(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transfer" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transfer: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 586;
            size_t transferDecay_j_1_max__ = nComps;
            size_t transferDecay_j_2_max__ = nComps;
            for (size_t j_1__ = 0; j_1__ < transferDecay_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < transferDecay_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(transferDecay(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transferDecay" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transferDecay: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 587;
            size_t transition_tmp_j_1_max__ = nComps;
            size_t transition_tmp_j_2_max__ = nComps;
            for (size_t j_1__ = 0; j_1__ < transition_tmp_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < transition_tmp_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(transition_tmp(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transition_tmp" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transition_tmp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 588;
            size_t transitionDecay_tmp_j_1_max__ = nComps;
            size_t transitionDecay_tmp_j_2_max__ = nComps;
            for (size_t j_1__ = 0; j_1__ < transitionDecay_tmp_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < transitionDecay_tmp_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(transitionDecay_tmp(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transitionDecay_tmp" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transitionDecay_tmp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 592;
            size_t intervals_init_states_marked_k_0_max__ = maxNtimeIntervals;
            size_t intervals_init_states_marked_j_1_max__ = nComps;
            for (size_t k_0__ = 0; k_0__ < intervals_init_states_marked_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < intervals_init_states_marked_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(intervals_init_states_marked[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: intervals_init_states_marked" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable intervals_init_states_marked: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 593;
            size_t intervals_init_states_unmarked_k_0_max__ = maxNtimeIntervals;
            size_t intervals_init_states_unmarked_j_1_max__ = nComps;
            for (size_t k_0__ = 0; k_0__ < intervals_init_states_unmarked_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < intervals_init_states_unmarked_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(intervals_init_states_unmarked[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: intervals_init_states_unmarked" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable intervals_init_states_unmarked: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 845;
            for (int i = 1; i <= nParams; ++i) {
                current_statement_begin__ = 846;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 1))) {
                    current_statement_begin__ = 847;
                    lp_accum__.add(uniform_log<propto__>(get_base1(rawUniformParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawUniformParams", 1), 0, 1));
                }
                current_statement_begin__ = 849;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 2))) {
                    current_statement_begin__ = 850;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(rawHcauchyParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawHcauchyParams", 1), 0, 1));
                }
                current_statement_begin__ = 852;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 3))) {
                    current_statement_begin__ = 853;
                    lp_accum__.add(beta_log<propto__>(get_base1(rawBetaParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawBetaParams", 1), get_base1(rawBetaAlpha, i, "rawBetaAlpha", 1), get_base1(rawBetaBeta, i, "rawBetaBeta", 1)));
                }
                current_statement_begin__ = 855;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 4))) {
                    current_statement_begin__ = 856;
                    lp_accum__.add(normal_log<propto__>(get_base1(rawTrNormParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawTrNormParams", 1), get_base1(trNormMeanParams, i, "trNormMeanParams", 1), get_base1(trNormSdParams, i, "trNormSdParams", 1)));
                }
                current_statement_begin__ = 858;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 5))) {
                    current_statement_begin__ = 859;
                    lp_accum__.add(exponential_log<propto__>(get_base1(rawExponentialParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawExponentialParams", 1), get_base1(exponentialRateParams, i, "exponentialRateParams", 1)));
                }
                current_statement_begin__ = 861;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 6))) {
                    current_statement_begin__ = 862;
                    lp_accum__.add(gamma_log<propto__>(get_base1(rawGammaParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawGammaParams", 1), get_base1(gammaAlphaParams, i, "gammaAlphaParams", 1), get_base1(gammaBetaParams, i, "gammaBetaParams", 1)));
                }
            }
            current_statement_begin__ = 868;
            for (int g = 1; g <= nGroups; ++g) {
                current_statement_begin__ = 871;
                if (as_bool(logical_eq(sizeFamily, 1))) {
                    current_statement_begin__ = 873;
                    lp_accum__.add(normal_log<propto__>(stan::model::rvalue(sizesObs, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nSizesObs, g, "nSizesObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "sizesObs"), stan::model::rvalue(sizesPred_alpha, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nSizesObs, g, "nSizesObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "sizesPred_alpha"), stan::model::rvalue(sizesPred_beta, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nSizesObs, g, "nSizesObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "sizesPred_beta")));
                }
                current_statement_begin__ = 876;
                if (as_bool(logical_eq(sizeFamily, 2))) {
                    current_statement_begin__ = 878;
                    lp_accum__.add(normal_log<propto__>(stan::model::rvalue(sizesObs, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nSizesObs, g, "nSizesObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "sizesObs"), stan::model::rvalue(sizesPred_alpha, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nSizesObs, g, "nSizesObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "sizesPred_alpha"), stan::model::rvalue(sizesPred_beta, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nSizesObs, g, "nSizesObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "sizesPred_beta")));
                }
                current_statement_begin__ = 883;
                if (as_bool(logical_eq(propFamily, 1))) {
                    current_statement_begin__ = 885;
                    lp_accum__.add(gamma_log<propto__>(stan::model::rvalue(propsObs, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsObs"), stan::model::rvalue(propsPred_alpha, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_alpha"), stan::model::rvalue(propsPred_beta, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_beta")));
                }
                current_statement_begin__ = 888;
                if (as_bool(logical_eq(propFamily, 2))) {
                    current_statement_begin__ = 890;
                    lp_accum__.add(normal_log<propto__>(stan::model::rvalue(propsObs, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsObs"), stan::model::rvalue(propsPred_alpha, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_alpha"), stan::model::rvalue(propsPred_beta, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_beta")));
                }
                current_statement_begin__ = 893;
                if (as_bool(logical_eq(propFamily, 3))) {
                    current_statement_begin__ = 895;
                    lp_accum__.add(normal_log<propto__>(stan::model::rvalue(propsObs, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsObs"), stan::model::rvalue(propsPred_alpha, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_alpha"), stan::model::rvalue(propsPred_beta, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_beta")));
                }
                current_statement_begin__ = 898;
                if (as_bool(logical_eq(propFamily, 4))) {
                    current_statement_begin__ = 900;
                    lp_accum__.add(beta_log<propto__>(stan::model::rvalue(propsObs, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsObs"), stan::model::rvalue(propsPred_alpha, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_alpha"), stan::model::rvalue(propsPred_beta, stan::model::cons_list(stan::model::index_min_max(1, get_base1(nPropsObs, g, "nPropsObs", 1)), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "propsPred_beta")));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("rawUniformParams");
        names__.push_back("rawHcauchyParams");
        names__.push_back("rawBetaParams");
        names__.push_back("rawTrNormParams");
        names__.push_back("rawExponentialParams");
        names__.push_back("rawGammaParams");
        names__.push_back("params");
        names__.push_back("initRefr");
        names__.push_back("unmarked");
        names__.push_back("marked");
        names__.push_back("sizesPred");
        names__.push_back("propsPred");
        names__.push_back("sizesPred_zeta");
        names__.push_back("sizesPred_alpha");
        names__.push_back("sizesPred_beta");
        names__.push_back("propsPred_eta");
        names__.push_back("propsPred_alpha");
        names__.push_back("propsPred_beta");
        names__.push_back("transitions");
        names__.push_back("transitionsDecay");
        names__.push_back("transfer");
        names__.push_back("transferDecay");
        names__.push_back("transition_tmp");
        names__.push_back("transitionDecay_tmp");
        names__.push_back("intervals_init_states_marked");
        names__.push_back("intervals_init_states_unmarked");
        names__.push_back("nonConstantParams");
        names__.push_back("paramIndex");
        names__.push_back("log_lik");
        names__.push_back("llIndexShift");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nPriorUniform_code1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nPriorHcauchy_code2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nPriorBeta_code3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nPriorTrNormal_code4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nPriorExponential_code5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nPriorGamma_code6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nParams);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nComps);
        dims__.push_back(2);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nGroups);
        dims__.push_back(n_quantity_records);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nGroups);
        dims__.push_back(n_quantity_records);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNsizesObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNpropsObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNsizesObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNsizesObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNsizesObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNpropsObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNpropsObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNpropsObs);
        dims__.push_back(nGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNuniqueDts);
        dims__.push_back(nComps);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNuniqueDts);
        dims__.push_back(nComps);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nComps);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nComps);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nComps);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nComps);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNtimeIntervals);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(maxNtimeIntervals);
        dims__.push_back(nComps);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNonConstantPriors);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nTotal);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_networkModel_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawUniformParams = in__.vector_lub_constrain(0, 1, nPriorUniform_code1);
        size_t rawUniformParams_j_1_max__ = nPriorUniform_code1;
        for (size_t j_1__ = 0; j_1__ < rawUniformParams_j_1_max__; ++j_1__) {
            vars__.push_back(rawUniformParams(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawHcauchyParams = in__.vector_lb_constrain(0, nPriorHcauchy_code2);
        size_t rawHcauchyParams_j_1_max__ = nPriorHcauchy_code2;
        for (size_t j_1__ = 0; j_1__ < rawHcauchyParams_j_1_max__; ++j_1__) {
            vars__.push_back(rawHcauchyParams(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawBetaParams = in__.vector_lub_constrain(0, 1, nPriorBeta_code3);
        size_t rawBetaParams_j_1_max__ = nPriorBeta_code3;
        for (size_t j_1__ = 0; j_1__ < rawBetaParams_j_1_max__; ++j_1__) {
            vars__.push_back(rawBetaParams(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawTrNormParams = in__.vector_lb_constrain(0, nPriorTrNormal_code4);
        size_t rawTrNormParams_j_1_max__ = nPriorTrNormal_code4;
        for (size_t j_1__ = 0; j_1__ < rawTrNormParams_j_1_max__; ++j_1__) {
            vars__.push_back(rawTrNormParams(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawExponentialParams = in__.vector_lb_constrain(0, nPriorExponential_code5);
        size_t rawExponentialParams_j_1_max__ = nPriorExponential_code5;
        for (size_t j_1__ = 0; j_1__ < rawExponentialParams_j_1_max__; ++j_1__) {
            vars__.push_back(rawExponentialParams(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawGammaParams = in__.vector_lb_constrain(0, nPriorGamma_code6);
        size_t rawGammaParams_j_1_max__ = nPriorGamma_code6;
        for (size_t j_1__ = 0; j_1__ < rawGammaParams_j_1_max__; ++j_1__) {
            vars__.push_back(rawGammaParams(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 553;
            validate_non_negative_index("params", "nParams", nParams);
            std::vector<double> params(nParams, double(0));
            stan::math::initialize(params, DUMMY_VAR__);
            stan::math::fill(params, DUMMY_VAR__);
            current_statement_begin__ = 556;
            validate_non_negative_index("initRefr", "nComps", nComps);
            validate_non_negative_index("initRefr", "2", 2);
            validate_non_negative_index("initRefr", "nGroups", nGroups);
            std::vector<std::vector<std::vector<double> > > initRefr(nComps, std::vector<std::vector<double> >(2, std::vector<double>(nGroups, double(0))));
            stan::math::initialize(initRefr, DUMMY_VAR__);
            stan::math::fill(initRefr, DUMMY_VAR__);
            stan::math::assign(initRefr,rep_array(0.0, nComps, 2, nGroups));
            current_statement_begin__ = 559;
            validate_non_negative_index("unmarked", "nComps", nComps);
            validate_non_negative_index("unmarked", "nGroups", nGroups);
            validate_non_negative_index("unmarked", "n_quantity_records", n_quantity_records);
            std::vector<std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > > unmarked(nGroups, std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(n_quantity_records, Eigen::Matrix<double, Eigen::Dynamic, 1>(nComps)));
            stan::math::initialize(unmarked, DUMMY_VAR__);
            stan::math::fill(unmarked, DUMMY_VAR__);
            current_statement_begin__ = 561;
            validate_non_negative_index("marked", "nComps", nComps);
            validate_non_negative_index("marked", "nGroups", nGroups);
            validate_non_negative_index("marked", "n_quantity_records", n_quantity_records);
            std::vector<std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > > marked(nGroups, std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(n_quantity_records, Eigen::Matrix<double, Eigen::Dynamic, 1>(nComps)));
            stan::math::initialize(marked, DUMMY_VAR__);
            stan::math::fill(marked, DUMMY_VAR__);
            current_statement_begin__ = 564;
            validate_non_negative_index("sizesPred", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred", "nGroups", nGroups);
            std::vector<std::vector<double> > sizesPred(maxNsizesObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(sizesPred, DUMMY_VAR__);
            stan::math::fill(sizesPred, DUMMY_VAR__);
            current_statement_begin__ = 565;
            validate_non_negative_index("propsPred", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred", "nGroups", nGroups);
            std::vector<std::vector<double> > propsPred(maxNpropsObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(propsPred, DUMMY_VAR__);
            stan::math::fill(propsPred, DUMMY_VAR__);
            current_statement_begin__ = 568;
            validate_non_negative_index("sizesPred_zeta", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred_zeta", "nGroups", nGroups);
            std::vector<std::vector<double> > sizesPred_zeta(maxNsizesObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(sizesPred_zeta, DUMMY_VAR__);
            stan::math::fill(sizesPred_zeta, DUMMY_VAR__);
            stan::math::assign(sizesPred_zeta,rep_array(0.0, maxNsizesObs, nGroups));
            current_statement_begin__ = 569;
            validate_non_negative_index("sizesPred_alpha", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred_alpha", "nGroups", nGroups);
            std::vector<std::vector<double> > sizesPred_alpha(maxNsizesObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(sizesPred_alpha, DUMMY_VAR__);
            stan::math::fill(sizesPred_alpha, DUMMY_VAR__);
            stan::math::assign(sizesPred_alpha,rep_array(0.0, maxNsizesObs, nGroups));
            current_statement_begin__ = 570;
            validate_non_negative_index("sizesPred_beta", "maxNsizesObs", maxNsizesObs);
            validate_non_negative_index("sizesPred_beta", "nGroups", nGroups);
            std::vector<std::vector<double> > sizesPred_beta(maxNsizesObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(sizesPred_beta, DUMMY_VAR__);
            stan::math::fill(sizesPred_beta, DUMMY_VAR__);
            stan::math::assign(sizesPred_beta,rep_array(0.0, maxNsizesObs, nGroups));
            current_statement_begin__ = 571;
            validate_non_negative_index("propsPred_eta", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred_eta", "nGroups", nGroups);
            std::vector<std::vector<double> > propsPred_eta(maxNpropsObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(propsPred_eta, DUMMY_VAR__);
            stan::math::fill(propsPred_eta, DUMMY_VAR__);
            stan::math::assign(propsPred_eta,rep_array(0.0, maxNpropsObs, nGroups));
            current_statement_begin__ = 572;
            validate_non_negative_index("propsPred_alpha", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred_alpha", "nGroups", nGroups);
            std::vector<std::vector<double> > propsPred_alpha(maxNpropsObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(propsPred_alpha, DUMMY_VAR__);
            stan::math::fill(propsPred_alpha, DUMMY_VAR__);
            stan::math::assign(propsPred_alpha,rep_array(0.0, maxNpropsObs, nGroups));
            current_statement_begin__ = 573;
            validate_non_negative_index("propsPred_beta", "maxNpropsObs", maxNpropsObs);
            validate_non_negative_index("propsPred_beta", "nGroups", nGroups);
            std::vector<std::vector<double> > propsPred_beta(maxNpropsObs, std::vector<double>(nGroups, double(0)));
            stan::math::initialize(propsPred_beta, DUMMY_VAR__);
            stan::math::fill(propsPred_beta, DUMMY_VAR__);
            stan::math::assign(propsPred_beta,rep_array(0.0, maxNpropsObs, nGroups));
            current_statement_begin__ = 579;
            validate_non_negative_index("transitions", "nComps", nComps);
            validate_non_negative_index("transitions", "nComps", nComps);
            validate_non_negative_index("transitions", "maxNuniqueDts", maxNuniqueDts);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > transitions(maxNuniqueDts, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nComps, nComps));
            stan::math::initialize(transitions, DUMMY_VAR__);
            stan::math::fill(transitions, DUMMY_VAR__);
            current_statement_begin__ = 580;
            validate_non_negative_index("transitionsDecay", "nComps", nComps);
            validate_non_negative_index("transitionsDecay", "nComps", nComps);
            validate_non_negative_index("transitionsDecay", "maxNuniqueDts", maxNuniqueDts);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > transitionsDecay(maxNuniqueDts, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nComps, nComps));
            stan::math::initialize(transitionsDecay, DUMMY_VAR__);
            stan::math::fill(transitionsDecay, DUMMY_VAR__);
            current_statement_begin__ = 585;
            validate_non_negative_index("transfer", "nComps", nComps);
            validate_non_negative_index("transfer", "nComps", nComps);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> transfer(nComps, nComps);
            stan::math::initialize(transfer, DUMMY_VAR__);
            stan::math::fill(transfer, DUMMY_VAR__);
            current_statement_begin__ = 586;
            validate_non_negative_index("transferDecay", "nComps", nComps);
            validate_non_negative_index("transferDecay", "nComps", nComps);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> transferDecay(nComps, nComps);
            stan::math::initialize(transferDecay, DUMMY_VAR__);
            stan::math::fill(transferDecay, DUMMY_VAR__);
            current_statement_begin__ = 587;
            validate_non_negative_index("transition_tmp", "nComps", nComps);
            validate_non_negative_index("transition_tmp", "nComps", nComps);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> transition_tmp(nComps, nComps);
            stan::math::initialize(transition_tmp, DUMMY_VAR__);
            stan::math::fill(transition_tmp, DUMMY_VAR__);
            current_statement_begin__ = 588;
            validate_non_negative_index("transitionDecay_tmp", "nComps", nComps);
            validate_non_negative_index("transitionDecay_tmp", "nComps", nComps);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> transitionDecay_tmp(nComps, nComps);
            stan::math::initialize(transitionDecay_tmp, DUMMY_VAR__);
            stan::math::fill(transitionDecay_tmp, DUMMY_VAR__);
            current_statement_begin__ = 592;
            validate_non_negative_index("intervals_init_states_marked", "nComps", nComps);
            validate_non_negative_index("intervals_init_states_marked", "maxNtimeIntervals", maxNtimeIntervals);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > intervals_init_states_marked(maxNtimeIntervals, Eigen::Matrix<double, Eigen::Dynamic, 1>(nComps));
            stan::math::initialize(intervals_init_states_marked, DUMMY_VAR__);
            stan::math::fill(intervals_init_states_marked, DUMMY_VAR__);
            current_statement_begin__ = 593;
            validate_non_negative_index("intervals_init_states_unmarked", "nComps", nComps);
            validate_non_negative_index("intervals_init_states_unmarked", "maxNtimeIntervals", maxNtimeIntervals);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > intervals_init_states_unmarked(maxNtimeIntervals, Eigen::Matrix<double, Eigen::Dynamic, 1>(nComps));
            stan::math::initialize(intervals_init_states_unmarked, DUMMY_VAR__);
            stan::math::fill(intervals_init_states_unmarked, DUMMY_VAR__);
            // do transformed parameters statements
            {
            current_statement_begin__ = 599;
            int pulseIndex(0);
            (void) pulseIndex;  // dummy to suppress unused var warning
            stan::math::fill(pulseIndex, std::numeric_limits<int>::min());
            current_statement_begin__ = 602;
            for (int i = 1; i <= nParams; ++i) {
                current_statement_begin__ = 603;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 0))) {
                    current_statement_begin__ = 604;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(constantParams, i, "constantParams", 1), 
                                "assigning variable params");
                }
                current_statement_begin__ = 606;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 1))) {
                    current_statement_begin__ = 607;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lowerParams, i, "lowerParams", 1) + ((get_base1(upperParams, i, "upperParams", 1) - get_base1(lowerParams, i, "lowerParams", 1)) * get_base1(rawUniformParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawUniformParams", 1))), 
                                "assigning variable params");
                }
                current_statement_begin__ = 609;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 2))) {
                    current_statement_begin__ = 610;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(hcauchyScaleParams, i, "hcauchyScaleParams", 1) * get_base1(rawHcauchyParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawHcauchyParams", 1)), 
                                "assigning variable params");
                }
                current_statement_begin__ = 612;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 3))) {
                    current_statement_begin__ = 613;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(betaScaleParams, i, "betaScaleParams", 1) * get_base1(rawBetaParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawBetaParams", 1)), 
                                "assigning variable params");
                }
                current_statement_begin__ = 615;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 4))) {
                    current_statement_begin__ = 616;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(rawTrNormParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawTrNormParams", 1), 
                                "assigning variable params");
                }
                current_statement_begin__ = 618;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 5))) {
                    current_statement_begin__ = 619;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(rawExponentialParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawExponentialParams", 1), 
                                "assigning variable params");
                }
                current_statement_begin__ = 621;
                if (as_bool(logical_eq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 6))) {
                    current_statement_begin__ = 622;
                    stan::model::assign(params, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(rawGammaParams, get_base1(mappingParamPriorID, i, "mappingParamPriorID", 1), "rawGammaParams", 1), 
                                "assigning variable params");
                }
            }
            current_statement_begin__ = 627;
            for (int g = 1; g <= nGroups; ++g) {
                current_statement_begin__ = 631;
                if (as_bool(logical_eq(ode_method, 1))) {
                    current_statement_begin__ = 638;
                    stan::math::assign(transfer, buildTransferMatrix(nComps, get_base1(nSteady, g, "nSteady", 1), stan::model::rvalue(steadyIndices, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "steadyIndices"), get_base1(nUpsilons, g, "nUpsilons", 1), stan::model::rvalue(upsilonMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "upsilonMapping"), get_base1(nLambdas, g, "nLambdas", 1), stan::model::rvalue(lambdaMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "lambdaMapping"), params, pstream__));
                    current_statement_begin__ = 641;
                    stan::math::assign(transferDecay, buildTransferMatrixDecay(nComps, transfer, lambda_decay, pstream__));
                }
                current_statement_begin__ = 643;
                if (as_bool(logical_eq(ode_method, 2))) {
                    current_statement_begin__ = 645;
                    for (int i = 1; i <= get_base1(nUniqueDts, g, "nUniqueDts", 1); ++i) {
                        current_statement_begin__ = 646;
                        stan::model::assign(transitions, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    buildTransitionMatrix(nComps, get_base1(nUpsilons, g, "nUpsilons", 1), stan::model::rvalue(upsilonMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "upsilonMapping"), get_base1(nLambdas, g, "nLambdas", 1), stan::model::rvalue(lambdaMapping, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "lambdaMapping"), get_base1(get_base1(unique_dts, i, "unique_dts", 1), g, "unique_dts", 2), params, pstream__), 
                                    "assigning variable transitions");
                        current_statement_begin__ = 650;
                        stan::model::assign(transitionsDecay, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    buildTransitionMatrixDecay(nComps, get_base1(transitions, i, "transitions", 1), lambda_decay, get_base1(get_base1(unique_dts, i, "unique_dts", 1), g, "unique_dts", 2), pstream__), 
                                    "assigning variable transitionsDecay");
                    }
                }
                current_statement_begin__ = 658;
                stan::math::assign(pulseIndex, 1);
                current_statement_begin__ = 662;
                stan::model::assign(unmarked, 
                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            to_vector(stan::model::rvalue(initialQuantities, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initialQuantities")), 
                            "assigning variable unmarked");
                current_statement_begin__ = 663;
                stan::model::assign(marked, 
                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            to_vector(stan::model::rvalue(initialQuantities, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initialQuantities")), 
                            "assigning variable marked");
                current_statement_begin__ = 666;
                if (as_bool(logical_gt(splitPresent, 0))) {
                    current_statement_begin__ = 667;
                    for (int j = 1; j <= nComps; ++j) {
                        current_statement_begin__ = 668;
                        if (as_bool(logical_gt(get_base1(get_base1(splitComps, j, "splitComps", 1), g, "splitComps", 2), 0))) {
                            current_statement_begin__ = 670;
                            stan::model::assign(initRefr, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(unmarked, g, "unmarked", 1), 1, "unmarked", 2), j, "unmarked", 3) * (1 - get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1))), 
                                        "assigning variable initRefr");
                            current_statement_begin__ = 671;
                            stan::model::assign(initRefr, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(marked, g, "marked", 1), 1, "marked", 2), j, "marked", 3) * (1 - get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1))), 
                                        "assigning variable initRefr");
                            current_statement_begin__ = 673;
                            stan::model::assign(unmarked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(unmarked, g, "unmarked", 1), 1, "unmarked", 2), j, "unmarked", 3) * get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1)), 
                                        "assigning variable unmarked");
                            current_statement_begin__ = 674;
                            stan::model::assign(marked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(marked, g, "marked", 1), 1, "marked", 2), j, "marked", 3) * get_base1(params, get_base1(get_base1(piMapping, j, "piMapping", 1), g, "piMapping", 2), "params", 1)), 
                                        "assigning variable marked");
                        }
                    }
                }
                current_statement_begin__ = 680;
                if (as_bool(logical_gt(get_base1(nPulseEvents, g, "nPulseEvents", 1), 0))) {
                    current_statement_begin__ = 681;
                    if (as_bool(logical_lte(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                        current_statement_begin__ = 682;
                        while (as_bool(logical_eq(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 1, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3), 1))) {
                            current_statement_begin__ = 683;
                            stan::model::assign(unmarked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "unmarked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 1, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                        "assigning variable unmarked");
                            current_statement_begin__ = 684;
                            stan::model::assign(marked, 
                                        stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "marked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 2, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                        "assigning variable marked");
                            current_statement_begin__ = 685;
                            stan::math::assign(pulseIndex, (pulseIndex + 1));
                            current_statement_begin__ = 686;
                            if (as_bool(logical_gt(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                current_statement_begin__ = 687;
                                break;
                            }
                        }
                    }
                }
                current_statement_begin__ = 694;
                if (as_bool(logical_eq(ode_method, 1))) {
                    current_statement_begin__ = 697;
                    stan::model::assign(intervals_init_states_unmarked, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(get_base1(unmarked, g, "unmarked", 1), 1, "unmarked", 2), 
                                "assigning variable intervals_init_states_unmarked");
                    current_statement_begin__ = 698;
                    stan::model::assign(intervals_init_states_marked, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(get_base1(marked, g, "marked", 1), 1, "marked", 2), 
                                "assigning variable intervals_init_states_marked");
                    current_statement_begin__ = 704;
                    if (as_bool(logical_gt(get_base1(nTimeIntervals, g, "nTimeIntervals", 1), 1))) {
                        current_statement_begin__ = 705;
                        for (int t = 2; t <= get_base1(nTimeIntervals, g, "nTimeIntervals", 1); ++t) {
                            current_statement_begin__ = 708;
                            stan::math::assign(transition_tmp, matrix_exp(multiply(get_base1(get_base1(intervalsLengths, (t - 1), "intervalsLengths", 1), g, "intervalsLengths", 2), transfer)));
                            current_statement_begin__ = 709;
                            if (as_bool(logical_eq(lambda_decay, 0))) {
                                current_statement_begin__ = 710;
                                stan::math::assign(transitionDecay_tmp, transition_tmp);
                            } else {
                                current_statement_begin__ = 712;
                                stan::math::assign(transitionDecay_tmp, matrix_exp(multiply(get_base1(get_base1(intervalsLengths, (t - 1), "intervalsLengths", 1), g, "intervalsLengths", 2), transferDecay)));
                            }
                            current_statement_begin__ = 714;
                            stan::model::assign(intervals_init_states_unmarked, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                        multiply(transition_tmp, get_base1(intervals_init_states_unmarked, (t - 1), "intervals_init_states_unmarked", 1)), 
                                        "assigning variable intervals_init_states_unmarked");
                            current_statement_begin__ = 715;
                            stan::model::assign(intervals_init_states_marked, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                        multiply(transitionDecay_tmp, get_base1(intervals_init_states_marked, (t - 1), "intervals_init_states_marked", 1)), 
                                        "assigning variable intervals_init_states_marked");
                            current_statement_begin__ = 718;
                            if (as_bool(logical_gt(get_base1(nPulseEvents, g, "nPulseEvents", 1), 0))) {
                                current_statement_begin__ = 719;
                                if (as_bool(logical_lte(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                    current_statement_begin__ = 720;
                                    while (as_bool(logical_eq(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 1, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3), t))) {
                                        current_statement_begin__ = 721;
                                        stan::model::assign(intervals_init_states_unmarked, 
                                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), 
                                                    (stan::model::rvalue(intervals_init_states_unmarked, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), "intervals_init_states_unmarked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 1, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                    "assigning variable intervals_init_states_unmarked");
                                        current_statement_begin__ = 722;
                                        stan::model::assign(intervals_init_states_marked, 
                                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), 
                                                    (stan::model::rvalue(intervals_init_states_marked, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list())), "intervals_init_states_marked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 2, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                    "assigning variable intervals_init_states_marked");
                                        current_statement_begin__ = 723;
                                        stan::math::assign(pulseIndex, (pulseIndex + 1));
                                        current_statement_begin__ = 724;
                                        if (as_bool(logical_gt(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                            current_statement_begin__ = 725;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    current_statement_begin__ = 734;
                    for (int k = 1; k <= get_base1(nObsTimes, g, "nObsTimes", 1); ++k) {
                        current_statement_begin__ = 735;
                        stan::math::assign(transition_tmp, matrix_exp(multiply(get_base1(get_base1(elapsedTimeSinceEvent, g, "elapsedTimeSinceEvent", 1), k, "elapsedTimeSinceEvent", 2), transfer)));
                        current_statement_begin__ = 736;
                        if (as_bool(logical_eq(lambda_decay, 0))) {
                            current_statement_begin__ = 737;
                            stan::math::assign(transitionDecay_tmp, transition_tmp);
                        } else {
                            current_statement_begin__ = 739;
                            stan::math::assign(transitionDecay_tmp, matrix_exp(multiply(get_base1(get_base1(elapsedTimeSinceEvent, g, "elapsedTimeSinceEvent", 1), k, "elapsedTimeSinceEvent", 2), transferDecay)));
                        }
                        current_statement_begin__ = 741;
                        stan::model::assign(unmarked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    multiply(transition_tmp, get_base1(intervals_init_states_unmarked, get_base1(get_base1(obsIntervalsIndices, g, "obsIntervalsIndices", 1), k, "obsIntervalsIndices", 2), "intervals_init_states_unmarked", 1)), 
                                    "assigning variable unmarked");
                        current_statement_begin__ = 742;
                        stan::model::assign(marked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    multiply(transitionDecay_tmp, get_base1(intervals_init_states_marked, get_base1(get_base1(obsIntervalsIndices, g, "obsIntervalsIndices", 1), k, "obsIntervalsIndices", 2), "intervals_init_states_marked", 1)), 
                                    "assigning variable marked");
                    }
                }
                current_statement_begin__ = 748;
                if (as_bool(logical_eq(ode_method, 2))) {
                    current_statement_begin__ = 751;
                    for (int t = 1; t <= get_base1(nTimesteps, g, "nTimesteps", 1); ++t) {
                        current_statement_begin__ = 754;
                        stan::model::assign(unmarked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    multiply(get_base1(transitions, get_base1(get_base1(timesteps, t, "timesteps", 1), g, "timesteps", 2), "transitions", 1), get_base1(get_base1(unmarked, g, "unmarked", 1), t, "unmarked", 2)), 
                                    "assigning variable unmarked");
                        current_statement_begin__ = 755;
                        stan::model::assign(marked, 
                                    stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    multiply(get_base1(transitionsDecay, get_base1(get_base1(timesteps, t, "timesteps", 1), g, "timesteps", 2), "transitionsDecay", 1), get_base1(get_base1(marked, g, "marked", 1), t, "marked", 2)), 
                                    "assigning variable marked");
                        current_statement_begin__ = 758;
                        if (as_bool(logical_gt(get_base1(nSteady, g, "nSteady", 1), 0))) {
                            current_statement_begin__ = 759;
                            for (int k = 1; k <= get_base1(nSteady, g, "nSteady", 1); ++k) {
                                current_statement_begin__ = 760;
                                stan::model::assign(unmarked, 
                                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2)), stan::model::nil_index_list()))), 
                                            get_base1(get_base1(get_base1(unmarked, g, "unmarked", 1), t, "unmarked", 2), get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2), "unmarked", 3), 
                                            "assigning variable unmarked");
                                current_statement_begin__ = 761;
                                stan::model::assign(marked, 
                                            stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2)), stan::model::nil_index_list()))), 
                                            get_base1(get_base1(get_base1(marked, g, "marked", 1), t, "marked", 2), get_base1(get_base1(steadyIndices, k, "steadyIndices", 1), g, "steadyIndices", 2), "marked", 3), 
                                            "assigning variable marked");
                            }
                        }
                        current_statement_begin__ = 766;
                        if (as_bool(logical_gt(get_base1(nPulseEvents, g, "nPulseEvents", 1), 0))) {
                            current_statement_begin__ = 767;
                            if (as_bool(logical_lte(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                current_statement_begin__ = 768;
                                while (as_bool(logical_eq(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 1, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3), (t + 1)))) {
                                    current_statement_begin__ = 769;
                                    stan::model::assign(unmarked, 
                                                stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                                (stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "unmarked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 1, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                "assigning variable unmarked");
                                    current_statement_begin__ = 770;
                                    stan::model::assign(marked, 
                                                stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), 
                                                (stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(get_base1(pulseEventsIndices, pulseIndex, "pulseEventsIndices", 1), 2, "pulseEventsIndices", 2), g, "pulseEventsIndices", 3)), stan::model::nil_index_list()))), "marked") + get_base1(get_base1(get_base1(pulseEventsQuantities, pulseIndex, "pulseEventsQuantities", 1), 2, "pulseEventsQuantities", 2), g, "pulseEventsQuantities", 3)), 
                                                "assigning variable marked");
                                    current_statement_begin__ = 771;
                                    stan::math::assign(pulseIndex, (pulseIndex + 1));
                                    current_statement_begin__ = 772;
                                    if (as_bool(logical_gt(pulseIndex, get_base1(nPulseEvents, g, "nPulseEvents", 1)))) {
                                        current_statement_begin__ = 773;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                current_statement_begin__ = 785;
                stan::model::assign(sizesPred, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                            buildSizePredictions(get_base1(nSizesObs, g, "nSizesObs", 1), g, maxNsizesObs, stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "unmarked"), stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "marked"), stan::model::rvalue(sizesObsIndices, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "sizesObsIndices"), splitPresent, stan::model::rvalue(splitComps, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "splitComps"), stan::model::rvalue(initRefr, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initRefr"), pstream__), 
                            "assigning variable sizesPred");
                current_statement_begin__ = 790;
                stan::model::assign(propsPred, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                            buildPropPredictions(get_base1(nPropsObs, g, "nPropsObs", 1), g, maxNpropsObs, stan::model::rvalue(unmarked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "unmarked"), stan::model::rvalue(marked, stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "marked"), stan::model::rvalue(propsObsIndices, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "propsObsIndices"), splitPresent, stan::model::rvalue(splitComps, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "splitComps"), stan::model::rvalue(initRefr, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "initRefr"), pstream__), 
                            "assigning variable propsPred");
                current_statement_begin__ = 797;
                for (int k = 1; k <= get_base1(nSizesObs, g, "nSizesObs", 1); ++k) {
                    current_statement_begin__ = 798;
                    stan::model::assign(sizesPred_zeta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                get_base1(params, get_base1(get_base1(get_base1(sizesObsIndices, k, "sizesObsIndices", 1), 3, "sizesObsIndices", 2), g, "sizesObsIndices", 3), "params", 1), 
                                "assigning variable sizesPred_zeta");
                    current_statement_begin__ = 799;
                    if (as_bool(logical_eq(sizeFamily, 1))) {
                        current_statement_begin__ = 801;
                        stan::model::assign(sizesPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(sizesPred, k, "sizesPred", 1), g, "sizesPred", 2), 
                                    "assigning variable sizesPred_alpha");
                        current_statement_begin__ = 802;
                        stan::model::assign(sizesPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(sizesPred_zeta, k, "sizesPred_zeta", 1), g, "sizesPred_zeta", 2) * get_base1(get_base1(sizesPred, k, "sizesPred", 1), g, "sizesPred", 2)), 
                                    "assigning variable sizesPred_beta");
                    }
                    current_statement_begin__ = 804;
                    if (as_bool(logical_eq(sizeFamily, 2))) {
                        current_statement_begin__ = 806;
                        stan::model::assign(sizesPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(sizesPred, k, "sizesPred", 1), g, "sizesPred", 2), 
                                    "assigning variable sizesPred_alpha");
                        current_statement_begin__ = 807;
                        stan::model::assign(sizesPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(sizesPred_zeta, k, "sizesPred_zeta", 1), g, "sizesPred_zeta", 2), 
                                    "assigning variable sizesPred_beta");
                    }
                }
                current_statement_begin__ = 810;
                for (int k = 1; k <= get_base1(nPropsObs, g, "nPropsObs", 1); ++k) {
                    current_statement_begin__ = 811;
                    stan::model::assign(propsPred_eta, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                get_base1(params, get_base1(get_base1(get_base1(propsObsIndices, k, "propsObsIndices", 1), 3, "propsObsIndices", 2), g, "propsObsIndices", 3), "params", 1), 
                                "assigning variable propsPred_eta");
                    current_statement_begin__ = 812;
                    if (as_bool(logical_eq(propFamily, 1))) {
                        current_statement_begin__ = 814;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    pow(get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2), -(2)), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 815;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred_alpha, k, "propsPred_alpha", 1), g, "propsPred_alpha", 2) / get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2)), 
                                    "assigning variable propsPred_beta");
                    }
                    current_statement_begin__ = 817;
                    if (as_bool(logical_eq(propFamily, 2))) {
                        current_statement_begin__ = 819;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 820;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2) * get_base1(get_base1(propsPred_alpha, k, "propsPred_alpha", 1), g, "propsPred_alpha", 2)), 
                                    "assigning variable propsPred_beta");
                    }
                    current_statement_begin__ = 822;
                    if (as_bool(logical_eq(propFamily, 3))) {
                        current_statement_begin__ = 824;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 825;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2), 
                                    "assigning variable propsPred_beta");
                    }
                    current_statement_begin__ = 827;
                    if (as_bool(logical_eq(propFamily, 4))) {
                        current_statement_begin__ = 829;
                        stan::model::assign(propsPred_alpha, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2) * get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2)), 
                                    "assigning variable propsPred_alpha");
                        current_statement_begin__ = 830;
                        stan::model::assign(propsPred_beta, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(propsPred_eta, k, "propsPred_eta", 1), g, "propsPred_eta", 2) * (1 - get_base1(get_base1(propsPred, k, "propsPred", 1), g, "propsPred", 2))), 
                                    "assigning variable propsPred_beta");
                    }
                }
            }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 553;
            size_t params_i_0_max__ = nParams;
            for (size_t i_0__ = 0; i_0__ < params_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "params[i_0__]", params[i_0__], 0);
            }
            current_statement_begin__ = 556;
            size_t initRefr_i_0_max__ = nComps;
            size_t initRefr_i_1_max__ = 2;
            size_t initRefr_i_2_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < initRefr_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < initRefr_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < initRefr_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "initRefr[i_0__][i_1__][i_2__]", initRefr[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 564;
            size_t sizesPred_i_0_max__ = maxNsizesObs;
            size_t sizesPred_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred[i_0__][i_1__]", sizesPred[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 565;
            size_t propsPred_i_0_max__ = maxNpropsObs;
            size_t propsPred_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred[i_0__][i_1__]", propsPred[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 568;
            size_t sizesPred_zeta_i_0_max__ = maxNsizesObs;
            size_t sizesPred_zeta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_zeta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_zeta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred_zeta[i_0__][i_1__]", sizesPred_zeta[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 569;
            size_t sizesPred_alpha_i_0_max__ = maxNsizesObs;
            size_t sizesPred_alpha_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_alpha_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_alpha_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred_alpha[i_0__][i_1__]", sizesPred_alpha[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 570;
            size_t sizesPred_beta_i_0_max__ = maxNsizesObs;
            size_t sizesPred_beta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < sizesPred_beta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sizesPred_beta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sizesPred_beta[i_0__][i_1__]", sizesPred_beta[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 571;
            size_t propsPred_eta_i_0_max__ = maxNpropsObs;
            size_t propsPred_eta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_eta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_eta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred_eta[i_0__][i_1__]", propsPred_eta[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 572;
            size_t propsPred_alpha_i_0_max__ = maxNpropsObs;
            size_t propsPred_alpha_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_alpha_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_alpha_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred_alpha[i_0__][i_1__]", propsPred_alpha[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 573;
            size_t propsPred_beta_i_0_max__ = maxNpropsObs;
            size_t propsPred_beta_i_1_max__ = nGroups;
            for (size_t i_0__ = 0; i_0__ < propsPred_beta_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < propsPred_beta_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "propsPred_beta[i_0__][i_1__]", propsPred_beta[i_0__][i_1__], 0);
                }
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t params_k_0_max__ = nParams;
                for (size_t k_0__ = 0; k_0__ < params_k_0_max__; ++k_0__) {
                    vars__.push_back(params[k_0__]);
                }
                size_t initRefr_k_0_max__ = nComps;
                size_t initRefr_k_1_max__ = 2;
                size_t initRefr_k_2_max__ = nGroups;
                for (size_t k_2__ = 0; k_2__ < initRefr_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < initRefr_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < initRefr_k_0_max__; ++k_0__) {
                            vars__.push_back(initRefr[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t unmarked_j_1_max__ = nComps;
                size_t unmarked_k_0_max__ = nGroups;
                size_t unmarked_k_1_max__ = n_quantity_records;
                for (size_t j_1__ = 0; j_1__ < unmarked_j_1_max__; ++j_1__) {
                    for (size_t k_1__ = 0; k_1__ < unmarked_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < unmarked_k_0_max__; ++k_0__) {
                            vars__.push_back(unmarked[k_0__][k_1__](j_1__));
                        }
                    }
                }
                size_t marked_j_1_max__ = nComps;
                size_t marked_k_0_max__ = nGroups;
                size_t marked_k_1_max__ = n_quantity_records;
                for (size_t j_1__ = 0; j_1__ < marked_j_1_max__; ++j_1__) {
                    for (size_t k_1__ = 0; k_1__ < marked_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < marked_k_0_max__; ++k_0__) {
                            vars__.push_back(marked[k_0__][k_1__](j_1__));
                        }
                    }
                }
                size_t sizesPred_k_0_max__ = maxNsizesObs;
                size_t sizesPred_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < sizesPred_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < sizesPred_k_0_max__; ++k_0__) {
                        vars__.push_back(sizesPred[k_0__][k_1__]);
                    }
                }
                size_t propsPred_k_0_max__ = maxNpropsObs;
                size_t propsPred_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < propsPred_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < propsPred_k_0_max__; ++k_0__) {
                        vars__.push_back(propsPred[k_0__][k_1__]);
                    }
                }
                size_t sizesPred_zeta_k_0_max__ = maxNsizesObs;
                size_t sizesPred_zeta_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < sizesPred_zeta_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < sizesPred_zeta_k_0_max__; ++k_0__) {
                        vars__.push_back(sizesPred_zeta[k_0__][k_1__]);
                    }
                }
                size_t sizesPred_alpha_k_0_max__ = maxNsizesObs;
                size_t sizesPred_alpha_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < sizesPred_alpha_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < sizesPred_alpha_k_0_max__; ++k_0__) {
                        vars__.push_back(sizesPred_alpha[k_0__][k_1__]);
                    }
                }
                size_t sizesPred_beta_k_0_max__ = maxNsizesObs;
                size_t sizesPred_beta_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < sizesPred_beta_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < sizesPred_beta_k_0_max__; ++k_0__) {
                        vars__.push_back(sizesPred_beta[k_0__][k_1__]);
                    }
                }
                size_t propsPred_eta_k_0_max__ = maxNpropsObs;
                size_t propsPred_eta_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < propsPred_eta_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < propsPred_eta_k_0_max__; ++k_0__) {
                        vars__.push_back(propsPred_eta[k_0__][k_1__]);
                    }
                }
                size_t propsPred_alpha_k_0_max__ = maxNpropsObs;
                size_t propsPred_alpha_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < propsPred_alpha_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < propsPred_alpha_k_0_max__; ++k_0__) {
                        vars__.push_back(propsPred_alpha[k_0__][k_1__]);
                    }
                }
                size_t propsPred_beta_k_0_max__ = maxNpropsObs;
                size_t propsPred_beta_k_1_max__ = nGroups;
                for (size_t k_1__ = 0; k_1__ < propsPred_beta_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < propsPred_beta_k_0_max__; ++k_0__) {
                        vars__.push_back(propsPred_beta[k_0__][k_1__]);
                    }
                }
                size_t transitions_j_2_max__ = nComps;
                size_t transitions_j_1_max__ = nComps;
                size_t transitions_k_0_max__ = maxNuniqueDts;
                for (size_t j_2__ = 0; j_2__ < transitions_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transitions_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < transitions_k_0_max__; ++k_0__) {
                            vars__.push_back(transitions[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t transitionsDecay_j_2_max__ = nComps;
                size_t transitionsDecay_j_1_max__ = nComps;
                size_t transitionsDecay_k_0_max__ = maxNuniqueDts;
                for (size_t j_2__ = 0; j_2__ < transitionsDecay_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transitionsDecay_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < transitionsDecay_k_0_max__; ++k_0__) {
                            vars__.push_back(transitionsDecay[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t transfer_j_2_max__ = nComps;
                size_t transfer_j_1_max__ = nComps;
                for (size_t j_2__ = 0; j_2__ < transfer_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transfer_j_1_max__; ++j_1__) {
                        vars__.push_back(transfer(j_1__, j_2__));
                    }
                }
                size_t transferDecay_j_2_max__ = nComps;
                size_t transferDecay_j_1_max__ = nComps;
                for (size_t j_2__ = 0; j_2__ < transferDecay_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transferDecay_j_1_max__; ++j_1__) {
                        vars__.push_back(transferDecay(j_1__, j_2__));
                    }
                }
                size_t transition_tmp_j_2_max__ = nComps;
                size_t transition_tmp_j_1_max__ = nComps;
                for (size_t j_2__ = 0; j_2__ < transition_tmp_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transition_tmp_j_1_max__; ++j_1__) {
                        vars__.push_back(transition_tmp(j_1__, j_2__));
                    }
                }
                size_t transitionDecay_tmp_j_2_max__ = nComps;
                size_t transitionDecay_tmp_j_1_max__ = nComps;
                for (size_t j_2__ = 0; j_2__ < transitionDecay_tmp_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transitionDecay_tmp_j_1_max__; ++j_1__) {
                        vars__.push_back(transitionDecay_tmp(j_1__, j_2__));
                    }
                }
                size_t intervals_init_states_marked_j_1_max__ = nComps;
                size_t intervals_init_states_marked_k_0_max__ = maxNtimeIntervals;
                for (size_t j_1__ = 0; j_1__ < intervals_init_states_marked_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < intervals_init_states_marked_k_0_max__; ++k_0__) {
                        vars__.push_back(intervals_init_states_marked[k_0__](j_1__));
                    }
                }
                size_t intervals_init_states_unmarked_j_1_max__ = nComps;
                size_t intervals_init_states_unmarked_k_0_max__ = maxNtimeIntervals;
                for (size_t j_1__ = 0; j_1__ < intervals_init_states_unmarked_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < intervals_init_states_unmarked_k_0_max__; ++k_0__) {
                        vars__.push_back(intervals_init_states_unmarked[k_0__](j_1__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 913;
            validate_non_negative_index("nonConstantParams", "nNonConstantPriors", nNonConstantPriors);
            Eigen::Matrix<double, Eigen::Dynamic, 1> nonConstantParams(nNonConstantPriors);
            stan::math::initialize(nonConstantParams, DUMMY_VAR__);
            stan::math::fill(nonConstantParams, DUMMY_VAR__);
            current_statement_begin__ = 914;
            int paramIndex;
            (void) paramIndex;  // dummy to suppress unused var warning
            stan::math::fill(paramIndex, std::numeric_limits<int>::min());
            current_statement_begin__ = 915;
            validate_non_negative_index("log_lik", "nTotal", nTotal);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(nTotal);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 916;
            int llIndexShift;
            (void) llIndexShift;  // dummy to suppress unused var warning
            stan::math::fill(llIndexShift, std::numeric_limits<int>::min());
            // generated quantities statements
            current_statement_begin__ = 917;
            stan::math::assign(llIndexShift, 0);
            current_statement_begin__ = 920;
            stan::math::assign(paramIndex, 1);
            current_statement_begin__ = 921;
            for (int i = 1; i <= nParams; ++i) {
                current_statement_begin__ = 922;
                if (as_bool(logical_neq(get_base1(mappingParamPriorType, i, "mappingParamPriorType", 1), 0))) {
                    current_statement_begin__ = 924;
                    stan::model::assign(nonConstantParams, 
                                stan::model::cons_list(stan::model::index_uni(paramIndex), stan::model::nil_index_list()), 
                                get_base1(params, i, "params", 1), 
                                "assigning variable nonConstantParams");
                    current_statement_begin__ = 925;
                    stan::math::assign(paramIndex, (paramIndex + 1));
                }
            }
            current_statement_begin__ = 930;
            for (int g = 1; g <= nGroups; ++g) {
                current_statement_begin__ = 931;
                for (int o = 1; o <= get_base1(nSizesObs, g, "nSizesObs", 1); ++o) {
                    current_statement_begin__ = 932;
                    if (as_bool(logical_eq(sizeFamily, 1))) {
                        current_statement_begin__ = 933;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni((o + llIndexShift)), stan::model::nil_index_list()), 
                                    normal_log(get_base1(get_base1(sizesObs, o, "sizesObs", 1), g, "sizesObs", 2), get_base1(get_base1(sizesPred_alpha, o, "sizesPred_alpha", 1), g, "sizesPred_alpha", 2), get_base1(get_base1(sizesPred_beta, o, "sizesPred_beta", 1), g, "sizesPred_beta", 2)), 
                                    "assigning variable log_lik");
                    }
                    current_statement_begin__ = 935;
                    if (as_bool(logical_eq(sizeFamily, 2))) {
                        current_statement_begin__ = 936;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni((o + llIndexShift)), stan::model::nil_index_list()), 
                                    normal_log(get_base1(get_base1(sizesObs, o, "sizesObs", 1), g, "sizesObs", 2), get_base1(get_base1(sizesPred_alpha, o, "sizesPred_alpha", 1), g, "sizesPred_alpha", 2), get_base1(get_base1(sizesPred_beta, o, "sizesPred_beta", 1), g, "sizesPred_beta", 2)), 
                                    "assigning variable log_lik");
                    }
                }
                current_statement_begin__ = 939;
                stan::math::assign(llIndexShift, (llIndexShift + get_base1(nSizesObs, g, "nSizesObs", 1)));
            }
            current_statement_begin__ = 943;
            for (int g = 1; g <= nGroups; ++g) {
                current_statement_begin__ = 944;
                for (int o = 1; o <= get_base1(nPropsObs, g, "nPropsObs", 1); ++o) {
                    current_statement_begin__ = 945;
                    if (as_bool(logical_eq(propFamily, 1))) {
                        current_statement_begin__ = 946;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni((o + llIndexShift)), stan::model::nil_index_list()), 
                                    gamma_log(get_base1(get_base1(propsObs, o, "propsObs", 1), g, "propsObs", 2), get_base1(get_base1(propsPred_alpha, o, "propsPred_alpha", 1), g, "propsPred_alpha", 2), get_base1(get_base1(propsPred_beta, o, "propsPred_beta", 1), g, "propsPred_beta", 2)), 
                                    "assigning variable log_lik");
                    }
                    current_statement_begin__ = 948;
                    if (as_bool(logical_eq(propFamily, 2))) {
                        current_statement_begin__ = 949;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni((o + llIndexShift)), stan::model::nil_index_list()), 
                                    normal_log(get_base1(get_base1(propsObs, o, "propsObs", 1), g, "propsObs", 2), get_base1(get_base1(propsPred_alpha, o, "propsPred_alpha", 1), g, "propsPred_alpha", 2), get_base1(get_base1(propsPred_beta, o, "propsPred_beta", 1), g, "propsPred_beta", 2)), 
                                    "assigning variable log_lik");
                    }
                    current_statement_begin__ = 951;
                    if (as_bool(logical_eq(propFamily, 3))) {
                        current_statement_begin__ = 952;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni((o + llIndexShift)), stan::model::nil_index_list()), 
                                    normal_log(get_base1(get_base1(propsObs, o, "propsObs", 1), g, "propsObs", 2), get_base1(get_base1(propsPred_alpha, o, "propsPred_alpha", 1), g, "propsPred_alpha", 2), get_base1(get_base1(propsPred_beta, o, "propsPred_beta", 1), g, "propsPred_beta", 2)), 
                                    "assigning variable log_lik");
                    }
                    current_statement_begin__ = 954;
                    if (as_bool(logical_eq(propFamily, 4))) {
                        current_statement_begin__ = 955;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni((o + llIndexShift)), stan::model::nil_index_list()), 
                                    beta_log(get_base1(get_base1(propsObs, o, "propsObs", 1), g, "propsObs", 2), get_base1(get_base1(propsPred_alpha, o, "propsPred_alpha", 1), g, "propsPred_alpha", 2), get_base1(get_base1(propsPred_beta, o, "propsPred_beta", 1), g, "propsPred_beta", 2)), 
                                    "assigning variable log_lik");
                    }
                }
                current_statement_begin__ = 958;
                stan::math::assign(llIndexShift, (llIndexShift + get_base1(nPropsObs, g, "nPropsObs", 1)));
            }
            // validate, write generated quantities
            current_statement_begin__ = 913;
            size_t nonConstantParams_j_1_max__ = nNonConstantPriors;
            for (size_t j_1__ = 0; j_1__ < nonConstantParams_j_1_max__; ++j_1__) {
                vars__.push_back(nonConstantParams(j_1__));
            }
            current_statement_begin__ = 914;
            vars__.push_back(paramIndex);
            current_statement_begin__ = 915;
            size_t log_lik_j_1_max__ = nTotal;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 916;
            vars__.push_back(llIndexShift);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_networkModel";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t rawUniformParams_j_1_max__ = nPriorUniform_code1;
        for (size_t j_1__ = 0; j_1__ < rawUniformParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawUniformParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawHcauchyParams_j_1_max__ = nPriorHcauchy_code2;
        for (size_t j_1__ = 0; j_1__ < rawHcauchyParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawHcauchyParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawBetaParams_j_1_max__ = nPriorBeta_code3;
        for (size_t j_1__ = 0; j_1__ < rawBetaParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawBetaParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawTrNormParams_j_1_max__ = nPriorTrNormal_code4;
        for (size_t j_1__ = 0; j_1__ < rawTrNormParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawTrNormParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawExponentialParams_j_1_max__ = nPriorExponential_code5;
        for (size_t j_1__ = 0; j_1__ < rawExponentialParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawExponentialParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawGammaParams_j_1_max__ = nPriorGamma_code6;
        for (size_t j_1__ = 0; j_1__ < rawGammaParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawGammaParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t params_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < params_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "params" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t initRefr_k_0_max__ = nComps;
            size_t initRefr_k_1_max__ = 2;
            size_t initRefr_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < initRefr_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < initRefr_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < initRefr_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "initRefr" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t unmarked_j_1_max__ = nComps;
            size_t unmarked_k_0_max__ = nGroups;
            size_t unmarked_k_1_max__ = n_quantity_records;
            for (size_t j_1__ = 0; j_1__ < unmarked_j_1_max__; ++j_1__) {
                for (size_t k_1__ = 0; k_1__ < unmarked_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < unmarked_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "unmarked" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << j_1__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t marked_j_1_max__ = nComps;
            size_t marked_k_0_max__ = nGroups;
            size_t marked_k_1_max__ = n_quantity_records;
            for (size_t j_1__ = 0; j_1__ < marked_j_1_max__; ++j_1__) {
                for (size_t k_1__ = 0; k_1__ < marked_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < marked_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "marked" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << j_1__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t sizesPred_k_0_max__ = maxNsizesObs;
            size_t sizesPred_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_k_0_max__ = maxNpropsObs;
            size_t propsPred_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sizesPred_zeta_k_0_max__ = maxNsizesObs;
            size_t sizesPred_zeta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_zeta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_zeta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred_zeta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sizesPred_alpha_k_0_max__ = maxNsizesObs;
            size_t sizesPred_alpha_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_alpha_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_alpha_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred_alpha" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sizesPred_beta_k_0_max__ = maxNsizesObs;
            size_t sizesPred_beta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_beta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred_beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_eta_k_0_max__ = maxNpropsObs;
            size_t propsPred_eta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_eta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_eta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred_eta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_alpha_k_0_max__ = maxNpropsObs;
            size_t propsPred_alpha_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_alpha_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_alpha_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred_alpha" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_beta_k_0_max__ = maxNpropsObs;
            size_t propsPred_beta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_beta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred_beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transitions_j_2_max__ = nComps;
            size_t transitions_j_1_max__ = nComps;
            size_t transitions_k_0_max__ = maxNuniqueDts;
            for (size_t j_2__ = 0; j_2__ < transitions_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transitions_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < transitions_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "transitions" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t transitionsDecay_j_2_max__ = nComps;
            size_t transitionsDecay_j_1_max__ = nComps;
            size_t transitionsDecay_k_0_max__ = maxNuniqueDts;
            for (size_t j_2__ = 0; j_2__ < transitionsDecay_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transitionsDecay_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < transitionsDecay_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "transitionsDecay" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t transfer_j_2_max__ = nComps;
            size_t transfer_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transfer_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transfer_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transfer" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transferDecay_j_2_max__ = nComps;
            size_t transferDecay_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transferDecay_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transferDecay_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transferDecay" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transition_tmp_j_2_max__ = nComps;
            size_t transition_tmp_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transition_tmp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transition_tmp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transition_tmp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transitionDecay_tmp_j_2_max__ = nComps;
            size_t transitionDecay_tmp_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transitionDecay_tmp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transitionDecay_tmp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transitionDecay_tmp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t intervals_init_states_marked_j_1_max__ = nComps;
            size_t intervals_init_states_marked_k_0_max__ = maxNtimeIntervals;
            for (size_t j_1__ = 0; j_1__ < intervals_init_states_marked_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < intervals_init_states_marked_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "intervals_init_states_marked" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t intervals_init_states_unmarked_j_1_max__ = nComps;
            size_t intervals_init_states_unmarked_k_0_max__ = maxNtimeIntervals;
            for (size_t j_1__ = 0; j_1__ < intervals_init_states_unmarked_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < intervals_init_states_unmarked_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "intervals_init_states_unmarked" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t nonConstantParams_j_1_max__ = nNonConstantPriors;
        for (size_t j_1__ = 0; j_1__ < nonConstantParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nonConstantParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "paramIndex";
        param_names__.push_back(param_name_stream__.str());
        size_t log_lik_j_1_max__ = nTotal;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "llIndexShift";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t rawUniformParams_j_1_max__ = nPriorUniform_code1;
        for (size_t j_1__ = 0; j_1__ < rawUniformParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawUniformParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawHcauchyParams_j_1_max__ = nPriorHcauchy_code2;
        for (size_t j_1__ = 0; j_1__ < rawHcauchyParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawHcauchyParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawBetaParams_j_1_max__ = nPriorBeta_code3;
        for (size_t j_1__ = 0; j_1__ < rawBetaParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawBetaParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawTrNormParams_j_1_max__ = nPriorTrNormal_code4;
        for (size_t j_1__ = 0; j_1__ < rawTrNormParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawTrNormParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawExponentialParams_j_1_max__ = nPriorExponential_code5;
        for (size_t j_1__ = 0; j_1__ < rawExponentialParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawExponentialParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawGammaParams_j_1_max__ = nPriorGamma_code6;
        for (size_t j_1__ = 0; j_1__ < rawGammaParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawGammaParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t params_k_0_max__ = nParams;
            for (size_t k_0__ = 0; k_0__ < params_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "params" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t initRefr_k_0_max__ = nComps;
            size_t initRefr_k_1_max__ = 2;
            size_t initRefr_k_2_max__ = nGroups;
            for (size_t k_2__ = 0; k_2__ < initRefr_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < initRefr_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < initRefr_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "initRefr" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t unmarked_j_1_max__ = nComps;
            size_t unmarked_k_0_max__ = nGroups;
            size_t unmarked_k_1_max__ = n_quantity_records;
            for (size_t j_1__ = 0; j_1__ < unmarked_j_1_max__; ++j_1__) {
                for (size_t k_1__ = 0; k_1__ < unmarked_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < unmarked_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "unmarked" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << j_1__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t marked_j_1_max__ = nComps;
            size_t marked_k_0_max__ = nGroups;
            size_t marked_k_1_max__ = n_quantity_records;
            for (size_t j_1__ = 0; j_1__ < marked_j_1_max__; ++j_1__) {
                for (size_t k_1__ = 0; k_1__ < marked_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < marked_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "marked" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << j_1__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t sizesPred_k_0_max__ = maxNsizesObs;
            size_t sizesPred_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_k_0_max__ = maxNpropsObs;
            size_t propsPred_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sizesPred_zeta_k_0_max__ = maxNsizesObs;
            size_t sizesPred_zeta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_zeta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_zeta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred_zeta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sizesPred_alpha_k_0_max__ = maxNsizesObs;
            size_t sizesPred_alpha_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_alpha_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_alpha_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred_alpha" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sizesPred_beta_k_0_max__ = maxNsizesObs;
            size_t sizesPred_beta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < sizesPred_beta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sizesPred_beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sizesPred_beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_eta_k_0_max__ = maxNpropsObs;
            size_t propsPred_eta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_eta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_eta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred_eta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_alpha_k_0_max__ = maxNpropsObs;
            size_t propsPred_alpha_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_alpha_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_alpha_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred_alpha" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t propsPred_beta_k_0_max__ = maxNpropsObs;
            size_t propsPred_beta_k_1_max__ = nGroups;
            for (size_t k_1__ = 0; k_1__ < propsPred_beta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < propsPred_beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "propsPred_beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transitions_j_2_max__ = nComps;
            size_t transitions_j_1_max__ = nComps;
            size_t transitions_k_0_max__ = maxNuniqueDts;
            for (size_t j_2__ = 0; j_2__ < transitions_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transitions_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < transitions_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "transitions" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t transitionsDecay_j_2_max__ = nComps;
            size_t transitionsDecay_j_1_max__ = nComps;
            size_t transitionsDecay_k_0_max__ = maxNuniqueDts;
            for (size_t j_2__ = 0; j_2__ < transitionsDecay_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transitionsDecay_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < transitionsDecay_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "transitionsDecay" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t transfer_j_2_max__ = nComps;
            size_t transfer_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transfer_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transfer_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transfer" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transferDecay_j_2_max__ = nComps;
            size_t transferDecay_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transferDecay_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transferDecay_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transferDecay" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transition_tmp_j_2_max__ = nComps;
            size_t transition_tmp_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transition_tmp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transition_tmp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transition_tmp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transitionDecay_tmp_j_2_max__ = nComps;
            size_t transitionDecay_tmp_j_1_max__ = nComps;
            for (size_t j_2__ = 0; j_2__ < transitionDecay_tmp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transitionDecay_tmp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transitionDecay_tmp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t intervals_init_states_marked_j_1_max__ = nComps;
            size_t intervals_init_states_marked_k_0_max__ = maxNtimeIntervals;
            for (size_t j_1__ = 0; j_1__ < intervals_init_states_marked_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < intervals_init_states_marked_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "intervals_init_states_marked" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t intervals_init_states_unmarked_j_1_max__ = nComps;
            size_t intervals_init_states_unmarked_k_0_max__ = maxNtimeIntervals;
            for (size_t j_1__ = 0; j_1__ < intervals_init_states_unmarked_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < intervals_init_states_unmarked_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "intervals_init_states_unmarked" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t nonConstantParams_j_1_max__ = nNonConstantPriors;
        for (size_t j_1__ = 0; j_1__ < nonConstantParams_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nonConstantParams" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "paramIndex";
        param_names__.push_back(param_name_stream__.str());
        size_t log_lik_j_1_max__ = nTotal;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "llIndexShift";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_networkModel_namespace::model_networkModel stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
