% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_others.R
\name{filter_by_group}
\alias{filter_by_group}
\title{Filter a tibble based on the "group" column}
\usage{
filter_by_group(.data, ...)
}
\arguments{
\item{.data}{A tibble that has a `group` column, such as a `networkModel`
object.}

\item{...}{Conditional expressions for filtering (see the Examples).}
}
\value{
A tibble similar to the input object, but with rows filtered based
    on \code{...}.
}
\description{
This function can be used to filter any tibble (e.g. network model object)
that has a "group" column. See the Examples for more details and syntax.
}
\examples{
trini_mod
trini_mod$group
groups(trini_mod)
filter_by_group(trini_mod, stream == "LL", transect == "transect.1")
filter_by_group(trini_mod, transect == "transect.1")
\dontrun{
# The code below would raise an error because there is no "color" grouping variable.
filter_by_group(trini_mod, color == "red")
}

}
