% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_aquarium_mod.R
\docType{data}
\name{aquarium_mod}
\alias{aquarium_mod}
\title{A simple aquarium network model, ready to run}
\format{
An object of class \code{networkModel} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 1 rows and 4 columns.
}
\usage{
aquarium_mod
}
\description{
This network model is the model used in the Quick Start tutorial
vignette. It is ready to be run at once with \code{\link{run_mcmc}}.
}
\details{
The code used to built the model is given in the example section below.

The \code{\link{aquarium_run}} dataset is a corresponding MCMC run.
}
\examples{
library(tidyverse)
exp <- tibble::tribble(
  ~time.day,  ~species, ~biomass, ~prop15N,
          0,   "algae",     1.02,  0.00384,
          1,   "algae",       NA,   0.0534,
        1.5,   "algae",    0.951,       NA,
          2,   "algae",    0.889,   0.0849,
        2.5,   "algae",       NA,   0.0869,
          3,   "algae",    0.837,   0.0816,
          0, "daphnia",     1.74,  0.00464,
          1, "daphnia",       NA,  0.00493,
        1.5, "daphnia",     2.48,       NA,
          2, "daphnia",       NA,  0.00831,
        2.5, "daphnia",     2.25,       NA,
          3, "daphnia",     2.15,   0.0101,
          0,     "NH4",    0.208,     0.79,
          1,     "NH4",    0.227,       NA,
        1.5,     "NH4",       NA,    0.482,
          2,     "NH4",    0.256,    0.351,
        2.5,     "NH4",       NA,    0.295,
          3,     "NH4",     0.27,        NA
  )
inits <- exp \%>\% filter(time.day == 0)
obs <- exp \%>\% filter(time.day > 0)

aquarium_mod <- new_networkModel() \%>\%
    set_topo("NH4 -> algae -> daphnia -> NH4") \%>\%
    set_init(inits, comp = "species", size = "biomass",
             prop = "prop15N") \%>\%
    set_obs(obs, comp = "species", size = "biomass",
                  prop = "prop15N", time = "time.day")

}
\keyword{datasets}
