% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup.R
\name{extract_substring}
\alias{extract_substring}
\title{Extract a substring from text}
\usage{
extract_substring(
  string,
  pattern,
  capture_n = 1,
  capture_bracket = 0,
  missing = NA_character_
)
}
\arguments{
\item{string}{string to extract}

\item{pattern}{regular expression pattern to search for}

\item{capture_n}{within each string, which match of the \code{pattern} should be extracted? e.g. if the pattern searches for words, should the first, second or third word be captured?}

\item{capture_bracket}{for the captured match, which capture group should be extracted? i.e. which parentheses-enclosed segment of the \code{pattern}?
by default captures the whole pattern (\code{capture_bracket = 0}).}

\item{missing}{what to replace missing values with? Note that values can be missing because there are not enough captured matches or because the actual capture_bracket is empty.}
}
\value{
character vector of same length as \code{string} with the extracted substrings
}
\description{
This is a convenience function to capture substrings from textual data.
Uses \code{\link[stringr:str_match]{str_match_all}} internally but instead of returning everything, always returns only one single part of the match, depending on parameters \code{capture_n} and \code{capture_group}.
}
\seealso{
Other data extraction functions: 
\code{\link{extract_data}},
\code{\link{extract_word}()}
}
\concept{data extraction functions}
