% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coordinates.R
\docType{methods}
\name{coordinates_ternary}
\alias{coordinates_ternary}
\alias{coordinates_ternary-method}
\alias{coordinates_ternary,numeric,numeric,numeric-method}
\alias{coordinates_ternary,ANY,missing,missing-method}
\title{Ternary Coordinates}
\usage{
coordinates_ternary(x, y, z, ...)

\S4method{coordinates_ternary}{numeric,numeric,numeric}(x, y, z, missing = getOption("isopleuros.missing"))

\S4method{coordinates_ternary}{ANY,missing,missing}(x, missing = getOption("isopleuros.missing"))
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z cartesian coordinates
of a set of points.
If \code{y} and \code{z} are missing, an attempt is made to interpret \code{x} in a
suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Currently not used.}

\item{missing}{A \code{\link{logical}} scalar: should \link[=NA]{missing values} be replaced
with zeros before the computation proceeds? If \code{FALSE} (the default),
incomplete cases are removed.}
}
\value{
A \code{\link{list}}.
}
\description{
Computes ternary coordinates.
}
\examples{
## Compositional data
coda <- data.frame(
  x = c(1, 0, 0, 1/3),
  y = c(0, 1, 0, 1/3),
  z = c(0, 0, 1, 1/3)
)

## Ternary coordinates
(tern <- coordinates_ternary(coda))

## Cartesian coordinates
(cart <- coordinates_cartesian(tern))
}
\seealso{
Other coordinates: 
\code{\link{coordinates_cartesian}()}
}
\author{
N. Frerebeau
}
\concept{coordinates}
\keyword{internal}
