% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isniglm.R
\name{isniglm}
\alias{isniglm}
\title{Function for ISNI computation when the outcome follows GLMs.}
\usage{
isniglm(ymodel, gmodel, ydist = "gaussian", alldata, flag = 0)
}
\arguments{
\item{ymodel}{an object of class "formula": a symbolic description of the model to be fitted for the outcome}

\item{gmodel}{an object of class "formula": a symbolic description of the selection model to be fitted for the missingness indictor g}

\item{ydist}{a description of the error distribution to be used in the GLM for the outcome y}

\item{alldata}{the name of data frame containing all the variables in the model and all the observations including those intended to be collected but became missing.}

\item{flag}{an indicator of using log link (instead of inverse) for Gamma distribution}
}
\description{
Calculate the ISNI when the regression outcome is subject to missingness and follows generalized linear models (GLMs)
}
\examples{
   ## load data set
   data(r99)

   ymodel= y ~ gender+fac+genderbyfac

   print(summary(glm(ymodel,family=binomial(link=logit), data=r99, subset=g==0)))

   gmodel= g~gender+fac+genderbyfac
   isnicSBsurvey<-isniglm(ymodel,gmodel=gmodel,ydist='binomial', alldata=r99)
   summary(isnicSBsurvey)
}
