\name{Prostate}
\alias{Prostate}
\title{Prostate Cancer Data}
\description{
  These data come from a study that examined the correlation between the
  level of prostate specific antigen and a number of clinical measures
  in men who were about to receive a radical prostatectomy. It is data
  frame with 97 rows and 9 columns.
}
\usage{
data(Prostate)
}
\format{
  The data frame has the following components:
  \describe{
    \item{\code{lcavol}}{log(cancer volume)}
    \item{\code{lweight}}{log(prostate weight)}
    \item{\code{age}}{age}
    \item{\code{lbph}}{log(benign prostatic hyperplasia amount)}
    \item{\code{svi}}{seminal vesicle invasion}
    \item{\code{lcp}}{log(capsular penetration)}
    \item{\code{gleason}}{Gleason score}
    \item{\code{pgg45}}{percentage Gleason scores 4 or 5}
    \item{\code{lpsa}}{log(prostate specific antigen)}
  }
}
\source{
  Stamey, T.A., Kabalin, J.N., McNeal, J.E., Johnstone, I.M., Freiha,
  F., Redwine, E.A. and Yang, N. (1989)\cr
  Prostate specific antigen in the diagnosis and treatment of
  adenocarcinoma of the prostate: II. radical prostatectomy treated
  patients,
  \emph{Journal of Urology} \bold{141}(5), 1076--1083.
}
\keyword{datasets}
