% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInfo.R
\name{getAssayFileNames}
\alias{getAssayFileNames}
\title{Retrieve the Assay File Name(s) per Study from an ISA object.}
\usage{
getAssayFileNames(isaObject)
}
\arguments{
\item{isaObject}{An object of the \code{\link{ISA-class}}.}
}
\value{
A named list of character vectors containing the Assay File Name(s)
for each Study Identifier. The name of the character vector or names of the
list elements represent(s) the Study Identifier(s).

#' @examples
\subsection{Read example Atwell data set.}{

isaObject1 <- readISATab(path = file.path(system.file("extdata/Atwell",
package = "isatabr")))
}

\subsection{Extract assay file names per study.}{

getAssayFileNames(isaObject1)
}
}
\description{
Retrieve from an object of the \code{\link{ISA-class}} the Assay File Name(s)
linked to the Study Identifier(s) per Study.
}
