# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' This function estimates ability using Newton-Raphson method for a Response
#' object.
#' @noRd
#'
NULL

#' @param resp A Response object.
#' @param ip An Itempool object.
#' @noRd
NULL

#' @param resp_set A Response_set object.
#' @param ip An Itempool object.
#' @noRd
NULL

#' @param resp A Response object.
#' @param ip_list A list of Item/Testlet objects.
#' @noRd
NULL

est_ability_4pm_nr_itempool_cpp <- function(resp, ip, theta_range, criterion = 0.001, initial_estimates = NULL) {
    .Call(`_irt_est_ability_4pm_nr_itempool_cpp`, resp, ip, theta_range, criterion, initial_estimates)
}

est_ability_4pm_nr_response_cpp <- function(resp, ip, theta_range = as.numeric( c(-5, 5)), criterion = 0.001, initial_estimates = NULL) {
    .Call(`_irt_est_ability_4pm_nr_response_cpp`, resp, ip, theta_range, criterion, initial_estimates)
}

est_ability_eap_single_examinee_cpp <- function(resp, ip, theta_range, no_of_quadrature, prior_dist, prior_par) {
    .Call(`_irt_est_ability_eap_single_examinee_cpp`, resp, ip, theta_range, no_of_quadrature, prior_dist, prior_par)
}

est_ability_eap_cpp <- function(resp, ip, theta_range, no_of_quadrature, prior_dist, prior_par) {
    .Call(`_irt_est_ability_eap_cpp`, resp, ip, theta_range, no_of_quadrature, prior_dist, prior_par)
}

est_ability_eap_response_set_cpp <- function(resp_set, ip, theta_range = as.numeric( c(-5, 5)), no_of_quadrature = 61L, prior_dist = "norm", prior_par = as.numeric( c(0, 1))) {
    .Call(`_irt_est_ability_eap_response_set_cpp`, resp_set, ip, theta_range, no_of_quadrature, prior_dist, prior_par)
}

est_ability_owen_item_cpp <- function(item, resp, m0, v0) {
    .Call(`_irt_est_ability_owen_item_cpp`, item, resp, m0, v0)
}

est_ability_owen_cpp <- function(ip, resp, m0, v0) {
    .Call(`_irt_est_ability_owen_cpp`, ip, resp, m0, v0)
}

est_ability_optim_response_cpp <- function(resp, ip_list, theta_range = as.numeric( c(-5, 5)), tol = 0.0000001) {
    .Call(`_irt_est_ability_optim_response_cpp`, resp, ip_list, theta_range, tol)
}

#' Extract the remaining items in the item pool.
#'
#' @description This function returns an item pool object of the remaining items in the
#' item pool after removing all of the items that has been administered.
#' It receives, as an input, items in the item pool (ip) and the estimate
#' history (est_history) and returns an Itempool object of the remaining objects.
#' "est_history" is a list of estimation history and the last element assumed to not
#' have an $item, i.e. the last element's 'item' field is null.
#'
#' If an item from a testlet has been administered, this function will still
#' return that testlet until all of it's items has been administered. Within that
#' testlet none of the administered items will be removed to protect the integrity
#' of the testlet.
#'
#' @param cd  A \code{cat_design} object that holds the test specifications
#'   of the CAT.
#' @param est_history is a \code{List} that holds each step of the adaptive
#'   test. The first element is "1" which represents the beginning of the test.
#'   The elements are:
#'   \describe{
#'     \item{\code{"est_before"}}{The estimated ability before the item's
#'       administration.}
#'     \item{\code{"se_before"}}{The estimated standard error before the
#'       item's administration.}
#'     \item{\code{"item"}}{The item object that will be administered.}
#'     \item{\code{"testlet"}}{The testlet object that the administered item
#'       belongs to.}
#'     \item{\code{"resp"}}{The response value of the item that is
#'       administered}
#'     \item{\code{"est_after"}}{The estimated ability after the item's
#'       administration.}
#'     \item{\code{"se_after"}}{The estimated standard error after the
#'       item's administration}
#'   }
#' @param additional_args Additional arguments that are passed to functions.
#'   For example, it has a list called "set_aside_item_list". This list will
#'   contain items or testlets that has not been administered during the test
#'   but set aside and cannot be administered in this  particular
#'   administration of the CAT test.
#'
#' @noRd
#'
get_remaining_items <- function(cd, est_history, additional_args) {
    .Call(`_irt_get_remaining_items`, cd, est_history, additional_args)
}

#' Get administered items from a CAT output
#'
#' @description This function returns an item pool object of the
#'   administered items using the items in estimate history.
#'
#'   NOTE: This function either returns a regular Itempool object and if there
#'         are no administered items, it returns an empty Itempool object.
#'         Consequently, it may not be a valid Itempool object. Use this
#'         function internally because it may cause errors in R.
#'
#' @param est_history is a \code{List} that holds each step of the adaptive
#'   test. The first element is "1" which represents the beginning of the test.
#'   The elements are:
#'   \describe{
#'     \item{\code{"est_before"}}{The estimated ability before the item's
#'       administration.}
#'     \item{\code{"se_before"}}{The estimated standard error before the
#'       item's administration.}
#'     \item{\code{"item"}}{The item object that will be administered.}
#'     \item{\code{"testlet"}}{The testlet object that the administered item
#'       belongs to.}
#'     \item{\code{"resp"}}{The response value of the item that is
#'       administered}
#'     \item{\code{"est_after"}}{The estimated ability after the item's
#'       administration.}
#'     \item{\code{"se_after"}}{The estimated standard error after the
#'       item's administration}
#'   }
#'
#' @noRd
#'
get_administered_items_cpp <- function(est_history) {
    .Call(`_irt_get_administered_items_cpp`, est_history)
}

get_response_categories <- function(item) {
    .Call(`_irt_get_response_categories`, item)
}

#' Calculate the likelihood or log-likelihood of the estimate history.
#'
#' @description This function calculates the likelihood or log-likelihood of
#'   the estimate history
#'   for CAT. est_history can be complete, i.e. the "resp" value and the "item"
#'   value of the last element might be valid or not. If any of them is not
#'   valid, the last element of est_history will be ignored and likelihood
#'   will be calculated using the remaining elements.
#' @param est_history is a \code{List} that holds each step of the adaptive
#'   test. The first element is "1" which represents the beginning of the test.
#'   The elements are:
#'   \describe{
#'     \item{\code{"est_before"}}{The estimated ability before the item's
#'       administration.}
#'     \item{\code{"se_before"}}{The estimated standard error before the
#'       item's administration.}
#'     \item{\code{"item"}}{The item object that will be administered.}
#'     \item{\code{"testlet"}}{The testlet object that the administered item
#'       belongs to.}
#'     \item{\code{"resp"}}{The response value of the item that is
#'       administered}
#'     \item{\code{"est_after"}}{The estimated ability after the item's
#'       administration.}
#'     \item{\code{"se_after"}}{The estimated standard error after the
#'       item's administration}
#'   }
#' @param theta The theta estimate where the likelihood or log-likelihood
#'   needs to be calculated.
#' @param calculate_loglik If true, the log-likelihood of the estimate
#'   history will be calculated. If false, likelihood will be calculated.
#'
#' @noRd
#'
loglik_est_history <- function(est_history, theta, calculate_loglik = TRUE) {
    .Call(`_irt_loglik_est_history`, est_history, theta, calculate_loglik)
}

select_next_item_fisher_max_info_cpp <- function(cd, est_history, additional_args) {
    .Call(`_irt_select_next_item_fisher_max_info_cpp`, cd, est_history, additional_args)
}

select_next_item_fmi_cpp <- function(theta, ip, randomesqueN) {
    .Call(`_irt_select_next_item_fmi_cpp`, theta, ip, randomesqueN)
}

calculate_epv_cpp <- function(var_calc_method, current_resp, previous_resp, current_ability_est, candidate_item, administered_ip, prior_mean, prior_var) {
    .Call(`_irt_calculate_epv_cpp`, var_calc_method, current_resp, previous_resp, current_ability_est, candidate_item, administered_ip, prior_mean, prior_var)
}

select_next_item_mepv_cpp <- function(cd, est_history, additional_args) {
    .Call(`_irt_select_next_item_mepv_cpp`, cd, est_history, additional_args)
}

apply_exposure_control_cpp <- function(cd, est_history, remaining_ip_list, additional_args) {
    .Call(`_irt_apply_exposure_control_cpp`, cd, est_history, remaining_ip_list, additional_args)
}

select_next_item_cpp <- function(cd, est_history, additional_args) {
    .Call(`_irt_select_next_item_cpp`, cd, est_history, additional_args)
}

cat_sim_single_cpp <- function(true_ability, cd) {
    .Call(`_irt_cat_sim_single_cpp`, true_ability, cd)
}

cat_sim_cpp <- function(true_ability, cd, verbose = 0L) {
    .Call(`_irt_cat_sim_cpp`, true_ability, cd, verbose)
}

generate_cat_resp_cpp <- function(true_ability, cd, est_history, additional_args) {
    .Call(`_irt_generate_cat_resp_cpp`, true_ability, cd, est_history, additional_args)
}

est_ability_cat_cpp <- function(true_ability, cd, est_history, additional_args, last_estimate = FALSE) {
    .Call(`_irt_est_ability_cat_cpp`, true_ability, cd, est_history, additional_args, last_estimate)
}

#' Function determines whether to terminate CAT.
#'
#' @description This function returns either \code{true} or \code{false} where
#'   \code{true} indicates to terminate the test and \code{false} indicates to
#'   terminate the test.
#'
#'   If there is only one condition, test will end when the condition
#'   satisfied. If there are multiple conditions, all of them should be
#'   satisfied in order for test to terminate.
#'
#'
#' @param true_ability True ability of the examinee.
#' @param cd A \code{cat_design} object that holds the test specifications
#'   of the CAT.
#' @param est_history is a \code{List} that holds each step of the adaptive
#'   test. The first element is "1" which represents the beginning of the test.
#'   The elements are:
#'   \describe{
#'     \item{\code{"est_before"}}{The estimated ability before the item's
#'       administration.}
#'     \item{\code{"se_before"}}{The estimated standard error before the
#'       item's administration.}
#'     \item{\code{"item"}}{The item object that will be administered.}
#'     \item{\code{"testlet"}}{The testlet object that the administered item
#'       belongs to.}
#'     \item{\code{"resp"}}{The response value of the item that is
#'       administered}
#'     \item{\code{"est_after"}}{The estimated ability after the item's
#'       administration.}
#'     \item{\code{"se_after"}}{The estimated standard error after the
#'       item's administration}
#'   }
#'
#' @param additional_args Additional arguments
#' 
#' @noRd
#' 
terminate_cat_cpp <- function(true_ability, cd, est_history, additional_args) {
    .Call(`_irt_terminate_cat_cpp`, true_ability, cd, est_history, additional_args)
}

calculate_exposure_rates_cpp <- function(item_ids, cat_output_list) {
    .Call(`_irt_calculate_exposure_rates_cpp`, item_ids, cat_output_list)
}

calculate_overlap_rates_cpp <- function(item_ids, cat_output_list) {
    .Call(`_irt_calculate_overlap_rates_cpp`, item_ids, cat_output_list)
}

info_4pm_bare_cpp <- function(theta, item) {
    .Call(`_irt_info_4pm_bare_cpp`, theta, item)
}

info_grm_bare_cpp <- function(theta, item) {
    .Call(`_irt_info_grm_bare_cpp`, theta, item)
}

info_gpcm_bare_cpp <- function(theta, item) {
    .Call(`_irt_info_gpcm_bare_cpp`, theta, item)
}

info_item_bare_cpp <- function(theta, item, observed, resp) {
    .Call(`_irt_info_item_bare_cpp`, theta, item, observed, resp)
}

info_testlet_bare_cpp <- function(theta, testlet, observed, resp = NULL) {
    .Call(`_irt_info_testlet_bare_cpp`, theta, testlet, observed, resp)
}

info_item_cpp <- function(theta, item, observed, resp = NULL) {
    .Call(`_irt_info_item_cpp`, theta, item, observed, resp)
}

info_itempool_bare_cpp <- function(theta, ip, tif, observed, resp = NULL) {
    .Call(`_irt_info_itempool_bare_cpp`, theta, ip, tif, observed, resp)
}

info_itempool_cpp <- function(theta, ip, tif, observed, resp = NULL) {
    .Call(`_irt_info_itempool_cpp`, theta, ip, tif, observed, resp)
}

info_response_cpp <- function(theta, ip_list, tif, observed, resp) {
    .Call(`_irt_info_response_cpp`, theta, ip_list, tif, observed, resp)
}

info_response_set_cpp <- function(theta, ip, resp_set, tif = FALSE, observed = FALSE) {
    .Call(`_irt_info_response_set_cpp`, theta, ip, resp_set, tif, observed)
}

info_kl_item_bare_cpp <- function(true_theta, theta_hat, item) {
    .Call(`_irt_info_kl_item_bare_cpp`, true_theta, theta_hat, item)
}

avg_rank <- function(x) {
    .Call(`_irt_avg_rank`, x)
}

biserial_cpp <- function(score, criterion, type = "default") {
    .Call(`_irt_biserial_cpp`, score, criterion, type)
}

#' Get the length of an item pool
#'
#' @description This function gets length of an item pool from three different
#'   aspects.
#' @param ip An \code{\link{Itempool-class}} object.
#' @return This vector will return three numbers:
#' "elements": The number of items (excluding the ones in testlets) and
#'   testlets.
#' "testlets": The number of testlets
#' "items": The number of items including the ones in testlets. But this
#'   number excludes the testlets. It is basically the possible number of
#'   responses from an item pool.
#'
#' @noRd
#'
get_itempool_size <- function(ip) {
    .Call(`_irt_get_itempool_size`, ip)
}

#' Extract a string slot of an \code{\link{Itempool-class}} object.
#'
#' @description This function extracts the slot all \code{\link{Item-class}}
#'   objects within an \code{\link{Itempool-class}} object. Note that slot
#'   should hold a character class value.
#' @param ip An \code{\link{Itempool-class}} object.
#' @return A string vector that holds the values of extracted slot.
#'
#' @noRd
#'
get_ids_itempool_cpp <- function(ip) {
    .Call(`_irt_get_ids_itempool_cpp`, ip)
}

#' Extract item ids of \code{\link{Itempool-class}} object.
#'
#' @description This function extracts item id's of item pool. If the item pool
#'   has testlets, it extracts the items within the testlet object. 
#' @param ip An \code{\link{Itempool-class}} object.
#' @return A string vector that holds the values of item IDs.
#'
#' @noRd
#'
get_item_ids_itempool_cpp <- function(ip) {
    .Call(`_irt_get_item_ids_itempool_cpp`, ip)
}

#' Extract testlet ID's that correspond to item ids.
#'
#' @description This function extracts testlet id's of item pool. It has the
#'   same size as item_ids and if an item is not belong to a testlet, a 
#'   NA value will be returned for that item. If all of the items are 
#'   standalone items, than a vector of NA's will be returned . 
#' @param ip An \code{\link{Itempool-class}} object.
#' @return A string vector that holds the values of testlet IDs.
#'
#' @noRd
#'
get_testlet_ids_itempool_cpp <- function(ip) {
    .Call(`_irt_get_testlet_ids_itempool_cpp`, ip)
}

#' Extract a string slot of an \code{\link{Itempool-class}} object.
#'
#' @description This function extracts the slot all \code{\link{Item-class}}
#'   objects within an \code{\link{Itempool-class}} object. Note that slot
#'   should hold a character class value.
#' @param ip An \code{\link{Itempool-class}} object.
#' @param slotName A string value of the name of the slot.
#' @return A string vector that holds the values of extracted slot.
#'
#' @noRd
#'
get_slot_itempool_cpp <- function(ip, slotName) {
    .Call(`_irt_get_slot_itempool_cpp`, ip, slotName)
}

get_parameters_itempool_cpp <- function(ip) {
    .Call(`_irt_get_parameters_itempool_cpp`, ip)
}

subset_itempool_cpp <- function(ip, args) {
    .Call(`_irt_subset_itempool_cpp`, ip, args)
}

#'
#' This function returns a list of items within item pool. If there is are
#' testlets, the items within each testlet will be extracted and added to
#' the list.
#'
#' @param ip an "Itempool" class object
#' @noRd
flatten_itempool_cpp <- function(ip) {
    .Call(`_irt_flatten_itempool_cpp`, ip)
}

#' This function returns the maximum possible score of an item. It returns an
#' integer.
#' @param item an "Item" class object
#' @noRd
get_max_possible_score_item_cpp <- function(item) {
    .Call(`_irt_get_max_possible_score_item_cpp`, item)
}

#' This function returns the maximum possible score of each item in an item
#' pool. It returns a vector of integer values. If there are testlets,
#' the maximum scores of items within testlets will be returned.
#'
#'
#' @param ip an "Itempool" class object
#' @noRd
get_max_possible_score_itempool_cpp <- function(ip) {
    .Call(`_irt_get_max_possible_score_itempool_cpp`, ip)
}

#' @title This function checks whether an Item objects model is dichotomous or
#' polytomous; or unidimensional/multidimensional.
#'
#' @description
#' This function effectively divides models into four categories:
#' model is_dichotomous is_unidimensional                                 Call
#'   2PL           true              true   check_item_model(item, true, true)
#'  M2PL           true             false  check_item_model(item, true, false)
#'  GPCM          false              true  check_item_model(item, false, true)
#'
#' @noRd
#'
NULL

integrate <- function(x, fx) {
    .Call(`_irt_integrate`, x, fx)
}

check_item_model <- function(item, is_dichotomous = TRUE, is_unidimensional = TRUE) {
    .Call(`_irt_check_item_model`, item, is_dichotomous, is_unidimensional)
}

lz_response_cpp <- function(resp, theta, ip_list) {
    .Call(`_irt_lz_response_cpp`, resp, theta, ip_list)
}

lz_response_set_cpp <- function(resp_set, theta, ip) {
    .Call(`_irt_lz_response_set_cpp`, resp_set, theta, ip)
}

prob_4pm_bare_cpp <- function(theta, item, derivative = 0L, resp = -9) {
    .Call(`_irt_prob_4pm_bare_cpp`, theta, item, derivative, resp)
}

prob_4pm_item_cpp <- function(theta, item, derivative = 0L) {
    .Call(`_irt_prob_4pm_item_cpp`, theta, item, derivative)
}

prob_4pm_itempool_cpp <- function(theta, ip, derivative = 0L) {
    .Call(`_irt_prob_4pm_itempool_cpp`, theta, ip, derivative)
}

prob_grm_bare_cpp <- function(theta, item, derivative = 0L) {
    .Call(`_irt_prob_grm_bare_cpp`, theta, item, derivative)
}

prob_gpcm_bare_cpp <- function(theta, item, derivative = 0L, resp = -9) {
    .Call(`_irt_prob_gpcm_bare_cpp`, theta, item, derivative, resp)
}

prob_poly_bare_cpp <- function(theta, item, derivative = 0L, resp = -9, expected_value = FALSE) {
    .Call(`_irt_prob_poly_bare_cpp`, theta, item, derivative, resp, expected_value)
}

prob_mirt_bare_cpp <- function(theta, item, derivative = 0L) {
    .Call(`_irt_prob_mirt_bare_cpp`, theta, item, derivative)
}

prob_mirt_item_cpp <- function(theta, item, derivative = 0L) {
    .Call(`_irt_prob_mirt_item_cpp`, theta, item, derivative)
}

prob_mirt_itempool_cpp <- function(theta, ip, derivative = 0L) {
    .Call(`_irt_prob_mirt_itempool_cpp`, theta, ip, derivative)
}

prob_bare_item_cpp <- function(theta, item, derivative = 0L, resp = -9, expected_value = FALSE) {
    .Call(`_irt_prob_bare_item_cpp`, theta, item, derivative, resp, expected_value)
}

#' This function calculates the probability of each response option for one
#' theta value. It returns a matrix, each column represents a response
#' option and each row represents an item.
#'
#' @noRd
prob_bare_itempool_cpp <- function(theta, ip, derivative = 0L, expected_value = FALSE) {
    .Call(`_irt_prob_bare_itempool_cpp`, theta, ip, derivative, expected_value)
}

resp_lik_bare_item_cpp <- function(resp, theta, item) {
    .Call(`_irt_resp_lik_bare_item_cpp`, resp, theta, item)
}

resp_lik_item_cpp <- function(resp, theta, item) {
    .Call(`_irt_resp_lik_item_cpp`, resp, theta, item)
}

resp_lik_bare_testlet_cpp <- function(resp, theta, testlet) {
    .Call(`_irt_resp_lik_bare_testlet_cpp`, resp, theta, testlet)
}

resp_lik_testlet_cpp <- function(resp, theta, testlet) {
    .Call(`_irt_resp_lik_testlet_cpp`, resp, theta, testlet)
}

resp_lik_bare_itempool_cpp <- function(resp, theta, ip) {
    .Call(`_irt_resp_lik_bare_itempool_cpp`, resp, theta, ip)
}

resp_lik_itempool_cpp <- function(resp, theta, ip) {
    .Call(`_irt_resp_lik_itempool_cpp`, resp, theta, ip)
}

resp_lik_response_cpp <- function(theta, resp, ip) {
    .Call(`_irt_resp_lik_response_cpp`, theta, resp, ip)
}

resp_lik_response_set_cpp <- function(resp_set, theta, ip) {
    .Call(`_irt_resp_lik_response_set_cpp`, resp_set, theta, ip)
}

resp_loglik_bare_item_cpp <- function(resp, theta, item, derivative = 0L) {
    .Call(`_irt_resp_loglik_bare_item_cpp`, resp, theta, item, derivative)
}

#' Calculate the response log-likelihood of a response string.
#' @param resp Response vector.
#' @param theta Theta value.
#' @param item An \code{Item-class} object.
#' @param derivative An integer indicating which derivative to calculate:
#'    0 = No derivative
#'    1 = First derivative
#'    2 = Second derivative
#'
#' @noRd
#'
resp_loglik_item_cpp <- function(resp, theta, item, derivative = 0L) {
    .Call(`_irt_resp_loglik_item_cpp`, resp, theta, item, derivative)
}

resp_loglik_btm_integral_cpp <- function(u, mu, sigma, resp, theta, item_list) {
    .Call(`_irt_resp_loglik_btm_integral_cpp`, u, mu, sigma, resp, theta, item_list)
}

#' Calculate response log-likelihood for a testlet and a single theta (and a
#' response string)
#' @param resp Response vector.
#' @param theta Theta value.
#' @param testlet A \code{Testlet-class} object.
#' @param derivative An integer indicating which derivative to calculate:
#'    0 = No derivative
#'    1 = First derivative
#'    2 = Second derivative
#'
#' @noRd
#'
resp_loglik_bare_testlet_cpp <- function(resp, theta, testlet, derivative = 0L) {
    .Call(`_irt_resp_loglik_bare_testlet_cpp`, resp, theta, testlet, derivative)
}

resp_loglik_testlet_cpp <- function(resp, theta, testlet, derivative = 0L) {
    .Call(`_irt_resp_loglik_testlet_cpp`, resp, theta, testlet, derivative)
}

resp_loglik_bare_itempool_cpp <- function(resp, theta, ip, derivative = 0L) {
    .Call(`_irt_resp_loglik_bare_itempool_cpp`, resp, theta, ip, derivative)
}

resp_loglik_itempool_cpp <- function(resp, theta, ip, derivative = 0L) {
    .Call(`_irt_resp_loglik_itempool_cpp`, resp, theta, ip, derivative)
}

resp_loglik_response_cpp <- function(theta, resp, ip, derivative = 0L) {
    .Call(`_irt_resp_loglik_response_cpp`, theta, resp, ip, derivative)
}

resp_loglik_response_set_cpp <- function(resp_set, theta, ip, derivative = 0L) {
    .Call(`_irt_resp_loglik_response_set_cpp`, resp_set, theta, ip, derivative)
}

check_validity_response_set_cpp <- function(resp_set, ip) {
    .Call(`_irt_check_validity_response_set_cpp`, resp_set, ip)
}

get_examinee_id_response_set_cpp <- function(resp_set) {
    .Call(`_irt_get_examinee_id_response_set_cpp`, resp_set)
}

max_score_response_set_cpp <- function(resp_set, ip) {
    .Call(`_irt_max_score_response_set_cpp`, resp_set, ip)
}

#' @title Create a Response class object for a single examinee for an item pool
#'
#' @param theta A value representing theta
#' @param ip An item pool objec.
#' @param examinee_id A string representing examinee ID.
#' @param ip_size the size of the item pool.
#' @param prop_missing proportion of missing
#'
#' NOTE: if the prop_missing value is close to 1, unexpected behavior can be
#' observed.
#'
#' @noRd
#'
#' @examples
#' ip <- c(generate_testlet(item_id_preamble = "t1"),
#'         generate_ip(n = 5, model = c("2PL", "3PL", "GPCM", "PCM", "GRM")),
#'         generate_testlet(item_id_preamble = "t2"))
#' irt:::sim_resp_response_cpp(theta = 1, ip = ip, examinee_id = "abc",
#'                             prop_missing = 0.5)
NULL

#' @title Create a Response_set class object for multiple examinees for an item
#'   pool
#'
#' @param theta A vector representing thetas
#' @param ip An item pool objec.
#' @param examinee_id A vector representing examinee_id's
#' @param prop_missing proportion of missing
#'
#' NOTE: if the prop_missing value is close to 1, unexpected behavior can be
#' observed.
#'
#' @noRd
#'
#' @examples
#' ip <- c(generate_testlet(item_id_preamble = "t1"),
#'         generate_ip(n = 5, model = c("2PL", "3PL", "GPCM", "PCM", "GRM")),
#'         generate_testlet(item_id_preamble = "t2"))
#' irt:::sim_resp_response_set_cpp(theta = rnorm(3), ip = ip,
#'                                 prop_missing = 0.5)
NULL

sim_resp_4pm_bare_cpp <- function(theta, item) {
    .Call(`_irt_sim_resp_4pm_bare_cpp`, theta, item)
}

sim_resp_poly_bare_cpp <- function(theta, item) {
    .Call(`_irt_sim_resp_poly_bare_cpp`, theta, item)
}

sim_resp_bare_cpp <- function(theta, item) {
    .Call(`_irt_sim_resp_bare_cpp`, theta, item)
}

sim_resp_response_cpp <- function(theta, ip, examinee_id = "", ip_size = NA_integer_, prop_missing = 0) {
    .Call(`_irt_sim_resp_response_cpp`, theta, ip, examinee_id, ip_size, prop_missing)
}

sim_resp_response_set_cpp <- function(theta, ip, examinee_id = "", prop_missing = 0) {
    .Call(`_irt_sim_resp_response_set_cpp`, theta, ip, examinee_id, prop_missing)
}

