% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIModels.R
\name{use_linearBayes}
\alias{use_linearBayes}
\title{get the prediction from a Bayesian linear regression}
\usage{
use_linearBayes(newx = NULL, model = NULL)
}
\arguments{
\item{newx}{is a matrix of features (e.g. fingerprints and/or physical descriptors), issued from a test/validation set, for
which the properties (e.g. targeted chemical properties) are predicted.}

\item{model}{is the set of parameters defining a trained Bayesian linear regression model, issued from \code{\link{get_linearBayes}},
to be used as a predictor.}
}
\value{
the predicted properties with associated variance.
}
\description{
Get the prediction from a Bayesian linear regression. For a prediction other than from a Bayesian linear
model, see \code{\link{use_Model}}.
}
\examples{
\dontrun{linearBayes_pred <- use_linearBayes(newx = newx,
model = c(list(w0),list(V0_inv),list(a0),list(b0)))}

}
