% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ipums_collect}
\alias{ipums_collect}
\title{Collect data into R session with IPUMS attributes}
\usage{
ipums_collect(data, ddi, var_attrs = c("val_labels", "var_label", "var_desc"))
}
\arguments{
\item{data}{A dplyr \code{tbl} object (generally a \code{tbl_lazy}
object stored in a database).}

\item{ddi}{An \link{ipums_ddi} object created with \code{\link[=read_ipums_ddi]{read_ipums_ddi()}}.}

\item{var_attrs}{Variable attributes to add to the output. Defaults to
all available attributes.
See \code{\link[=set_ipums_var_attributes]{set_ipums_var_attributes()}} for more details.}
}
\value{
A local \code{\link[tibble:tbl_df-class]{tibble}} with the requested
attributes attached.
}
\description{
Convenience wrapper around dplyr's \code{\link[dplyr:compute]{collect()}} and
\code{\link[=set_ipums_var_attributes]{set_ipums_var_attributes()}}. Use this to attach variable labels when
collecting data from a database.
}
