% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipumsr-package.R
\name{selection_language}
\alias{selection_language}
\title{tidyselect selection language in ipumsr}
\description{
Slightly modified implementation of tidyselect
\link[tidyselect:language]{selection language} in ipumsr.
\subsection{Syntax}{

In general, the selection language in ipumsr operates the same as in
tidyselect.

Where applicable, variables can be selected with:
\itemize{
\item A character vector of variable names (\code{c("var1", "var2")})
\item A bare vector of variable names (\code{c(var1, var2)})
\item A selection helper from tidyselect (\code{starts_with("var")}). See below for
a list of helpers.
}
}

\subsection{Primary differences}{
\itemize{
\item tidyselect selection is generally intended for use with column variables
in data.frame-like objects. In contrast, ipumsr allows selection language
syntax in other cases as well (for instance, when selecting files
from within a .zip archive). ipumsr functions will indicate whether they
support the selection language.
\item Selection with \code{\link[tidyselect:where]{where()}} is not consistently
supported.
}
}

\subsection{Selection helpers (from tidyselect)}{
\itemize{
\item \code{var1}:\code{var10}: variables lying between \code{var1} on the left and \code{var10}
on the right.
\item \code{starts_with("a")}: names that start with \code{"a"}
\item \code{ends_with("z")}: names that end with \code{"z"}
\item \code{contains("b")}: names that contain \code{"b"}
\item \code{matches("x.y")}: names that match regular expression \code{x.y}
\item \code{num_range(x, 1:4)}: names following the pattern \verb{x1, x2, ..., x4}
\item \code{all_of(vars)}/\code{any_of(vars)}: matches names stored in the character vector
\code{vars}. \code{all_of(vars)} will error if the variables aren't present;
\code{any_of(vars)} will match just the variables that exist.
\item \code{everything()}: all variables
\item \code{last_col()}: furthest column to the right
}

Operators for combining those selections:
\itemize{
\item \code{!selection}: only variables that don't match \code{selection}
\item \code{selection1 & selection2}: only variables included in both \code{selection1}
and \code{selection2}
\item \code{selection1 | selection2}: all variables that match either \code{selection1} or
\code{selection2}
}
}
}
\examples{
cps_file <- ipums_example("cps_00157.xml")

# Load 3 variables by name
read_ipums_micro(
  cps_file,
  vars = c("YEAR", "MONTH", "PERNUM"),
  verbose = FALSE
)

# "Bare" variables are supported
read_ipums_micro(
  cps_file,
  vars = c(YEAR, MONTH, PERNUM),
  verbose = FALSE
)

# Standard tidyselect selectors are also supported
read_ipums_micro(cps_file, vars = starts_with("ASEC"), verbose = FALSE)

# Selection methods can be combined
read_ipums_micro(
  cps_file,
  vars = c(YEAR, MONTH, contains("INC")),
  verbose = FALSE
)

read_ipums_micro(
  cps_file,
  vars = starts_with("S") & ends_with("P"),
  verbose = FALSE
)

# Other selection arguments also support this syntax.
# For instance, load a particular file based on a tidyselect match:
read_nhgis(
  ipums_example("nhgis0731_csv.zip"),
  file_select = contains("nominal_state"),
  verbose = FALSE
)
}
\keyword{internal}
