% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{remove_from_extract.nhgis_extract}
\alias{remove_from_extract.nhgis_extract}
\title{Remove values from an existing NHGIS extract definition}
\usage{
\method{remove_from_extract}{nhgis_extract}(
  extract,
  datasets = NULL,
  time_series_tables = NULL,
  geographic_extents = NULL,
  shapefiles = NULL,
  ...
)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{datasets}{Dataset specifications to remove from the extract definition.
All \code{data_tables}, \code{geog_levels},
\code{years}, and \code{breakdown_values} associated with the specified
\code{datasets} will also be removed.}

\item{time_series_tables}{Names of the time series tables
to remove from the extract definition. All \code{geog_levels} and \code{years}
associated  with the specified \code{time_series_tables} will also be removed.}

\item{geographic_extents}{Geographic extents to remove from the extract
definition.}

\item{shapefiles}{Shapefiles to remove from the extract definition.}

\item{...}{Ignored}
}
\value{
A modified \code{nhgis_extract} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Remove existing values from an IPUMS NHGIS extract definition. All
fields are optional, and if omitted, will be unchanged.

This function is marked as experimental because it is typically not the best
option for maintaining reproducible extract definitions and may be retired
in the future. For reproducibility, users should strive to build extract
definitions with \code{\link[=define_extract_nhgis]{define_extract_nhgis()}}.

If you have a complicated extract definition to revise, but do not have
the original extract definition code that created it, we suggest that you
save the revised extract as a JSON file with \code{\link[=save_extract_as_json]{save_extract_as_json()}}. This
will create a stable version of the extract definition that
can be used in the future as needed.

To add new values to an IPUMS NHGIS extract definition, use
\code{\link[=add_to_extract.nhgis_extract]{add_to_extract()}}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\details{
Any extract fields that are rendered irrelevant after modifying the extract
will be automatically removed. (For instance, if all \code{time_series_tables}
are removed from an extract, \code{tst_layout} will also be
removed.) Thus, it is not necessary to explicitly remove these values.

If the supplied extract definition comes from
a previously submitted extract request, this function will reset the
definition to an unsubmitted state.
}
\examples{
extract <- define_extract_nhgis(
  datasets = ds_spec(
    "1990_STF1",
    data_tables = c("NP1", "NP2", "NP3"),
    geog_levels = "county"
  ),
  time_series_tables = list(
    tst_spec("CW3", c("state", "county")),
    tst_spec("CW5", c("state", "county"))
  )
)

# Providing names of datasets or time series tables will remove them and
# all of their associated specifications from the extract:
remove_from_extract(
  extract,
  time_series_tables = c("CW3", "CW5")
)

# To remove detailed specifications from a dataset or time series table,
# use `ds_spec()` or `tst_spec()`. The named dataset or time series table
# will be retained in the extract, but modified by removing the indicated
# specifications:
remove_from_extract(
  extract,
  datasets = ds_spec("1990_STF1", data_tables = c("NP2", "NP3"))
)

# To make multiple modifications, use a list of `ds_spec()` or `tst_spec()`
# objects:
remove_from_extract(
  extract,
  time_series_tables = list(
    tst_spec("CW3", geog_levels = "county"),
    tst_spec("CW5", geog_levels = "state")
  )
)
}
\seealso{
\code{\link[=add_to_extract.nhgis_extract]{add_to_extract()}} to add values
to an extract definition.

\code{\link[=submit_extract]{submit_extract()}} and \code{\link[=download_extract]{download_extract()}} to submit and process an
extract request.

\code{\link[=define_extract_nhgis]{define_extract_nhgis()}} to create a new extract definition.
}
\keyword{internal}
