% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddi_read.r
\name{read_ipums_ddi}
\alias{read_ipums_ddi}
\title{Read metadata about an IPUMS extract from a DDI (.xml) file}
\usage{
read_ipums_ddi(ddi_file, data_layer = NULL, lower_vars = FALSE)
}
\arguments{
\item{ddi_file}{Filepath to DDI xml file}

\item{data_layer}{If ddi_file is an extract with multiple DDIs, dplyr
\code{\link[dplyr]{select}}-style notation indicating which .xml data
layer to load.}

\item{lower_vars}{Logical indicating whether to convert variable names
to lowercase (default is FALSE, in line with IPUMS conventions)}
}
\value{
An \code{ipums_ddi} object with metadata information.
}
\description{
Reads the metadata about an IPUMS extract from a DDI file into R.
Includes information about variable and value labels, terms of
usage for the data and positions for the fixed-width file.
}
\examples{
# Example extract DDI
ddi_file <- ipums_example("cps_00006.xml")
ddi <- read_ipums_ddi(ddi_file)
}
\seealso{
Other ipums_metadata: 
\code{\link{read_ipums_codebook}()}
}
\concept{ipums_metadata}
