% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.r
\name{lbl_relabel}
\alias{lbl_relabel}
\title{Relabel labelled values}
\usage{
lbl_relabel(x, ...)
}
\arguments{
\item{x}{A \code{\link[haven]{labelled}} vector}

\item{...}{Two-sided formulas where the left hand side is a label placeholder
(created with the \code{\link{lbl}} function) or a value that already exists
in the data and the right hand side is a function that returns a logical
vector that indicates which labels should be relabeled. The right hand side
is passed to a function similar to \code{\link[rlang]{as_function}}, so
also accepts quosure-style lambda functions (that use values .val and .lbl).
See examples for more information.}
}
\value{
A haven::labelled vector
}
\description{
Converts values to a new value (that may or may not exist) based on their
label and value in a \code{\link[haven]{labelled}} vector. Ignores any value
that does not have a label.
}
\examples{
x <- haven::labelled(
  c(10, 10, 11, 20, 30, 99, 30, 10),
  c(Yes = 10, `Yes - Logically Assigned` = 11, No = 20, Maybe = 30, NIU = 99)
)

lbl_relabel(
  x,
  lbl(10, "Yes/Yes-ish") ~ .val \%in\% c(10, 11),
  lbl(90, "???") ~ .val == 99 | .lbl == "Maybe"
)

# If relabelling to labels that already exist, don't need to specify both label
# and value:
# If just bare, assumes it is a value:
lbl_relabel(x, 10 ~ .val == 11)
# Use single argument to lbl for the label
lbl_relabel(x, lbl("Yes") ~ .val == 11)
# Or can used named arguments
lbl_relabel(x, lbl(.val = 10) ~ .val == 11)

}
\seealso{
Other lbl_helpers: 
\code{\link{lbl_add}()},
\code{\link{lbl_clean}()},
\code{\link{lbl_collapse}()},
\code{\link{lbl_define}()},
\code{\link{lbl_na_if}()},
\code{\link{lbl}()},
\code{\link{zap_ipums_attributes}()}
}
\concept{lbl_helpers}
