% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{iana_assignments}
\alias{iana_assignments}
\title{IANA IPv4 Address Space Registry}
\format{A data frame with 256 rows and 5 variables}
\usage{
data(iana_assignments)
}
\description{
This dataset contains the registry of address space assignments
for IPv4 IP addresses, as set by IANA. It consists of a data.frame containing the columns:

\itemize{
  \item \code{prefix}: A block of IPv4 (CIDR notation) addresses that has been registered
  for a particular purpose (e.g. "100.64.0.0/10")
  \item \code{designation}: The entity the block is assigned to.
  \item \code{date}: the assignment date of the block, stored as YYYY-MM.
  \item \code{whois}: whois registry [\code{whois.afrinic.net}|\code{whois.apnic.net}|
        \code{whois.arin.net}|\code{whois.lacnic.net}|\code{whois.ripe.net}]
  \item \code{status}: status of the assignment [\code{ALLOCATED}|\code{LEGACY}|
        \code{RESERVED}]
}
}
\note{
Last updated 2015-05-01.
}
\references{
\itemize{
  \item The \href{http://www.iana.org/assignments/ipv4-address-space/ipv4-address-space.xhtml}{
  IANA page} on the IPv4 assignments.
  \item \href{http://tools.ietf.org/html/rfc1466}{RFC1466}.

}
}
\seealso{
\code{\link{iana_assignments_refresh}} for updating the dataset, and
\code{\link{iana_special_assignments}} for particular, special IPv4 assignments.
}
\keyword{datasets}

