% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iprior.R
\name{iprior}
\alias{iprior}
\alias{iprior.default}
\alias{iprior.formula}
\alias{iprior.ipriorKernel}
\alias{iprior.ipriorMod}
\title{Fit an I-prior regression model}
\usage{
\method{iprior}{default}(y, ..., model = list(), control = list())

\method{iprior}{formula}(formula, data = parent.frame(), model = list(),
  control = list(), ...)

\method{iprior}{ipriorKernel}(object, control = list(), ...)

\method{iprior}{ipriorMod}(object, control = list(), ...)
}
\arguments{
\item{y}{Vector of response variables.}

\item{...}{Only used for when fitting using non-formula, enter the variables
(vectors or matrices) separated by commas. No other options applicable here.}

\item{model}{List of model options. Not used for \code{ipriorKernel} or
 \code{ipriorModel} objects. Available options are:
 \describe{\item{\code{kernel}}{Vector of character strings of either
 \code{"Canonical"}, \code{"FBM"}, or \code{"Pearson"}. Defaults to
 \code{"Canonical"} for continuous variables, and \code{"Pearson"} for factor
 type objects. To specify a Hurst coefficient, use \code{"FBM,<value>"};
 otherwise the default of 0.5 is used. Alternatively, see \code{Hurst} option
 below.} \item{\code{Hurst}}{Set the value of the Hurst coefficient for all
 \code{FBM} kernels used, rather than one by one. This is a value between 0
 and 1, and defaults to 0.5.}\item{\code{order}}{Character vector of length
 equal to the number of explanatory variables used, indicating specification
 of higher order scale parameters. The syntax is \code{"a^b"}, for parameter
 \code{a} raised to the power \code{b}. For regular order terms, then just
 input "a".} \item{\code{parsm}}{Logical, defaults to \code{TRUE}. Set to
 \code{FALSE} to assign one scale parameter for all kernel matrices.}
 \item{\code{one.lam}}{Logical, defaults to \code{FALSE}. Only relevant when
 using the formula call. Should all the variable share the same scale
 parameter?}}

 These options are also available, but are only relevant when calling using
 non-formula: \describe{\item{\code{yname}}{Character vector to set the name
 of the response variable. It is set to the object name which contains the
 response variables by default.} \item{\code{xname}}{Character vector to set
 the name of the explanatory variables. This is also set to the object name
 by default.} \item{\code{interactions}}{Character vector to specify the
 interaction terms. When using formulas, this is specified automatically.
 Syntax is \code{"a:b"} to indicate variable \code{a} interacts with variable
 \code{b}.}}}

\item{control}{(optional) A list of control options for the EM algorithm and
output: \describe{\item{\code{maxit}}{The maximum number of iterations
until the EM stops. Defaults to \code{50000}.} \item{\code{stop.crit}.}{The
EM stopping criteria, which is the difference in succesive log-likelihood
values. Defaults to \code{1e-7}.} \item{\code{progress}}{Option for the
reporting of the EM while the function is running. Choose from one of
\code{"lite"} (default), \code{"full"} (log-likelihood and parameters
trace), \code{"predloglik"} (log-likelihood trace only) or \code{"none"}.
Visit the
\href{https://github.com/haziqjamil/iprior/wiki/The-predicted-log-likelihood-feature}{Wiki}
page for more information.} \item{\code{report}}{The EM reports every
\code{report} iterations. Defaults to \code{100}.}
\item{\code{silent}}{Logical, whether the EM report should be printed or
not. This is the same as setting \code{progress = "none"}.}
\item{\code{lambda, psi, sigma}}{These are options to set the initial
values of the parameters. For convenience, the user may choose to input one
of \code{psi} or \code{sigma}, but not both, since \code{psi = 1 / sigma ^
2}.} \item{\code{intercept}}{It is possible to set a fixed value for the
intercept (not recommended).}}}

\item{formula}{The formula to fit when using formula interface.}

\item{data}{Data frame containing variables when using formula interface.}

\item{object}{This is either an object of class formula (when fitting using
formula interface), \code{ipriorKernel} or \code{ipriorModel}. This is used
when not using formula or \code{"y, x"} input.}
}
\value{
An object of class \code{ipriorMod} which is a list of 24 items. The
  more important items are described below. \describe{ \item{\code{alpha,
  lambda, psi, coefficients, sigma}}{The last attained parameter values after
  running the EM algorithm. This can also be extracted via \code{coef()}}
  \item{\code{log.lik}}{The last attained log-likelihood value. This can also
  be extracted via \code{logLik()}.} \item{\code{no.iter}}{The number of
  iterations the EM algorithm ran for.} \item{\code{Hlam.mat}}{This is the
  scaled kernel matrix of dimension \code{n} by \code{n}.}
  \item{\code{VarY.inv}}{The variance-covariance matrix of the marginal
  distribution of \code{y}.} \item{\code{w.hat}}{The vector of posterior mean
  estimates of the I-prior random effects.} \item{\code{fitted.values}}{These
  are posterior estimates of \code{y}, i.e. the fitted values. This can also
  be extracted via \code{fitted()} or \code{\link{predict}()}}
  \item{\code{residuals}}{The vector of residuals. This can also be extracted
  via \code{resid()}.} }
}
\description{
A function to perform linear regression using I-priors. The I-prior model is
fitted via maximum likelihood using an EM algorithm.
}
\details{
The \code{iprior()} function is able to take formula based input and
non-formula. When not using formula, the syntax is as per the default S3
method. That is, the response variable is the vector \code{y}, and any
explanatory variables should follow this, and separated by commas.

As described \link[=kernL]{here}, the model can be loaded first into an
\code{ipriorKernel} object, and then passed to the \code{iprior()} function
to perform the EM algorithm.

If an \code{ipriorMod} object is input, then the EM starts from the last
obtained parameter values. This is particularly useful for very heavy models,
or models which have not yet converged after reaching the maximum number of
iterations. Running \code{iprior()} just continues the EM algorithm.

There are several model options available which primarily controls the number
and placement of scale parameters \code{lambda} in the model, although these
are not applicable when running the function on \code{ipriorMod} or
\code{ipriorKernel} objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{ipriorKernel}: Takes in object of type \code{ipriorKernel} and estimates
the parameters of the model via the EM algorithm.

\item \code{ipriorMod}: Re-run or continue running the EM algorithm from last
attained parameter values in object \code{ipriorMod}.
}}

\examples{
# Formula based input
(mod.stackf <- iprior(stack.loss ~ Air.Flow + Water.Temp + Acid.Conc.,
                      data = stackloss))
mod.toothf <- iprior(len ~ supp * dose, data = ToothGrowth)
summary(mod.toothf)

# Non-formula based input
mod.stacknf <- iprior(y = stackloss$stack.loss,
                      Air.Flow = stackloss$Air.Flow,
                      Water.Temp = stackloss$Water.Temp,
                      Acid.Conc. = stackloss$Acid.Conc.)
mod.toothnf <- iprior(y = ToothGrowth$len,
                      supp = ToothGrowth$supp,
                      dose = ToothGrowth$dose,
                      model = list(interactions = "1:2"))

# Formula based model option one.lam = TRUE
# Sets a single scale parameter for all variables
modf <- iprior(stack.loss ~ ., data = stackloss, model = list(one.lam = TRUE))
modnf <- iprior(y = stackloss$stack.loss, x = stackloss[1:3])

# Example of using the FBM kernel for smoothing models
mod <- kernL(y ~ x, datfbm, model = list(kernel = "FBM"))  # Hurst = 0.5 (default)
mod <- kernL(y ~ x, datfbm, model = list(kernel = "FBM,0.75"))  # custom Hurst

# Fit the model using EM starting at a specific parameter value
mod.fit <- iprior(mod, control = list(lambda = 8.41, psi = 0.33))

}
