% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfKnn}
\alias{ipfKnn}
\title{Implements the k-nearest neighbors algorithm}
\usage{
ipfKnn(train_fgp, train_pos, k = 3, method = "euclidean",
  weights = "distance", norm = 2, sd = 5, epsilon = 0.001, alpha = 1,
  threshold = 20, FUN = NULL, ...)
}
\arguments{
\item{train_fgp}{a data frame containing the fingerprint vectors of the training set}

\item{train_pos}{a data frame containing the positions of the training set observations}

\item{k}{the k parameter for knn algorithm (number of nearest neighbors)}

\item{method}{the method to compute the distance between the RSSI vectors:
'euclidean', 'manhattan', 'norm', 'LGD' or 'PLGD'}

\item{weights}{the algorithm to compute the weights: 'distance' or 'uniform'}

\item{norm}{parameter for the 'norm' method}

\item{sd}{parameter for 'LGD' and 'PLGD' methods}

\item{epsilon}{parameter for 'LGD' and 'PLGD' methods}

\item{alpha}{parameter for 'PLGD' method}

\item{threshold}{parameter for 'PLGD' method}

\item{FUN}{an alternative function provided to compute the distance.
This function must return a matrix of dimensions:
nrow(test) x nrow(train), containing the distances from
test observations to train observations. The two first parameters
taken by the function must be train and test}

\item{...}{additional parameters for provided function FUN}
}
\value{
An S4 class object of type ipfModel, with the following slots:
                 params ->     a list with the parameters passed to the function
                 data   ->     a list with the fingerprints and locations
}
\description{
Implements the k-nearest neighbors algorithm
}
\examples{

    model <- ipfKnn(ipftrain[, 1:168], ipftrain[, 169:170], k = 9, method = 'manhattan')

}
