% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipeadata_pkg.R
\name{search_series}
\alias{search_series}
\title{List with searched series}
\usage{
search_series(terms = NULL, fields = c('name'), language = c("en", "br"))
}
\arguments{
\item{terms}{A character vector with search terms.}

\item{fields}{A character vector with table fields where matches are sought. See 'Details'.}

\item{language}{String specifying the selected language. Language options are
English (\code{"en"}, default) and Brazilian portuguese (\code{"br"}).}
}
\value{
A data frame containing Ipeadata code, name, theme, source,
frequency, last update and activity status of searched series.
}
\description{
Returns a list with searched series by terms from Ipeadata API database.
}
\details{
The \code{fields} options are \code{"code"}, \code{"name"}, \code{"theme"}, 
\code{"source"}, \code{"freq"}, \code{"lastupdate"} and \code{"status"}.
}
\note{
The original language of the available series' names were preserved.
}
\examples{
\donttest{
# Search by 'ICMS' (Brazilian Tax on Circulation of Goods and Services) in 'name'
ICMS_series <- search_series(terms = c('ICMS'), fields = c('name'))

# Search by 'Portugal' in 'name'
Portugal_series <- search_series(terms = c('Portugal'), fields = c('name'))

}

}
