% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hostname.R
\name{hostname}
\alias{hostname}
\alias{as_hostname}
\alias{from_hostname}
\title{Translate address to/from hostname}
\usage{
as_hostname(ip, multiple = FALSE)

from_hostname(host, multiple = FALSE)
}
\arguments{
\item{ip}{An \code{\link{ip_address}} vector}

\item{multiple}{A logical scalar indicating if \emph{all} resolved endpoints are
returned, or just the first endpoint (the default). This determines whether
a vector or list of vectors is returned.}

\item{host}{A character vector of hostnames}
}
\value{
\itemize{
\item \code{as_hostname()} returns a character vector or a list of character vectors
(depending upon the \code{multiple} argument)
\item \code{from_hostname()} returns a \code{\link{ip_address}} vector or a list of
\code{\link{ip_address}} vectors (depending upon the \code{multiple} argument)
}
}
\description{
\code{as_hostname()} performs reverse DNS resolution (translating IP addresses
to hostnames)

\code{from_hostname()} performs forward DNS resolution (translating hostnames to
IP addresses)
}
\details{
These functions require an internet connection. Before processing the input
vector, we first check that a known hostname can be resolved. If this fails,
an error is raised.

If DNS lookup cannot resolve an input, then \code{NA} is returned for that input.
If an error occurs during DNS lookup, then a warning is emitted and \code{NA} is
returned for that input.

DNS resolution performs a many-to-many mapping between IP addresses and
hostnames. For this reason, these two functions can potentially return
multiple values for each element of the input vector. The \code{multiple} argument
control whether \emph{all} values are returned (a vector for each input), or
just the first value (a scalar for each input).
}
\examples{
\dontrun{
from_hostname("r-project.org")

as_hostname(from_hostname("r-project.org"))
}
}
\seealso{
The base function \code{\link[=nsl]{nsl()}} provides forward DNS resolution to IPv4 addresses,
but only on Unix-like systems.
}
