% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_coefficient_matrix_create.R
\name{output_coefficient_matrix_create}
\alias{output_coefficient_matrix_create}
\title{Create an output coefficient matrix}
\usage{
output_coefficient_matrix_create(io_table, total = "tfu", digits = NULL)
}
\arguments{
\item{io_table}{A symmetric input-output table or use table created with the
\code{\link{iotable_get}} function which contains the 'total' column. 
In case you use \code{type="tfu"} you need to input a
full iotable, create by the \code{\link{iotable_get}}, because you will need
the final demand column.}

\item{total}{The \code{output='total'} (or CPA_TOTAL, depending on the 
names in your table, default) returns the output coefficients
for products (intermediates) while the \code{final_demand} returns output 
coefficients for final demand. See Eurostat Manual, p495 and p507.}

\item{digits}{An integer showing the precision of the technology matrix in 
digits. Default is \code{NULL} when no rounding is applied.}
}
\value{
An output coefficient matrix of data.frame class. 
The column names are ordered, and the row names are in the 
first, auxiliary metadata column.
}
\description{
Create an output coefficient matrix from the input flow matrix or a symmetric
input-output table.
}
\details{
If there are zero values in present, they will be changed to 
0.000001 and you will get a warning. Some analytical equations cannot be 
solved with zero elements. You either have faulty input data, or you have 
to use some sort of data modification to carry on your analysis.
}
\examples{
io_table <- iotable_get() 

output_coefficient_matrix_create (io_table  = io_table, 
                                  total = 'tfu',
                                  digits = 4)
}
