% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tkstats_flat.R
\name{tkstats_flat}
\alias{tkstats_flat}
\title{TK stats for flat model}
\usage{
tkstats_flat(pars, route, medium, dose, time_unit, conc_unit, vol_unit, ...)
}
\arguments{
\item{pars}{A named numeric vector of model parameters (e.g. from [coef.pk()]).}

\item{route}{Character: The route for which to compute TK stats. Currently
only "oral" and "iv" are supported.}

\item{medium}{Character: the media (tissue) for which to compute TK stats.
Currently only "blood" and "plasma" are supported.}

\item{dose}{Numeric: A dose for which to calculate TK stats.}

\item{time_unit}{Character: the units of time.}

\item{conc_unit}{Character: The units of concentration.}

\item{vol_unit}{Character: The units of dose.}

\item{...}{Additional arguments not currently in use.}
}
\value{
A `data.frame` with two variables:
- `param_name` = `c("CLtot", "CLtot/Fgutabs", "Css_1mgkgday", "halflife", "Cmax", "AUC_infinity")`
- `param_value` = The corresponding values for each statistic (which may be NA if that statistic could not be computed).
}
\description{
TK stats for flat model
}
\author{
John Wambaugh, Caroline Ring
}
