% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_smr.R
\name{plot_smr}
\alias{plot_smr}
\title{Plot summary data}
\usage{
plot_smr(
  data,
  type = NULL,
  x = NULL,
  y = NULL,
  groups = NULL,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  limits = NULL,
  brakes = NULL,
  sig = NULL,
  error = NULL,
  legend = NULL
)
}
\arguments{
\item{data}{Data frame with summary data. See details.}

\item{type}{Type of plot  (default = "bar"). Others: "line".}

\item{x}{Variable in the x axis.}

\item{y}{Variable in the y axis.}

\item{groups}{Groups the x axis (legend).}

\item{xlab}{Label of x axis.}

\item{ylab}{Label of y axis.}

\item{glab}{Label of groups or legend.}

\item{limits}{Limits max and min.}

\item{brakes}{Units for break the limits.}

\item{sig}{Comparison test values (default = "sig").}

\item{error}{Variable used for error bars.}

\item{legend}{Position of legend (default = "top"). Others: "left", "right",
"bottom", "none".}
}
\value{
plot
}
\description{
Graph summary data into bar o line plot
}
\details{
If the table is a out put of \code{mean_comparison(graph_opts = TRUE)}
function. Its contain all the parameter for the plot.
}
\examples{

library(inti)
library(googlesheets4)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=172957346")
# browseURL(url)
gs <- as_sheets_id(url)

(data <- gs \%>\%
    range_read("LA"))

plot_smr(data)

plot_smr(data
         , type = "bar"
         , limits = c(0, 14000)
         , brakes = 2000
         , sig = "sig"
         , error = "ste"
         )
}

}
