% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/means_lm.R
\name{means_lm}
\alias{means_lm}
\title{Mean comparison}
\usage{
means_lm(
  data,
  trait,
  model,
  comparison,
  test = "SNK",
  anova = FALSE,
  plot_diag = FALSE,
  plot_treat = NULL,
  plot_groups = NULL,
  tab_vars = NULL,
  sep = NULL,
  digits = 3
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and traits.}

\item{trait}{Name of the trait.}

\item{model}{The effects in the model. See examples.}

\item{comparison}{Factor for the comparisons.}

\item{test}{Test comparison (default = "SNK"). Others: "TUKEY" & "DUNCAN".}

\item{anova}{ANOVA table (default = FALSE).}

\item{plot_diag}{Show diagnostic plots (default = FALSE).}

\item{plot_treat}{Treat of comparison in dot plot (default = NULL). See
example.}

\item{plot_groups}{Group of comparison in dot plot (default = NULL). See
example.}

\item{tab_vars}{Specific the variables in the summary table (default = NULL).}

\item{sep}{Separator between the variables when use \code{tab_vars}. See
details.}

\item{digits}{Number of digits in the table (default = 3).}
}
\value{
A list with two objects:

  1. Summary statistics.

  2. Means with the mean comparisons test.
}
\description{
Function to calculate the means using Linear models (lm or aov)
}
\details{
Using \code{tab_vars} select the variables shown the adjusted mean table with
the \code{sep}. Mean comparison at p < 0.05.
}
