% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{iprMakima}
\alias{iprMakima}
\title{Modified Akima interpolator}
\usage{
iprMakima(x, y)
}
\arguments{
\item{x, y}{numeric vectors giving the coordinates of the known points,
without missing value}
}
\value{
An interpolator, for usage in \code{\link{evalInterpolator}}.
}
\description{
Modified Akima interpolator.
}
\details{
See \href{https://www.boost.org/doc/libs/1_83_0/libs/math/doc/html/math_toolkit/makima.html}{Modified Akima interpolation}.
}
\examples{
library(interpolators)
x <- seq(0, 4*pi, length.out = 9L)
y <- x - sin(x)
ipr <- iprMakima(x, y)
curve(x - sin(x), from = 0, to = 4*pi, lwd = 2)
curve(
  evalInterpolator(ipr, x),
  add = TRUE, col = "blue", lwd = 3, lty = "dashed"
)
points(x, y, pch = 19)
}
