% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structured_data.R
\name{structured_data}
\alias{structured_data}
\title{\emph{structured_data}: function to organize structured datasets.}
\usage{
structured_data(
  ...,
  datasetType = NULL,
  responsePA = NULL,
  trialsPA = NULL,
  responseCount = NULL,
  speciesName = "species",
  coordinateNames = c("longitude", "latitude")
)
}
\arguments{
\item{...}{The datasets used in the model. May be either datasets or a SpatialPointsDataFrames.}

\item{datasetType}{A vector which gives the type of dataset. Must be either \code{'count'}, \code{'PO'} or \code{'PA'}. Defaults to \code{NULL}.}

\item{responsePA}{Name of the response variable in the \code{PA} datasets. Defaults to \code{NULL}.}

\item{trialsPA}{Name of the trial name variable in the \code{PA} datasets. Defaults to \code{NULL}.}

\item{responseCount}{Name of the response variable in the \code{count} datasets. Defaults to \code{NULL}.}

\item{speciesName}{Name of the species variable name. Defaults to \code{'species'}.}

\item{coordinateNames}{Name of the coordinates used in the model. Defaults to \code{c('longitude', 'latitude')}.}
}
\value{
An S4 object of class \code{structuredData}, which contains three slots for the data of each observation model allowed in the framework.
}
\description{
The function is used to convert a collection of structured datasets into an object which can be used in \code{speciesModel}. The three types of structured data allowed by this function are present absence (PA), present only (PO) and counts/abundance datasets, which are controlled using the \code{datasetType} argument. The other arguments of this function are used to specify the appropriate variable (such as response name, trial name, species name and coordinate name) names in these datasets.
}
\examples{
{

 #Objects required for example
 data("PA_redlist")
 speciesNames <- c('Fraxinus excelsior', 'Ulmus glabra')

 #Set up structured dataset
   dataObj <- structured_data(PA_redlist, datasetType = c('PA'), responsePA = 'individualCount',
                             speciesName = 'species',
                             coordinateNames = c("longitude", "latitude" ))

}

}
