% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_package_create.R
\name{stan_package_create}
\alias{stan_package_create}
\title{Create example package with a built-in Stan model.}
\usage{
stan_package_create(path = tempfile())
}
\arguments{
\item{path}{Path to write the package. Must not already exist.}
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
Create an example package with a Stan model inside.
}
\details{
After creating the package, the next step is to
configure it with \code{\link[=stan_package_configure]{stan_package_configure()}}. After that,
install it as an ordinary R package to automatically compile the models.
}
\examples{
if (identical(Sys.getenv("INSTANTIATE_EXAMPLES"), "true")) {
path <- tempfile()
stan_package_create(path = path)
list.files(path)
}
}
\keyword{packages}
