% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_cmdstan_version.R
\name{stan_cmdstan_version}
\alias{stan_cmdstan_version}
\title{Version of CmdStan that \code{instantiate} uses.}
\usage{
stan_cmdstan_version(
  cmdstan_install = Sys.getenv("CMDSTAN_INSTALL", unset = ""),
  error_on_NA = TRUE
)
}
\arguments{
\item{cmdstan_install}{Character of length 1, how to look for an installed
copy of CmdStan. See \url{https://wlandau.github.io/instantiate/} for details.
Choices:
\enumerate{
\item \code{""} (default): look at the original value that the \code{CMDSTAN_INSTALL}
environment variable contained when \code{instantiate} at the time
when it was installed.
If it was \code{"implicit"} or \code{"fixed"}, then choose
the corresponding option below. Otherwise, default to \code{"implicit"}.
\item \code{"implicit"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. As explained in the \code{cmdstanr} documentation,
the output of \code{cmdstanr::cmdstan_path()} depends
on the current value of the \code{CMDSTAN} environment variable.
The \code{cmdstanr} package must be installed. If it
is not installed, then \code{stan_cmdstan_path()}
returns the empty string \code{""}.
\item \code{"fixed"}: Use the path to CmdStan that was originally
contained in \code{Sys.getenv("CMDSTAN")} at the time when \code{instantiate}
was installed.
}}

\item{error_on_NA}{Logical of length 1, whether an error should be thrown
if CmdStan is not found.}
}
\value{
Character of length 1, version of CmdStan that the \code{instantiate}
package uses. If CmdStan is not found, then the return value depends
on the \code{error_on_NA} argument.
}
\description{
Return the version of CmdStan that the \code{instantiate}
package uses.
}
\examples{
if (stan_cmdstan_exists()) {
  message(stan_cmdstan_version())
}
}
\seealso{
Other cmdstan: 
\code{\link{stan_cmdstan_exists}()}
}
\concept{cmdstan}
