% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/searchInstagram.R
\name{searchInstagram}
\alias{searchInstagram}
\title{Search public media that mention a specific hashtag, or that were sent
from a given area}
\usage{
searchInstagram(tag = NULL, token, n = 100, lat = NULL, lng = NULL,
  distance = NULL, folder = NULL, mindate = NULL, maxdate = NULL,
  verbose = TRUE, sleep = 0)
}
\arguments{
\item{tag}{Hashtag used to filter media. It is only possible for a single
hashtag.}

\item{token}{An OAuth token created with \code{instaOAuth}.}

\item{n}{Maximum number of media to return.}

\item{lat}{Latitude of the center search coordinate}

\item{lng}{Longitude of the center search coordinate}

\item{distance}{Default is 1km (distance=1000), max distance is 5km.}

\item{folder}{If different than \code{NULL}, will download all pictures
to this folder.}

\item{mindate}{Minimum date for search period}

\item{maxdate}{Maximum date for search period}

\item{verbose}{If \code{TRUE} (default), outputs details about progress
of function on the console.}

\item{sleep}{Number of seconds between API calls (default is 0).}
}
\description{
\code{searchInstagram} retrieves public pictures and video whose caption
mentions a given hashtag, or that were sent within a given area, delimited
by a set of coordinates and a radius. It returns a data frame with
information about each picture or video, and optionally will download
all pictures to a specific folder
}
\details{
It is only possible to apply one filter at a time: either search by hashtag
OR search by coordinates.

The \code{mindate} and \code{maxdata} search parameters only work when searching
by location, not when searching by tag.
}
\examples{
\dontrun{
## See examples for instaOAuth to know how token was created.
## Searching and downloading 100 public media that mention #obama
 load("my_oauth")
 obama <- searchInstagram( tag="obama", token=my_oauth, n=100, folder="obama")
## Searching and downloading pictures sent from Times Square with a minimum date
## of 2013-12-31 and a maximum date of 2014-01-01
 tsq <- searchInstagram( lat=40.7577, lng=-73.9857, distance=500,
    token=my_oauth, n=500, folder="timessquare",
    mindate="2014-12-31", maxdate="2014-01-01")
}
}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{instaOAuth}}
}

