% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_cat.R
\name{inspect_cat}
\alias{inspect_cat}
\title{Summarise and compare the levels for each categorical feature in one or two dataframes.}
\usage{
inspect_cat(df1, df2 = NULL, show_plot = FALSE)
}
\arguments{
\item{df1}{A dataframe}

\item{df2}{An optional second data frame for comparing categorical levels.
Defaults to \code{NULL}.}

\item{show_plot}{(Deprecated) Logical flag indicating whether a plot should be shown.
Superseded by the function \code{show_plot()} and will be dropped in a future version.}
}
\value{
A tibble summarising or comparing the categorical features 
in one or a pair of dataframes.
}
\description{
Summarise and compare the levels for each categorical feature in one or two dataframes.
}
\details{
When \code{df2 = NULL}, a tibble containing summaries of the categorical features in 
\code{df1} is returned:
\itemize{
  \item \code{col_name} character vector containing column names of \code{df1}.
  \item \code{cnt} integer column containing count of unique levels found in each column, 
  including \code{NA}.
  \item \code{common} character column containing the name of the most common level.
  \item \code{common_pcnt} percentage of each column occupied by the most common level shown in 
  \code{common}.
  \item \code{levels} names list containing relative frequency tibbles for each feature.
}
When \code{df1} and \code{df2} are specified, a comparison of the relative frequencies 
of levels in common columns is performed.  In particular, Jensen-Shannon divergence and 
Fisher's exact test are returned as part of the comparison.
\itemize{
  \item \code{col_name} character vector containing names of columns appearing in both 
  \code{df1} and \code{df2}.
  \item \code{jsd} numeric column containing the Jensen-Shannon divergence.  This measures the 
  difference in relative frequencies of levels in a pair of categorical features.  Values near 
  to 0 indicate agreement of the distributions, while 1 indicates disagreement.
  \item \code{fisher_p} p-value corresponding to Fisher's exact test.  A small p indicates 
  evidence that the the two sets of relative frequencies are actually different.
  \item \code{lvls_1}, \code{lvls_2} relative frequency of levels in each of \code{df1} and \code{df2}.
}
}
\examples{
data("starwars", package = "dplyr")
inspect_cat(starwars)
# compare the levels in two data frames
inspect_cat(starwars, starwars[1:20, ])
}
