% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulize.R
\name{tabulize}
\alias{tabulize}
\title{Tabulate classification output.}
\usage{
tabulize(y, db, aggregated = FALSE, ranks = c("kingdom", "phylum", "class",
  "order", "family", "genus", "species"))
}
\arguments{
\item{y}{a character vector of semicolon-delimited lineage strings
or a list of such vectors, as output from the function \code{classify}.}

\item{db}{a copy of the NCBI taxonomy database.
See \code{\link{download_taxon}} for details.}

\item{aggregated}{logical indicating whether the output table
should be aggregated by taxon ID, rather than having one row
for each unique sequence. Defaults to FALSE.}

\item{ranks}{character vector giving the taxonomic ranks to be
included in the output table. Must be a valid rank from the
NCBI taxonomy database (see https://www.ncbi.nlm.nih.gov/taxonomy).}
}
\value{
a data frame.
}
\description{
This function presents taxonomic classifications in tabular format
  for ease of interpretation, including sequence counts for each sample.
  This facilitates exporting the classification output to csv or xlsx files.
}
\examples{
\donttest{
  ## download and extract example FASTQ file to temporary directory
  td <- tempdir()
  URL1 <- "https://www.dropbox.com/s/71ixehy8e51etdd/insect_tutorial1_files.zip?dl=1"
  dest <- paste0(td, "/insect_tutorial1_files.zip")
  download.file(URL1, destfile = dest, mode = "wb")
  unzip(dest, exdir = td)
  x <- readFASTQ(paste0(td, "/COI_sample2.fastq"))
  ## trim primers from sequences
  mlCOIintF <- "GGWACWGGWTGAACWGTWTAYCCYCC"
  jgHCO2198 <- "TAIACYTCIGGRTGICCRAARAAYCA"
  x <- trim(x, up = mlCOIintF, down = jgHCO2198)
  ## quality filtering with size selection and singleton removal
  x <- qfilter(x, minlength = 250, maxlength = 350)

  ## download pre-computed classification tree bundle (35.5 MB)
  ## bundle includes tree ("tree"), reference db ("z"), and NCBI taxon db ("taxonomy")
  URL2 <- "https://www.dropbox.com/s/m0on8ykooa9buoz/mlCOIintF_jgHCO2198_marine.RData?dl=1"
  bundle <- paste0(td, "/mlCOIintF_jgHCO2198_marine.RData")
  download.file(URL2, destfile = bundle, mode = "wb")
  load(bundle)

  ## classify sequences (takes a minute or so)
  y <- classify(x, tree, cores = 2)
  ## output taxon ID frequency tables
  shortDF <- tabulize(y, db = taxonomy, aggregated = TRUE)
  longDF <- tabulize(y, db = taxonomy, aggregated = FALSE)
}
}
\author{
Shaun Wilkinson
}
