% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purge.R
\name{purge}
\alias{purge}
\title{Identify and remove sequences with potentially erroneous lineage metadata.}
\usage{
purge(x, db, level = "order", threshold = 0.97, cores = 1,
  quiet = FALSE)
}
\arguments{
\item{x}{a DNAbin list object with "taxID", "lineage" and/or "species" attributes
(see \code{\link{searchGB}} for details).}

\item{db}{a copy of the NCBI taxonomy database as a data.frame object
(see \code{\link{download_taxon}}).}

\item{level}{character string giving the taxonomic level at which
heterogeneity within a cluster will flag a sequence as potentially erroneous.
This should be a recognized rank within the NCBI taxonomy database.}

\item{threshold}{numeric between 0 and 1 giving the OTU similarity cutoff value
with which to cluster the sequences. Defaults to 0.97.}

\item{cores}{integer giving the number of CPUs to parallelize the operation
over. Defaults to 1.
This argument may alternatively be a 'cluster' object,
in which case it is the user's responsibility to close the socket
connection at the conclusion of the operation,
for example by running \code{parallel::stopCluster(cores)}.
The string 'autodetect' is also accepted, in which case the maximum
number of cores to use is one less than the total number of cores available.
Note that in this case there
may be a tradeoff in terms of speed depending on the number and size
of sequences to be processed, due to the extra time required to initialize
the cluster.}

\item{quiet}{logical indicating whether progress should be printed to the console.}
}
\value{
a "DNAbin" object with "taxID", "lineage", and/or "species" attributes,
  depending on the attributes of the input object.
}
\description{
This function evaluates a DNA reference database
   (a "DNAbin" object with "taxID", "lineage" and/or "species" attributes;
   see \code{\link{searchGB}} for details)
   and removes any sequences whose taxonomic metadata appear to be inconsistent
   with those of the most closely related sequences.
}
\details{
This function first clusters the sequence dataset into operational
  taxonomic units (OTUs) based on a given genetic similarity threshold
  using the \code{\link[kmer]{otu}} function from the \code{\link{kmer}}
  package.
  Each cluster is then checked for lineage homogeneity at a given taxonomic rank,
  and any sequences that appear out of place based on the taxon/lineage metadata
  of the other OTU members are removed.
  The criteria for sequence removal are that at least two other independent
  studies should contradict the taxonomic metadata attributed to the sequence.
}
\examples{
  data(whales)
  data(whale_taxa)
  whales <- purge(whales, db = whale_taxa, level = "species")
}
\author{
Shaun Wilkinson
}
