% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innsight_sugar.R
\name{innsight_sugar}
\alias{innsight_sugar}
\alias{convert}
\alias{run_grad}
\alias{run_smoothgrad}
\alias{run_intgrad}
\alias{run_expgrad}
\alias{run_lrp}
\alias{run_deeplift}
\alias{run_deepshap}
\alias{run_cw}
\alias{run_lime}
\alias{run_shap}
\title{Syntactic sugar for object construction}
\usage{
# Create a new `Converter` object of the given `model`
convert(model, ...)

# Apply the `Gradient` method to the passed `data` to be explained
run_grad(converter, data, ...)

# Apply the `SmoothGrad` method to the passed `data` to be explained
run_smoothgrad(converter, data, ...)

# Apply the `IntegratedGradient` method to the passed `data` to be explained
run_intgrad(converter, data, ...)

# Apply the `ExpectedGradient` method to the passed `data` to be explained
run_expgrad(converter, data, ...)

# Apply the `LRP` method to the passed `data` to be explained
run_lrp(converter, data, ...)

# Apply the `DeepLift` method to the passed `data` to be explained
run_deeplift(converter, data, ...)

# Apply the `DeepSHAP` method to the passed `data` to be explained
run_deepshap(converter, data, ...)

# Apply the `ConnectionWeights` method (argument `data` is not always required)
run_cw(converter, ...)

# Apply the `LIME` method to explain `data` by using the dataset `data_ref`
run_lime(model, data, data_ref, ...)

# Apply the `SHAP` method to explain `data` by using the dataset `data_ref`
run_shap(model, data, data_ref, ...)
}
\arguments{
\item{model}{(\code{\link{nn_sequential}}, \code{\link[keras]{keras_model}},
\code{\link[neuralnet]{neuralnet}} or \code{list})\cr
A trained neural network for classification or regression
tasks to be interpreted. Only models from the following types or
packages are allowed: \code{\link[torch]{nn_sequential}},
\code{\link[keras]{keras_model}},
\code{\link[keras]{keras_model_sequential}},
\code{\link[neuralnet]{neuralnet}} or a named list (see details).\cr
\strong{Note:} For the model-agnostic methods, an arbitrary fitted model for a
classification or regression task can be passed. A \code{\link{Converter}} object can
also be passed. In order for the package to know how to make predictions
with the given model, a prediction function must also be passed with
the argument \code{pred_fun}. However, for models created by
\code{\link[torch]{nn_sequential}}, \code{\link[keras]{keras_model}},
\code{\link[neuralnet]{neuralnet}} or \code{\link{Converter}},
these have already been pre-implemented and do not need to be
specified.\cr}

\item{...}{Other arguments passed to the individual constructor functions
of the methods R6 classes.}

\item{converter}{(\code{\link{Converter}})\cr
An instance of the \code{Converter} class that includes the
torch-converted model and some other model-specific attributes. See
\code{\link{Converter}} for details.\cr}

\item{data}{(\code{\link{array}}, \code{\link{data.frame}}, \code{\link{torch_tensor}} or \code{list})\cr
The data to which the method is to be applied. These must
have the same format as the input data of the passed model to the
converter object. This means either
\itemize{
\item an \code{array}, \code{data.frame}, \code{torch_tensor} or array-like format of
size \emph{(batch_size, dim_in)}, if e.g., the model has only one input layer, or
\item a \code{list} with the corresponding input data (according to the
upper point) for each of the input layers.
}
\strong{Note:} For the model-agnostic methods, only models with a single
input and output layer is allowed!\cr}

\item{data_ref}{(\code{\link{array}}, \code{\link{data.frame}} or \code{\link{torch_tensor}})\cr
The dataset to which the method is to be applied. These must
have the same format as the input data of the passed model and has to
be either \code{\link{matrix}}, an \code{\link{array}}, a \code{\link{data.frame}} or a
\code{\link{torch_tensor}}.\cr
\strong{Note:} For the model-agnostic methods, only models with a single
input and output layer is allowed!\cr}
}
\value{
\link[R6:R6Class]{R6::R6Class} object of the respective type.
}
\description{
Since all methods and the preceding conversion step in the \code{innsight}
package were implemented using R6 classes and these always require a call
to \code{classname$new()} for initialization, the following functions are
defined to shorten the construction of the corresponding R6 objects:
\itemize{
\item \code{convert()} for \code{\link{Converter}}
\item \code{run_grad()} for \code{\link{Gradient}}
\item \code{run_smoothgrad()} for \code{\link{SmoothGrad}}
\item \code{run_intgrad()} for \code{\link{IntegratedGradient}}
\item \code{run_expgrad()} for \code{\link{ExpectedGradient}}
\item \code{run_lrp()} for \code{\link{LRP}}
\item \code{run_deeplift()} for \code{\link{DeepLift}}
\item \code{run_deepshap} for \code{\link{DeepSHAP}}
\item \code{run_cw} for \code{\link{ConnectionWeights}}
\item \code{run_lime} for \code{\link{LIME}}
\item \code{run_shap} for \code{\link{SHAP}}
}
}
