% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authors.R
\docType{data}
\name{authors}
\alias{authors}
\title{Contributing Authors to INLPO Publications}
\format{
An object of class 'author' that inherits behavior from the 'data.frame' class
and includes the following columns:
\describe{
\item{\code{author_id}}{Unique identifier for the author.}
\item{\code{name}}{Name of author, surname first and initials or given name.}
\item{\code{person}}{Information about the \link[utils:person]{person}
like email address and \href{https://orcid.org/}{ORCiD} identifier.}
\item{\code{pub_id}}{Identifier(s) of the publication(s) the author has contributed to,
referes to the primry key of the \code{\link{pubs}} data table.}
\item{\code{total_pub}}{Total number of publications.}
\item{\code{single_authored}}{Number of single-authored publications.}
\item{\code{multi_authored}}{Number of multi-authored publications.}
\item{\code{first_authored}}{Number of multi-authored publications where the researcher appears as first author.}
\item{\code{first_year}}{First year author published.}
\item{\code{last_year}}{Last year author published.}
}
}
\source{
Curated by INLPO staff.
}
\usage{
authors
}
\description{
Authors who have contributed to the publications by the U.S. Geological Survey (USGS),
Idaho Water Science Center, Idaho National Laboratory Project Office (INLPO).
}
\examples{
# Subset Jason Fisher's information and display structure:
author <- authors["jfisher", ]
str(author, max.level = 3, width = 75, strict.width = "cut")

# Print author's given name:
author$person |> format(include = "given")
}
\keyword{datasets}
